/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.collection;

import io.netty.util.collection.IntObjectMap;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IntObjectHashMap<V>
implements IntObjectMap<V>,
Iterable<IntObjectMap.Entry<V>> {
    private static final byte AVAILABLE = 0;
    private static final byte OCCUPIED = 1;
    private static final byte REMOVED = 2;
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private int maxSize;
    private final float loadFactor;
    private byte[] states;
    private int[] keys;
    private V[] values;
    private int size;
    private int available;

    public IntObjectHashMap() {
        this(11, 0.5f);
    }

    public IntObjectHashMap(int initialCapacity) {
        this(initialCapacity, 0.5f);
    }

    public IntObjectHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("initialCapacity must be >= 1");
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0");
        }
        this.loadFactor = loadFactor;
        initialCapacity = IntObjectHashMap.adjustCapacity(initialCapacity);
        this.states = new byte[initialCapacity];
        this.keys = new int[initialCapacity];
        Object[] temp = new Object[initialCapacity];
        this.values = temp;
        this.maxSize = this.calcMaxSize(initialCapacity);
        this.available = initialCapacity - this.size;
    }

    @Override
    public V get(int key) {
        int index = this.indexOf(key);
        return index < 0 ? null : (V)this.values[index];
    }

    @Override
    public V put(int key, V value) {
        int hash = IntObjectHashMap.hash(key);
        int capacity = this.capacity();
        int index = hash % capacity;
        int increment = 1 + hash % (capacity - 2);
        int startIndex = index;
        int firstRemovedIndex = -1;
        do {
            switch (this.states[index]) {
                case 0: {
                    if (firstRemovedIndex != -1) {
                        this.insertAt(firstRemovedIndex, key, value);
                        return null;
                    }
                    this.insertAt(index, key, value);
                    return null;
                }
                case 1: {
                    if (this.keys[index] != key) break;
                    V previousValue = this.values[index];
                    this.insertAt(index, key, value);
                    return previousValue;
                }
                case 2: {
                    if (firstRemovedIndex != -1) break;
                    firstRemovedIndex = index;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Invalid state: " + this.states[index]));
                }
            }
            if ((index += increment) < capacity) continue;
            index -= capacity;
        } while (index != startIndex);
        if (firstRemovedIndex == -1) {
            throw new AssertionError((Object)"Unable to insert");
        }
        this.insertAt(firstRemovedIndex, key, value);
        return null;
    }

    @Override
    public void putAll(IntObjectMap<V> sourceMap) {
        if (sourceMap instanceof IntObjectHashMap) {
            IntObjectHashMap source = (IntObjectHashMap)sourceMap;
            int i = -1;
            while ((i = source.nextEntryIndex(i + 1)) >= 0) {
                this.put(source.keys[i], source.values[i]);
            }
            return;
        }
        for (IntObjectMap.Entry<V> entry : sourceMap.entries()) {
            this.put(entry.key(), entry.value());
        }
    }

    @Override
    public V remove(int key) {
        int index = this.indexOf(key);
        if (index < 0) {
            return null;
        }
        V prev = this.values[index];
        this.removeAt(index);
        return prev;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.states, (byte)0);
        Arrays.fill(this.values, null);
        this.size = 0;
        this.available = this.capacity();
    }

    @Override
    public boolean containsKey(int key) {
        return this.indexOf(key) >= 0;
    }

    @Override
    public boolean containsValue(V value) {
        int i = -1;
        while ((i = this.nextEntryIndex(i + 1)) >= 0) {
            V next = this.values[i];
            if (value != next && (value == null || !value.equals(next))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<IntObjectMap.Entry<V>> entries() {
        return this;
    }

    @Override
    public Iterator<IntObjectMap.Entry<V>> iterator() {
        return new IteratorImpl();
    }

    @Override
    public int[] keys() {
        int[] outKeys = new int[this.size()];
        this.copyEntries(this.keys, outKeys);
        return outKeys;
    }

    @Override
    public V[] values(Class<V> clazz) {
        Object[] outValues = (Object[])Array.newInstance(clazz, this.size());
        this.copyEntries(this.values, outValues);
        return outValues;
    }

    private void copyEntries(Object sourceArray, Object targetArray) {
        int sourceIx = -1;
        int targetIx = 0;
        while ((sourceIx = this.nextEntryIndex(sourceIx + 1)) >= 0) {
            Object obj = Array.get(sourceArray, sourceIx);
            Array.set(targetArray, targetIx++, obj);
        }
    }

    private int indexOf(int key) {
        int index;
        int hash = IntObjectHashMap.hash(key);
        int capacity = this.capacity();
        int increment = 1 + hash % (capacity - 2);
        int startIndex = index = hash % capacity;
        do {
            switch (this.states[index]) {
                case 0: {
                    return -1;
                }
                case 1: {
                    if (key != this.keys[index]) break;
                    return index;
                }
            }
            if ((index += increment) < capacity) continue;
            index -= capacity;
        } while (index != startIndex);
        return -1;
    }

    private int capacity() {
        return this.keys.length;
    }

    private static int hash(int key) {
        return key & Integer.MAX_VALUE;
    }

    private void insertAt(int index, int key, V value) {
        byte state = this.states[index];
        if (state != 1) {
            ++this.size;
            if (state == 0) {
                --this.available;
            }
        }
        this.keys[index] = key;
        this.values[index] = value;
        this.states[index] = 1;
        if (this.size > this.maxSize) {
            this.rehash(IntObjectHashMap.adjustCapacity(this.capacity() * 2));
        } else if (this.available == 0) {
            this.rehash(this.capacity());
        }
    }

    private static int adjustCapacity(int capacity) {
        return capacity | 1;
    }

    private void removeAt(int index) {
        if (this.states[index] == 1) {
            --this.size;
        }
        this.states[index] = 2;
        this.values[index] = null;
    }

    private int calcMaxSize(int capacity) {
        int upperBound = capacity - 1;
        return Math.min(upperBound, (int)((float)capacity * this.loadFactor));
    }

    private void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        int[] oldKeys = this.keys;
        V[] oldVals = this.values;
        byte[] oldStates = this.states;
        this.states = new byte[newCapacity];
        this.keys = new int[newCapacity];
        Object[] temp = new Object[newCapacity];
        this.values = temp;
        this.size = 0;
        this.available = newCapacity;
        this.maxSize = this.calcMaxSize(newCapacity);
        for (int i = 0; i < oldCapacity; ++i) {
            if (oldStates[i] != 1) continue;
            this.put(oldKeys[i], oldVals[i]);
        }
    }

    private int nextEntryIndex(int index) {
        int capacity = this.capacity();
        while (index < capacity) {
            if (this.states[index] == 1) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private final class EntryImpl
    implements IntObjectMap.Entry<V> {
        final int index;

        EntryImpl(int index) {
            this.index = index;
        }

        @Override
        public int key() {
            return IntObjectHashMap.this.keys[this.index];
        }

        @Override
        public V value() {
            return IntObjectHashMap.this.values[this.index];
        }

        @Override
        public void setValue(V value) {
            ((IntObjectHashMap)IntObjectHashMap.this).values[this.index] = value;
        }
    }

    private final class IteratorImpl
    implements Iterator<IntObjectMap.Entry<V>> {
        int prevIndex = -1;
        int nextIndex;

        IteratorImpl() {
            this.nextIndex = IntObjectHashMap.this.nextEntryIndex(0);
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        @Override
        public IntObjectMap.Entry<V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prevIndex = this.nextIndex;
            this.nextIndex = IntObjectHashMap.this.nextEntryIndex(this.nextIndex + 1);
            return new EntryImpl(this.prevIndex);
        }

        @Override
        public void remove() {
            if (this.prevIndex < 0) {
                throw new IllegalStateException("Next must be called before removing.");
            }
            IntObjectHashMap.this.removeAt(this.prevIndex);
            this.prevIndex = -1;
        }
    }
}

