/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import sun.misc.Cleaner;
import sun.misc.Unsafe;

final class PlatformDependent0 {
    private static final Unsafe UNSAFE;
    private static final long CLEANER_FIELD_OFFSET;
    private static final long ADDRESS_FIELD_OFFSET;
    private static final boolean UNALIGNED;
    private static final boolean HAS_COPY_METHODS;

    static boolean hasUnsafe() {
        return UNSAFE != null;
    }

    static boolean canFreeDirectBuffer() {
        return ADDRESS_FIELD_OFFSET >= 0L;
    }

    static long directBufferAddress(ByteBuffer buffer) {
        if (!PlatformDependent0.isUnaligned()) {
            throw new Error();
        }
        return PlatformDependent0.getLong(buffer, ADDRESS_FIELD_OFFSET);
    }

    static void freeDirectBuffer(ByteBuffer buffer) {
        try {
            Cleaner cleaner = (Cleaner)PlatformDependent0.getObject(buffer, CLEANER_FIELD_OFFSET);
            cleaner.clean();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static boolean isUnaligned() {
        return UNALIGNED;
    }

    static boolean hasCopyMethods() {
        return HAS_COPY_METHODS;
    }

    static long arrayBaseOffset() {
        return UNSAFE.arrayBaseOffset(byte[].class);
    }

    static Object getObject(Object object, long fieldOffset) {
        return UNSAFE.getObject(object, fieldOffset);
    }

    private static long getLong(Object object, long fieldOffset) {
        return UNSAFE.getLong(object, fieldOffset);
    }

    static long objectFieldOffset(Field field) {
        return UNSAFE.objectFieldOffset(field);
    }

    static byte getByte(long address) {
        return UNSAFE.getByte(address);
    }

    static short getShort(long address) {
        return UNSAFE.getShort(address);
    }

    static int getInt(long address) {
        return UNSAFE.getInt(address);
    }

    static long getLong(long address) {
        return UNSAFE.getLong(address);
    }

    static void putByte(long address, byte value) {
        UNSAFE.putByte(address, value);
    }

    static void putShort(long address, short value) {
        UNSAFE.putShort(address, value);
    }

    static void putInt(long address, int value) {
        UNSAFE.putInt(address, value);
    }

    static void putLong(long address, long value) {
        UNSAFE.putLong(address, value);
    }

    static void copyMemory(long srcAddr, long dstAddr, long length) {
        UNSAFE.copyMemory(srcAddr, dstAddr, length);
    }

    static void copyMemory(Object src, long srcOffset, Object dst, long dstOffset, long length) {
        UNSAFE.copyMemory(src, srcOffset, dst, dstOffset, length);
    }

    private PlatformDependent0() {
    }

    static {
        Unsafe unsafe;
        try {
            Field singleoneInstanceField = Unsafe.class.getDeclaredField("theUnsafe");
            singleoneInstanceField.setAccessible(true);
            unsafe = (Unsafe)singleoneInstanceField.get(null);
        }
        catch (Throwable cause) {
            unsafe = null;
        }
        UNSAFE = unsafe;
        if (unsafe == null) {
            CLEANER_FIELD_OFFSET = -1L;
            ADDRESS_FIELD_OFFSET = -1L;
            UNALIGNED = false;
            HAS_COPY_METHODS = false;
        } else {
            boolean hasCopyMethods;
            boolean unaligned;
            Field cleanerField;
            ByteBuffer direct = ByteBuffer.allocateDirect(1);
            try {
                cleanerField = direct.getClass().getDeclaredField("cleaner");
                cleanerField.setAccessible(true);
                Cleaner cleaner = (Cleaner)cleanerField.get(direct);
                cleaner.clean();
            }
            catch (Throwable t) {
                cleanerField = null;
            }
            CLEANER_FIELD_OFFSET = cleanerField != null ? PlatformDependent0.objectFieldOffset(cleanerField) : -1L;
            try {
                Class<?> bitsClass = Class.forName("java.nio.Bits", false, ClassLoader.getSystemClassLoader());
                Method unalignedMethod = bitsClass.getDeclaredMethod("unaligned", new Class[0]);
                unalignedMethod.setAccessible(true);
                unaligned = Boolean.TRUE.equals(unalignedMethod.invoke(null, new Object[0]));
            }
            catch (Throwable t) {
                unaligned = false;
            }
            if (unaligned) {
                Field addressField = null;
                try {
                    addressField = Buffer.class.getDeclaredField("address");
                    addressField.setAccessible(true);
                    if (addressField.getLong(ByteBuffer.allocate(1)) != 0L) {
                        unaligned = false;
                    } else {
                        ByteBuffer directBuf = ByteBuffer.allocateDirect(1);
                        if (addressField.getLong(directBuf) == 0L) {
                            unaligned = false;
                        }
                        PlatformDependent0.freeDirectBuffer(directBuf);
                    }
                }
                catch (Throwable t) {
                    unaligned = false;
                }
                ADDRESS_FIELD_OFFSET = addressField != null ? PlatformDependent0.objectFieldOffset(addressField) : -1L;
            } else {
                ADDRESS_FIELD_OFFSET = -1L;
            }
            UNALIGNED = unaligned;
            try {
                UNSAFE.getClass().getDeclaredMethod("copyMemory", Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
                hasCopyMethods = true;
            }
            catch (Throwable ignore) {
                hasCopyMethods = false;
            }
            HAS_COPY_METHODS = hasCopyMethods;
        }
    }
}

