/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class UniqueName
implements Comparable<UniqueName> {
    private static final AtomicInteger nextId = new AtomicInteger();
    private final int id;
    private final String name;

    public UniqueName(ConcurrentMap<String, Boolean> map, String name, Object ... args) {
        if (map == null) {
            throw new NullPointerException("map");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (args != null && args.length > 0) {
            this.validateArgs(args);
        }
        if (map.putIfAbsent(name, Boolean.TRUE) != null) {
            throw new IllegalArgumentException(String.format("'%s' already in use", name));
        }
        this.id = nextId.incrementAndGet();
        this.name = name;
    }

    protected void validateArgs(Object ... args) {
    }

    public final String name() {
        return this.name;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int compareTo(UniqueName o) {
        if (this == o) {
            return 0;
        }
        int ret = this.name.compareTo(o.name);
        if (ret != 0) {
            return ret;
        }
        if (this.id < o.id) {
            return -1;
        }
        if (this.id > o.id) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.name();
    }
}

