/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.protobuf;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProtobufVarint32FrameDecoderTest {
    private EmbeddedChannel ch;

    @Before
    public void setUp() {
        this.ch = new EmbeddedChannel(new ChannelHandler[]{new ProtobufVarint32FrameDecoder()});
    }

    @Test
    public void testTinyDecode() {
        byte[] b = new byte[]{4, 1, 1, 1, 1};
        Assert.assertFalse((boolean)this.ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])b, (int)0, (int)1)}));
        MatcherAssert.assertThat((Object)this.ch.readInbound(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertFalse((boolean)this.ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])b, (int)1, (int)2)}));
        MatcherAssert.assertThat((Object)this.ch.readInbound(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertTrue((boolean)this.ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])b, (int)3, (int)(b.length - 3))}));
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])new byte[]{1, 1, 1, 1});
        ByteBuf actual = (ByteBuf)this.ch.readInbound();
        MatcherAssert.assertThat((Object)expected, (Matcher)Is.is((Object)actual));
        Assert.assertFalse((boolean)this.ch.finish());
        expected.release();
        actual.release();
    }

    @Test
    public void testRegularDecode() {
        byte[] b = new byte[2048];
        for (int i = 2; i < 2048; ++i) {
            b[i] = 1;
        }
        b[0] = -2;
        b[1] = 15;
        Assert.assertFalse((boolean)this.ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])b, (int)0, (int)1)}));
        MatcherAssert.assertThat((Object)this.ch.readInbound(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertFalse((boolean)this.ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])b, (int)1, (int)127)}));
        MatcherAssert.assertThat((Object)this.ch.readInbound(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertFalse((boolean)this.ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])b, (int)127, (int)600)}));
        MatcherAssert.assertThat((Object)this.ch.readInbound(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertTrue((boolean)this.ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])b, (int)727, (int)(b.length - 727))}));
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])b, (int)2, (int)(b.length - 2));
        ByteBuf actual = (ByteBuf)this.ch.readInbound();
        MatcherAssert.assertThat((Object)expected, (Matcher)Is.is((Object)actual));
        Assert.assertFalse((boolean)this.ch.finish());
        expected.release();
        actual.release();
    }
}

