/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.AbstractIntegrationTest;
import io.netty.handler.codec.compression.FastLzFrameDecoder;
import io.netty.handler.codec.compression.FastLzFrameEncoder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class FastLzIntegrationTest
extends AbstractIntegrationTest {
    @Override
    protected EmbeddedChannel createEncoder() {
        return new EmbeddedChannel(new ChannelHandler[]{new FastLzFrameEncoder(rand.nextBoolean())});
    }

    @Override
    protected EmbeddedChannel createDecoder() {
        return new EmbeddedChannel(new ChannelHandler[]{new FastLzFrameDecoder(rand.nextBoolean())});
    }

    @Override
    protected void testIdentity(byte[] data) {
        ByteBuf msg;
        ByteBuf in;
        ByteBuf original = Unpooled.wrappedBuffer((byte[])data);
        int written = 0;
        int length = rand.nextInt(100);
        while (written + length < data.length) {
            in = Unpooled.wrappedBuffer((byte[])data, (int)written, (int)length);
            this.encoder.writeOutbound(new Object[]{in});
            written += length;
            length = rand.nextInt(100);
        }
        in = Unpooled.wrappedBuffer((byte[])data, (int)written, (int)(data.length - written));
        this.encoder.writeOutbound(new Object[]{in});
        this.encoder.finish();
        CompositeByteBuf compressed = Unpooled.compositeBuffer();
        while ((msg = (ByteBuf)this.encoder.readOutbound()) != null) {
            compressed.addComponent(true, msg);
        }
        MatcherAssert.assertThat((Object)compressed, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        byte[] compressedArray = new byte[compressed.readableBytes()];
        compressed.readBytes(compressedArray);
        written = 0;
        length = rand.nextInt(100);
        while (written + length < compressedArray.length) {
            in = Unpooled.wrappedBuffer((byte[])compressedArray, (int)written, (int)length);
            this.decoder.writeInbound(new Object[]{in});
            written += length;
            length = rand.nextInt(100);
        }
        in = Unpooled.wrappedBuffer((byte[])compressedArray, (int)written, (int)(compressedArray.length - written));
        this.decoder.writeInbound(new Object[]{in});
        Assert.assertFalse((boolean)compressed.isReadable());
        CompositeByteBuf decompressed = Unpooled.compositeBuffer();
        while ((msg = (ByteBuf)this.decoder.readInbound()) != null) {
            decompressed.addComponent(true, msg);
        }
        Assert.assertEquals((Object)original, (Object)decompressed);
        compressed.release();
        decompressed.release();
        original.release();
    }

    public static class TestRandomChecksum
    extends AbstractIntegrationTest {
        @Override
        protected EmbeddedChannel createEncoder() {
            return new EmbeddedChannel(new ChannelHandler[]{new FastLzFrameEncoder(rand.nextBoolean())});
        }

        @Override
        protected EmbeddedChannel createDecoder() {
            return new EmbeddedChannel(new ChannelHandler[]{new FastLzFrameDecoder(rand.nextBoolean())});
        }
    }

    public static class TestWithChecksum
    extends AbstractIntegrationTest {
        @Override
        protected EmbeddedChannel createEncoder() {
            return new EmbeddedChannel(new ChannelHandler[]{new FastLzFrameEncoder(true)});
        }

        @Override
        protected EmbeddedChannel createDecoder() {
            return new EmbeddedChannel(new ChannelHandler[]{new FastLzFrameDecoder(true)});
        }
    }
}

