/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import java.nio.charset.Charset;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class LineBasedFrameDecoderTest {
    @Test
    public void testDecodeWithStrip() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LineBasedFrameDecoder(8192, true, false)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"first\r\nsecond\nthird", (Charset)CharsetUtil.US_ASCII)});
        ByteBuf buf = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)"first", (Object)buf.toString(CharsetUtil.US_ASCII));
        ByteBuf buf2 = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)"second", (Object)buf2.toString(CharsetUtil.US_ASCII));
        Assert.assertNull((Object)ch.readInbound());
        ch.finish();
        ReferenceCountUtil.release((Object)ch.readInbound());
        buf.release();
        buf2.release();
    }

    @Test
    public void testDecodeWithoutStrip() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LineBasedFrameDecoder(8192, false, false)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"first\r\nsecond\nthird", (Charset)CharsetUtil.US_ASCII)});
        ByteBuf buf = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)"first\r\n", (Object)buf.toString(CharsetUtil.US_ASCII));
        ByteBuf buf2 = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)"second\n", (Object)buf2.toString(CharsetUtil.US_ASCII));
        Assert.assertNull((Object)ch.readInbound());
        ch.finish();
        ReferenceCountUtil.release((Object)ch.readInbound());
        buf.release();
        buf2.release();
    }

    @Test
    public void testTooLongLine1() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LineBasedFrameDecoder(16, false, false)});
        try {
            ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"12345678901234567890\r\nfirst\nsecond", (Charset)CharsetUtil.US_ASCII)});
            Assert.fail();
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(TooLongFrameException.class)));
        }
        ByteBuf buf = (ByteBuf)ch.readInbound();
        ByteBuf buf2 = Unpooled.copiedBuffer((CharSequence)"first\n", (Charset)CharsetUtil.US_ASCII);
        MatcherAssert.assertThat((Object)buf, (Matcher)CoreMatchers.is((Object)buf2));
        MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)false));
        buf.release();
        buf2.release();
    }

    @Test
    public void testTooLongLine2() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LineBasedFrameDecoder(16, false, false)});
        Assert.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"12345678901234567", (Charset)CharsetUtil.US_ASCII)}));
        try {
            ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"890\r\nfirst\r\n", (Charset)CharsetUtil.US_ASCII)});
            Assert.fail();
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(TooLongFrameException.class)));
        }
        ByteBuf buf = (ByteBuf)ch.readInbound();
        ByteBuf buf2 = Unpooled.copiedBuffer((CharSequence)"first\r\n", (Charset)CharsetUtil.US_ASCII);
        MatcherAssert.assertThat((Object)buf, (Matcher)CoreMatchers.is((Object)buf2));
        MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)false));
        buf.release();
        buf2.release();
    }

    @Test
    public void testTooLongLineWithFailFast() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LineBasedFrameDecoder(16, false, true)});
        try {
            ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"12345678901234567", (Charset)CharsetUtil.US_ASCII)});
            Assert.fail();
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(TooLongFrameException.class)));
        }
        MatcherAssert.assertThat((Object)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"890", (Charset)CharsetUtil.US_ASCII)}), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"123\r\nfirst\r\n", (Charset)CharsetUtil.US_ASCII)}), (Matcher)CoreMatchers.is((Object)true));
        ByteBuf buf = (ByteBuf)ch.readInbound();
        ByteBuf buf2 = Unpooled.copiedBuffer((CharSequence)"first\r\n", (Charset)CharsetUtil.US_ASCII);
        MatcherAssert.assertThat((Object)buf, (Matcher)CoreMatchers.is((Object)buf2));
        MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)false));
        buf.release();
        buf2.release();
    }

    @Test
    public void testDecodeSplitsCorrectly() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LineBasedFrameDecoder(8192, false, false)});
        Assert.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"line\r\n.\r\n", (Charset)CharsetUtil.US_ASCII)}));
        ByteBuf buf = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)"line\r\n", (Object)buf.toString(CharsetUtil.US_ASCII));
        ByteBuf buf2 = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)".\r\n", (Object)buf2.toString(CharsetUtil.US_ASCII));
        Assert.assertFalse((boolean)ch.finishAndReleaseAll());
        buf.release();
        buf2.release();
    }

    @Test
    public void testFragmentedDecode() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LineBasedFrameDecoder(8192, false, false)});
        Assert.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"huu", (Charset)CharsetUtil.US_ASCII)}));
        Assert.assertNull((Object)ch.readInbound());
        Assert.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"haa\r", (Charset)CharsetUtil.US_ASCII)}));
        Assert.assertNull((Object)ch.readInbound());
        Assert.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\nhuuhaa\r\n", (Charset)CharsetUtil.US_ASCII)}));
        ByteBuf buf = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)"huuhaa\r\n", (Object)buf.toString(CharsetUtil.US_ASCII));
        ByteBuf buf2 = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)"huuhaa\r\n", (Object)buf2.toString(CharsetUtil.US_ASCII));
        Assert.assertFalse((boolean)ch.finishAndReleaseAll());
        buf.release();
        buf2.release();
    }

    @Test
    public void testEmptyLine() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LineBasedFrameDecoder(8192, true, false)});
        Assert.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\nabcna\r\n", (Charset)CharsetUtil.US_ASCII)}));
        ByteBuf buf = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)"", (Object)buf.toString(CharsetUtil.US_ASCII));
        ByteBuf buf2 = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)"abcna", (Object)buf2.toString(CharsetUtil.US_ASCII));
        Assert.assertFalse((boolean)ch.finishAndReleaseAll());
        buf.release();
        buf2.release();
    }

    @Test
    public void testNotFailFast() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LineBasedFrameDecoder(2, false, false)});
        Assert.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2})}));
        Assert.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{3, 4})}));
        try {
            ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{10})});
            Assert.fail();
        }
        catch (TooLongFrameException tooLongFrameException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{53})}));
        Assert.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{10})}));
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])new byte[]{53, 10});
        ByteBuf buffer = (ByteBuf)ch.readInbound();
        Assert.assertEquals((Object)expected, (Object)buffer);
        expected.release();
        buffer.release();
        Assert.assertFalse((boolean)ch.finish());
    }
}

