/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.DatagramPacketEncoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.SocketUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DatagramPacketEncoderTest {
    private EmbeddedChannel channel;

    @Before
    public void setUp() {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new DatagramPacketEncoder((MessageToMessageEncoder)new StringEncoder(CharsetUtil.UTF_8))});
    }

    @After
    public void tearDown() {
        Assert.assertFalse((boolean)this.channel.finish());
    }

    @Test
    public void testEncode() {
        this.testEncode(false);
    }

    @Test
    public void testEncodeWithSenderIsNull() {
        this.testEncode(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testEncode(boolean senderIsNull) {
        InetSocketAddress recipient = SocketUtils.socketAddress((String)"127.0.0.1", (int)10000);
        InetSocketAddress sender = senderIsNull ? null : SocketUtils.socketAddress((String)"127.0.0.1", (int)20000);
        Assert.assertTrue((boolean)this.channel.writeOutbound(new Object[]{new DefaultAddressedEnvelope((Object)"netty", (SocketAddress)recipient, (SocketAddress)sender)}));
        DatagramPacket packet = (DatagramPacket)this.channel.readOutbound();
        try {
            Assert.assertEquals((Object)"netty", (Object)((ByteBuf)packet.content()).toString(CharsetUtil.UTF_8));
            Assert.assertEquals((Object)recipient, (Object)packet.recipient());
            Assert.assertEquals((Object)sender, (Object)packet.sender());
        }
        finally {
            packet.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnmatchedMessageType() {
        InetSocketAddress recipient = SocketUtils.socketAddress((String)"127.0.0.1", (int)10000);
        InetSocketAddress sender = SocketUtils.socketAddress((String)"127.0.0.1", (int)20000);
        DefaultAddressedEnvelope envelope = new DefaultAddressedEnvelope((Object)1L, (SocketAddress)recipient, (SocketAddress)sender);
        Assert.assertTrue((boolean)this.channel.writeOutbound(new Object[]{envelope}));
        DefaultAddressedEnvelope output = (DefaultAddressedEnvelope)this.channel.readOutbound();
        try {
            Assert.assertSame((Object)envelope, (Object)output);
        }
        finally {
            output.release();
        }
    }

    @Test
    public void testUnmatchedType() {
        String netty = "netty";
        Assert.assertTrue((boolean)this.channel.writeOutbound(new Object[]{netty}));
        Assert.assertSame((Object)netty, (Object)this.channel.readOutbound());
    }

    @Test
    public void testIsNotSharable() {
        DatagramPacketEncoderTest.testSharable(false);
    }

    @Test
    public void testIsSharable() {
        DatagramPacketEncoderTest.testSharable(true);
    }

    private static void testSharable(boolean sharable) {
        TestMessageToMessageEncoder wrapped = new TestMessageToMessageEncoder(sharable);
        DatagramPacketEncoder encoder = new DatagramPacketEncoder((MessageToMessageEncoder)wrapped);
        Assert.assertEquals((Object)wrapped.isSharable(), (Object)encoder.isSharable());
    }

    private static final class TestMessageToMessageEncoder
    extends MessageToMessageEncoder<AddressedEnvelope<ByteBuf, InetSocketAddress>> {
        private final boolean sharable;

        TestMessageToMessageEncoder(boolean sharable) {
            this.sharable = sharable;
        }

        protected void encode(ChannelHandlerContext ctx, AddressedEnvelope<ByteBuf, InetSocketAddress> msg, List<Object> out) {
        }

        public boolean isSharable() {
            return this.sharable;
        }
    }
}

