/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.Delimiters;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.util.CharsetUtil;
import org.junit.Assert;
import org.junit.Test;

public class DelimiterBasedFrameDecoderTest {
    @Test
    public void testFailSlowTooLongFrameRecovery() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new DelimiterBasedFrameDecoder(1, true, false, Delimiters.nulDelimiter())});
        for (int i = 0; i < 2; ++i) {
            ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{1, 2})});
            try {
                Assert.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{0})}));
                Assert.fail((String)(DecoderException.class.getSimpleName() + " must be raised."));
            }
            catch (TooLongFrameException tooLongFrameException) {
                // empty catch block
            }
            ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{65, 0})});
            ByteBuf buf = (ByteBuf)ch.readInbound();
            Assert.assertEquals((Object)"A", (Object)buf.toString(CharsetUtil.ISO_8859_1));
            buf.release();
        }
    }

    @Test
    public void testFailFastTooLongFrameRecovery() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new DelimiterBasedFrameDecoder(1, Delimiters.nulDelimiter())});
        for (int i = 0; i < 2; ++i) {
            try {
                Assert.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{1, 2})}));
                Assert.fail((String)(DecoderException.class.getSimpleName() + " must be raised."));
            }
            catch (TooLongFrameException tooLongFrameException) {
                // empty catch block
            }
            ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{0, 65, 0})});
            ByteBuf buf = (ByteBuf)ch.readInbound();
            Assert.assertEquals((Object)"A", (Object)buf.toString(CharsetUtil.ISO_8859_1));
            buf.release();
        }
    }
}

