/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.AbstractDecoderTest;
import io.netty.handler.codec.compression.Bzip2Decoder;
import io.netty.handler.codec.compression.DecompressionException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class Bzip2DecoderTest
extends AbstractDecoderTest {
    private static final byte[] DATA = new byte[]{66, 90, 104, 55, 49, 65, 89, 38, 83, 89, 119, 123, -54, -64, 0, 0, 0, 5, -128, 0, 1, 2, 0, 4, 32, 32, 0, 48, -51, 52, 25, -90, -119, -103, -59, -36, -111, 78, 20, 36, 29, -34, -14, -80, 0};

    @Override
    public void initChannel() {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new Bzip2Decoder()});
    }

    private void writeInboundDestroyAndExpectDecompressionException(ByteBuf in) {
        try {
            this.channel.writeInbound(new Object[]{in});
        }
        finally {
            try {
                this.destroyChannel();
                Assert.fail();
            }
            catch (DecompressionException decompressionException) {}
        }
    }

    @Test
    public void testUnexpectedStreamIdentifier() throws Exception {
        this.expected.expect(DecompressionException.class);
        this.expected.expectMessage("Unexpected stream identifier contents");
        ByteBuf in = Unpooled.buffer();
        in.writeLong(1823080128301928729L);
        this.writeInboundDestroyAndExpectDecompressionException(in);
    }

    @Test
    public void testInvalidBlockSize() throws Exception {
        this.expected.expect(DecompressionException.class);
        this.expected.expectMessage("block size is invalid");
        ByteBuf in = Unpooled.buffer();
        in.writeMedium(4348520);
        in.writeByte(48);
        this.channel.writeInbound(new Object[]{in});
    }

    @Test
    public void testBadBlockHeader() throws Exception {
        this.expected.expect(DecompressionException.class);
        this.expected.expectMessage("bad block header");
        ByteBuf in = Unpooled.buffer();
        in.writeMedium(4348520);
        in.writeByte(49);
        in.writeMedium(11);
        in.writeMedium(11);
        in.writeInt(11111);
        this.channel.writeInbound(new Object[]{in});
    }

    @Test
    public void testStreamCrcErrorOfEmptyBlock() throws Exception {
        this.expected.expect(DecompressionException.class);
        this.expected.expectMessage("stream CRC error");
        ByteBuf in = Unpooled.buffer();
        in.writeMedium(4348520);
        in.writeByte(49);
        in.writeMedium(1536581);
        in.writeMedium(3690640);
        in.writeInt(1);
        this.channel.writeInbound(new Object[]{in});
    }

    @Test
    public void testStreamCrcError() throws Exception {
        this.expected.expect(DecompressionException.class);
        this.expected.expectMessage("stream CRC error");
        byte[] data = Arrays.copyOf(DATA, DATA.length);
        data[41] = -35;
        Bzip2DecoderTest.tryDecodeAndCatchBufLeaks(this.channel, Unpooled.wrappedBuffer((byte[])data));
    }

    @Test
    public void testIncorrectHuffmanGroupsNumber() throws Exception {
        this.expected.expect(DecompressionException.class);
        this.expected.expectMessage("incorrect huffman groups number");
        byte[] data = Arrays.copyOf(DATA, DATA.length);
        data[25] = 112;
        ByteBuf in = Unpooled.wrappedBuffer((byte[])data);
        this.channel.writeInbound(new Object[]{in});
    }

    @Test
    public void testIncorrectSelectorsNumber() throws Exception {
        this.expected.expect(DecompressionException.class);
        this.expected.expectMessage("incorrect selectors number");
        byte[] data = Arrays.copyOf(DATA, DATA.length);
        data[25] = 47;
        ByteBuf in = Unpooled.wrappedBuffer((byte[])data);
        this.channel.writeInbound(new Object[]{in});
    }

    @Test
    public void testBlockCrcError() throws Exception {
        this.expected.expect(DecompressionException.class);
        this.expected.expectMessage("block CRC error");
        byte[] data = Arrays.copyOf(DATA, DATA.length);
        data[11] = 119;
        ByteBuf in = Unpooled.wrappedBuffer((byte[])data);
        this.writeInboundDestroyAndExpectDecompressionException(in);
    }

    @Test
    public void testStartPointerInvalid() throws Exception {
        this.expected.expect(DecompressionException.class);
        this.expected.expectMessage("start pointer invalid");
        byte[] data = Arrays.copyOf(DATA, DATA.length);
        data[14] = -1;
        ByteBuf in = Unpooled.wrappedBuffer((byte[])data);
        this.writeInboundDestroyAndExpectDecompressionException(in);
    }

    @Override
    protected byte[] compress(byte[] data) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        BZip2CompressorOutputStream bZip2Os = new BZip2CompressorOutputStream((OutputStream)os, 1);
        bZip2Os.write(data);
        bZip2Os.close();
        return os.toByteArray();
    }
}

