/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.ReplayingDecoderByteBuf;
import io.netty.util.CharsetUtil;
import io.netty.util.Signal;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Test;

public class ReplayingDecoderByteBufTest {
    @Test
    public void testGetUnsignedByte() {
        ByteBuf buf = Unpooled.copiedBuffer((CharSequence)"TestBuffer", (Charset)CharsetUtil.ISO_8859_1);
        ReplayingDecoderByteBuf buffer = new ReplayingDecoderByteBuf(buf);
        int i = 0;
        try {
            while (true) {
                buffer.getUnsignedByte(i);
                ++i;
            }
        }
        catch (Signal e) {
            boolean error = true;
            Assert.assertTrue((boolean)error);
            Assert.assertEquals((long)10L, (long)i);
            buf.release();
            return;
        }
    }

    @Test
    public void testGetByte() {
        ByteBuf buf = Unpooled.copiedBuffer((CharSequence)"TestBuffer", (Charset)CharsetUtil.ISO_8859_1);
        ReplayingDecoderByteBuf buffer = new ReplayingDecoderByteBuf(buf);
        int i = 0;
        try {
            while (true) {
                buffer.getByte(i);
                ++i;
            }
        }
        catch (Signal e) {
            boolean error = true;
            Assert.assertTrue((boolean)error);
            Assert.assertEquals((long)10L, (long)i);
            buf.release();
            return;
        }
    }

    @Test
    public void testGetBoolean() {
        ByteBuf buf = Unpooled.buffer((int)10);
        while (buf.isWritable()) {
            buf.writeBoolean(true);
        }
        ReplayingDecoderByteBuf buffer = new ReplayingDecoderByteBuf(buf);
        int i = 0;
        try {
            while (true) {
                buffer.getBoolean(i);
                ++i;
            }
        }
        catch (Signal e) {
            boolean error = true;
            Assert.assertTrue((boolean)error);
            Assert.assertEquals((long)10L, (long)i);
            buf.release();
            return;
        }
    }
}

