/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.AbstractCompressionTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.experimental.theories.DataPoints;
import org.junit.experimental.theories.FromDataPoints;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=Theories.class)
public abstract class AbstractDecoderTest
extends AbstractCompressionTest {
    protected static final ByteBuf WRAPPED_BYTES_SMALL = Unpooled.wrappedBuffer((byte[])BYTES_SMALL);
    protected static final ByteBuf WRAPPED_BYTES_LARGE = Unpooled.wrappedBuffer((byte[])BYTES_LARGE);
    @Rule
    public final ExpectedException expected = ExpectedException.none();
    protected EmbeddedChannel channel;
    protected static byte[] compressedBytesSmall;
    protected static byte[] compressedBytesLarge;

    protected AbstractDecoderTest() throws Exception {
        compressedBytesSmall = this.compress(BYTES_SMALL);
        compressedBytesLarge = this.compress(BYTES_LARGE);
    }

    protected abstract byte[] compress(byte[] var1) throws Exception;

    @Before
    public abstract void initChannel();

    @After
    public void destroyChannel() {
        if (this.channel != null) {
            this.channel.finishAndReleaseAll();
            this.channel = null;
        }
    }

    @DataPoints(value={"smallData"})
    public static ByteBuf[] smallData() {
        ByteBuf heap = Unpooled.wrappedBuffer((byte[])compressedBytesSmall);
        ByteBuf direct = Unpooled.directBuffer((int)compressedBytesSmall.length);
        direct.writeBytes(compressedBytesSmall);
        return new ByteBuf[]{heap, direct};
    }

    @DataPoints(value={"largeData"})
    public static ByteBuf[] largeData() {
        ByteBuf heap = Unpooled.wrappedBuffer((byte[])compressedBytesLarge);
        ByteBuf direct = Unpooled.directBuffer((int)compressedBytesLarge.length);
        direct.writeBytes(compressedBytesLarge);
        return new ByteBuf[]{heap, direct};
    }

    @Theory
    public void testDecompressionOfSmallChunkOfData(@FromDataPoints(value="smallData") ByteBuf data) throws Exception {
        this.testDecompression(WRAPPED_BYTES_SMALL, data);
    }

    @Theory
    public void testDecompressionOfLargeChunkOfData(@FromDataPoints(value="largeData") ByteBuf data) throws Exception {
        this.testDecompression(WRAPPED_BYTES_LARGE, data);
    }

    @Theory
    public void testDecompressionOfBatchedFlowOfData(@FromDataPoints(value="largeData") ByteBuf data) throws Exception {
        this.testDecompressionOfBatchedFlow(WRAPPED_BYTES_LARGE, data);
    }

    protected void testDecompression(ByteBuf expected, ByteBuf data) throws Exception {
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{data}));
        ByteBuf decompressed = AbstractDecoderTest.readDecompressed(this.channel);
        Assert.assertEquals((Object)expected, (Object)decompressed);
        decompressed.release();
    }

    protected void testDecompressionOfBatchedFlow(ByteBuf expected, ByteBuf data) throws Exception {
        ByteBuf compressedBuf;
        int compressedLength = data.readableBytes();
        int written = 0;
        int length = rand.nextInt(100);
        while (written + length < compressedLength) {
            compressedBuf = data.retainedSlice(written, length);
            this.channel.writeInbound(new Object[]{compressedBuf});
            written += length;
            length = rand.nextInt(100);
        }
        compressedBuf = data.slice(written, compressedLength - written);
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{compressedBuf.retain()}));
        ByteBuf decompressedBuf = AbstractDecoderTest.readDecompressed(this.channel);
        Assert.assertEquals((Object)expected, (Object)decompressedBuf);
        decompressedBuf.release();
        data.release();
    }

    protected static ByteBuf readDecompressed(EmbeddedChannel channel) {
        ByteBuf msg;
        CompositeByteBuf decompressed = Unpooled.compositeBuffer();
        while ((msg = (ByteBuf)channel.readInbound()) != null) {
            decompressed.addComponent(true, msg);
        }
        return decompressed;
    }

    protected static void tryDecodeAndCatchBufLeaks(EmbeddedChannel channel, ByteBuf data) {
        try {
            channel.writeInbound(new Object[]{data});
        }
        finally {
            ByteBuf inflated;
            while ((inflated = (ByteBuf)channel.readInbound()) != null) {
                inflated.release();
            }
            channel.finish();
        }
    }
}

