/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.AbstractEncoderTest;
import io.netty.handler.codec.compression.LzmaFrameEncoder;
import java.io.InputStream;
import java.util.ArrayList;
import lzma.sdk.lzma.Decoder;
import lzma.streams.LzmaInputStream;
import org.junit.Assert;
import org.junit.experimental.theories.FromDataPoints;
import org.junit.experimental.theories.Theory;

public class LzmaFrameEncoderTest
extends AbstractEncoderTest {
    @Override
    public void initChannel() {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new LzmaFrameEncoder()});
    }

    @Override
    @Theory
    public void testCompressionOfBatchedFlowOfData(@FromDataPoints(value="smallData") ByteBuf data) throws Exception {
        this.testCompressionOfBatchedFlow(data);
    }

    @Override
    protected void testCompressionOfBatchedFlow(ByteBuf data) throws Exception {
        ByteBuf msg;
        ByteBuf in;
        ArrayList<Integer> originalLengths = new ArrayList<Integer>();
        int dataLength = data.readableBytes();
        int written = 0;
        int length = rand.nextInt(50);
        while (written + length < dataLength) {
            in = data.retainedSlice(written, length);
            Assert.assertTrue((boolean)this.channel.writeOutbound(new Object[]{in}));
            written += length;
            originalLengths.add(length);
            length = rand.nextInt(50);
        }
        length = dataLength - written;
        in = data.retainedSlice(written, dataLength - written);
        originalLengths.add(length);
        Assert.assertTrue((boolean)this.channel.writeOutbound(new Object[]{in}));
        Assert.assertTrue((boolean)this.channel.finish());
        CompositeByteBuf decompressed = Unpooled.compositeBuffer();
        int i = 0;
        while ((msg = (ByteBuf)this.channel.readOutbound()) != null) {
            ByteBuf decompressedMsg = this.decompress(msg, (Integer)originalLengths.get(i++));
            decompressed.addComponent(true, decompressedMsg);
        }
        Assert.assertEquals((long)originalLengths.size(), (long)i);
        Assert.assertEquals((Object)data, (Object)decompressed);
        decompressed.release();
        data.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ByteBuf decompress(ByteBuf compressed, int originalLength) throws Exception {
        ByteBufInputStream is = new ByteBufInputStream(compressed, true);
        LzmaInputStream lzmaIs = null;
        byte[] decompressed = new byte[originalLength];
        try {
            int read;
            lzmaIs = new LzmaInputStream((InputStream)is, new Decoder());
            for (int remaining = originalLength; remaining > 0 && (read = lzmaIs.read(decompressed, originalLength - remaining, remaining)) > 0; remaining -= read) {
            }
            Assert.assertEquals((long)-1L, (long)lzmaIs.read());
        }
        finally {
            if (lzmaIs != null) {
                lzmaIs.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return Unpooled.wrappedBuffer((byte[])decompressed);
    }
}

