/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.handler.codec.DateFormatter;
import java.util.Calendar;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class DateFormatterTest {
    private static final long TIMESTAMP = 784111777000L;
    private static final Date DATE = new Date(784111777000L);

    @Test
    public void testParseWithSingleDigitDay() {
        Assert.assertEquals((Object)DATE, (Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 6 Nov 1994 08:49:37 GMT"));
    }

    @Test
    public void testParseWithDoubleDigitDay() {
        Assert.assertEquals((Object)DATE, (Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 06 Nov 1994 08:49:37 GMT"));
    }

    @Test
    public void testParseWithDashSeparatorSingleDigitDay() {
        Assert.assertEquals((Object)DATE, (Object)DateFormatter.parseHttpDate((CharSequence)"Sunday, 06-Nov-94 08:49:37 GMT"));
    }

    @Test
    public void testParseWithSingleDoubleDigitDay() {
        Assert.assertEquals((Object)DATE, (Object)DateFormatter.parseHttpDate((CharSequence)"Sunday, 6-Nov-94 08:49:37 GMT"));
    }

    @Test
    public void testParseWithoutGMT() {
        Assert.assertEquals((Object)DATE, (Object)DateFormatter.parseHttpDate((CharSequence)"Sun Nov 6 08:49:37 1994"));
    }

    @Test
    public void testParseWithFunkyTimezone() {
        Assert.assertEquals((Object)DATE, (Object)DateFormatter.parseHttpDate((CharSequence)"Sun Nov 6 08:49:37 1994 -0000"));
    }

    @Test
    public void testParseWithSingleDigitHourMinutesAndSecond() {
        Assert.assertEquals((Object)DATE, (Object)DateFormatter.parseHttpDate((CharSequence)"Sunday, 6-Nov-94 8:49:37 GMT"));
    }

    @Test
    public void testParseWithSingleDigitTime() {
        Assert.assertEquals((Object)DATE, (Object)DateFormatter.parseHttpDate((CharSequence)"Sunday, 6 Nov 1994 8:49:37 GMT"));
        Date _08_09_37 = new Date(784109377000L);
        Assert.assertEquals((Object)_08_09_37, (Object)DateFormatter.parseHttpDate((CharSequence)"Sunday, 6 Nov 1994 8:9:37 GMT"));
        Assert.assertEquals((Object)_08_09_37, (Object)DateFormatter.parseHttpDate((CharSequence)"Sunday, 6 Nov 1994 8:09:37 GMT"));
        Date _08_09_07 = new Date(784109347000L);
        Assert.assertEquals((Object)_08_09_07, (Object)DateFormatter.parseHttpDate((CharSequence)"Sunday, 6 Nov 1994 8:9:7 GMT"));
        Assert.assertEquals((Object)_08_09_07, (Object)DateFormatter.parseHttpDate((CharSequence)"Sunday, 6 Nov 1994 8:9:07 GMT"));
    }

    @Test
    public void testParseMidnight() {
        Assert.assertEquals((Object)new Date(784080000000L), (Object)DateFormatter.parseHttpDate((CharSequence)"Sunday, 6 Nov 1994 00:00:00 GMT"));
    }

    @Test
    public void testParseInvalidInput() {
        Assert.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, Nov 1994 08:49:37 GMT"));
        Assert.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 6 1994 08:49:37 GMT"));
        Assert.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 6 Nov 08:49:37 GMT"));
        Assert.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 6 Nov 1994 :49:37 GMT"));
        Assert.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 6 Nov 1994 49:37 GMT"));
        Assert.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 6 Nov 1994 08::37 GMT"));
        Assert.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 6 Nov 1994 08:37 GMT"));
        Assert.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 6 Nov 1994 08:49: GMT"));
        Assert.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 6 Nov 1994 08:49 GMT"));
        Assert.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 6 FOO 1994 08:49:37 GMT"));
        Assert.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 36 Nov 1994 08:49:37 GMT"));
        Assert.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 6 Nov 1994 28:49:37 GMT"));
        Assert.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 6 Nov 1994 08:69:37 GMT"));
        Assert.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 6 Nov 1994 08:49:67 GMT"));
        Assert.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sunday, 6 Nov 1994 0:0:000 GMT"));
        Assert.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sunday, 6 Nov 1994 0:000:0 GMT"));
        Assert.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sunday, 6 Nov 1994 000:0:0 GMT"));
    }

    @Test
    public void testFormat() {
        Assert.assertEquals((Object)"Sun, 6 Nov 1994 08:49:37 GMT", (Object)DateFormatter.format((Date)DATE));
    }

    @Test
    public void testParseAllMonths() {
        Assert.assertEquals((long)0L, (long)DateFormatterTest.getMonth(DateFormatter.parseHttpDate((CharSequence)"Sun, 6 Jan 1994 08:49:37 GMT")));
        Assert.assertEquals((long)1L, (long)DateFormatterTest.getMonth(DateFormatter.parseHttpDate((CharSequence)"Sun, 6 Feb 1994 08:49:37 GMT")));
        Assert.assertEquals((long)2L, (long)DateFormatterTest.getMonth(DateFormatter.parseHttpDate((CharSequence)"Sun, 6 Mar 1994 08:49:37 GMT")));
        Assert.assertEquals((long)3L, (long)DateFormatterTest.getMonth(DateFormatter.parseHttpDate((CharSequence)"Sun, 6 Apr 1994 08:49:37 GMT")));
        Assert.assertEquals((long)4L, (long)DateFormatterTest.getMonth(DateFormatter.parseHttpDate((CharSequence)"Sun, 6 May 1994 08:49:37 GMT")));
        Assert.assertEquals((long)5L, (long)DateFormatterTest.getMonth(DateFormatter.parseHttpDate((CharSequence)"Sun, 6 Jun 1994 08:49:37 GMT")));
        Assert.assertEquals((long)6L, (long)DateFormatterTest.getMonth(DateFormatter.parseHttpDate((CharSequence)"Sun, 6 Jul 1994 08:49:37 GMT")));
        Assert.assertEquals((long)7L, (long)DateFormatterTest.getMonth(DateFormatter.parseHttpDate((CharSequence)"Sun, 6 Aug 1994 08:49:37 GMT")));
        Assert.assertEquals((long)8L, (long)DateFormatterTest.getMonth(DateFormatter.parseHttpDate((CharSequence)"Sun, 6 Sep 1994 08:49:37 GMT")));
        Assert.assertEquals((long)9L, (long)DateFormatterTest.getMonth(DateFormatter.parseHttpDate((CharSequence)"Sun Oct 6 08:49:37 1994")));
        Assert.assertEquals((long)10L, (long)DateFormatterTest.getMonth(DateFormatter.parseHttpDate((CharSequence)"Sun Nov 6 08:49:37 1994")));
        Assert.assertEquals((long)11L, (long)DateFormatterTest.getMonth(DateFormatter.parseHttpDate((CharSequence)"Sun Dec 6 08:49:37 1994")));
    }

    private static int getMonth(Date referenceDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(referenceDate);
        return cal.get(2);
    }
}

