/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.string;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.string.LineEncoder;
import io.netty.handler.codec.string.LineSeparator;
import io.netty.util.CharsetUtil;
import org.junit.Assert;
import org.junit.Test;

public class LineEncoderTest {
    @Test
    public void testEncode() {
        LineEncoderTest.testLineEncode(LineSeparator.DEFAULT, "abc");
        LineEncoderTest.testLineEncode(LineSeparator.WINDOWS, "abc");
        LineEncoderTest.testLineEncode(LineSeparator.UNIX, "abc");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testLineEncode(LineSeparator lineSeparator, String msg) {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new LineEncoder(lineSeparator, CharsetUtil.UTF_8)});
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{msg}));
        ByteBuf buf = (ByteBuf)channel.readOutbound();
        try {
            byte[] data = new byte[buf.readableBytes()];
            buf.readBytes(data);
            byte[] expected = (msg + lineSeparator.value()).getBytes(CharsetUtil.UTF_8);
            Assert.assertArrayEquals((byte[])expected, (byte[])data);
            Assert.assertNull((Object)channel.readOutbound());
        }
        finally {
            buf.release();
            Assert.assertFalse((boolean)channel.finish());
        }
    }
}

