/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.handler.codec.AsciiString;
import io.netty.handler.codec.ConvertibleHeaders;
import io.netty.handler.codec.DefaultConvertibleHeaders;
import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.TextHeaders;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Iterator;

public class DefaultTextHeaders
extends DefaultConvertibleHeaders<CharSequence, String>
implements TextHeaders {
    private static final DefaultHeaders.HashCodeGenerator<CharSequence> CHARSEQUECE_CASE_INSENSITIVE_HASH_CODE_GENERATOR = new DefaultHeaders.HashCodeGenerator<CharSequence>(){

        @Override
        public int generateHashCode(CharSequence name) {
            return AsciiString.caseInsensitiveHashCode(name);
        }
    };
    private static final DefaultHeaders.HashCodeGenerator<CharSequence> CHARSEQUECE_CASE_SENSITIVE_HASH_CODE_GENERATOR = new DefaultHeaders.HashCodeGenerator<CharSequence>(){

        @Override
        public int generateHashCode(CharSequence name) {
            return name.hashCode();
        }
    };
    private static final Headers.ValueConverter<CharSequence> CHARSEQUENCE_FROM_OBJECT_CONVERTER = new DefaultTextValueTypeConverter();
    private static final ConvertibleHeaders.TypeConverter<CharSequence, String> CHARSEQUENCE_TO_STRING_CONVERTER = new ConvertibleHeaders.TypeConverter<CharSequence, String>(){

        @Override
        public String toConvertedType(CharSequence value) {
            return value.toString();
        }

        @Override
        public CharSequence toUnconvertedType(String value) {
            return value;
        }
    };
    private static final DefaultHeaders.NameConverter<CharSequence> CHARSEQUENCE_IDENTITY_CONVERTER = new DefaultHeaders.IdentityNameConverter<CharSequence>();
    private static final int DEFAULT_VALUE_SIZE = 10;
    private final ValuesComposer valuesComposer;

    public DefaultTextHeaders() {
        this(true);
    }

    public DefaultTextHeaders(boolean ignoreCase) {
        this(ignoreCase, CHARSEQUENCE_FROM_OBJECT_CONVERTER, CHARSEQUENCE_IDENTITY_CONVERTER);
    }

    public DefaultTextHeaders(boolean ignoreCase, boolean singleHeaderFields) {
        this(ignoreCase, CHARSEQUENCE_FROM_OBJECT_CONVERTER, CHARSEQUENCE_IDENTITY_CONVERTER, singleHeaderFields);
    }

    public DefaultTextHeaders(boolean ignoreCase, Headers.ValueConverter<CharSequence> valueConverter, DefaultHeaders.NameConverter<CharSequence> nameConverter) {
        this(ignoreCase, valueConverter, nameConverter, false);
    }

    public DefaultTextHeaders(boolean ignoreCase, Headers.ValueConverter<CharSequence> valueConverter, DefaultHeaders.NameConverter<CharSequence> nameConverter, boolean singleHeaderFields) {
        super(DefaultTextHeaders.comparator(ignoreCase), DefaultTextHeaders.comparator(ignoreCase), ignoreCase ? CHARSEQUECE_CASE_INSENSITIVE_HASH_CODE_GENERATOR : CHARSEQUECE_CASE_SENSITIVE_HASH_CODE_GENERATOR, valueConverter, CHARSEQUENCE_TO_STRING_CONVERTER, nameConverter);
        this.valuesComposer = singleHeaderFields ? new SingleHeaderValuesComposer() : new MultipleFieldsValueComposer();
    }

    @Override
    public boolean contains(CharSequence name, CharSequence value, boolean ignoreCase) {
        return this.contains(name, value, DefaultTextHeaders.comparator(ignoreCase));
    }

    @Override
    public boolean containsObject(CharSequence name, Object value, boolean ignoreCase) {
        return this.containsObject(name, value, DefaultTextHeaders.comparator(ignoreCase));
    }

    @Override
    public TextHeaders add(CharSequence name, CharSequence value) {
        return this.valuesComposer.add(name, value);
    }

    @Override
    public TextHeaders add(CharSequence name, Iterable<? extends CharSequence> values) {
        return this.valuesComposer.add(name, values);
    }

    @Override
    public TextHeaders add(CharSequence name, CharSequence ... values) {
        return this.valuesComposer.add(name, values);
    }

    @Override
    public TextHeaders addObject(CharSequence name, Object value) {
        return this.valuesComposer.addObject(name, value);
    }

    @Override
    public TextHeaders addObject(CharSequence name, Iterable<?> values) {
        return this.valuesComposer.addObject(name, values);
    }

    @Override
    public TextHeaders addObject(CharSequence name, Object ... values) {
        return this.valuesComposer.addObject(name, values);
    }

    @Override
    public TextHeaders addBoolean(CharSequence name, boolean value) {
        super.addBoolean(name, value);
        return this;
    }

    @Override
    public TextHeaders addChar(CharSequence name, char value) {
        super.addChar(name, value);
        return this;
    }

    @Override
    public TextHeaders addByte(CharSequence name, byte value) {
        super.addByte(name, value);
        return this;
    }

    @Override
    public TextHeaders addShort(CharSequence name, short value) {
        super.addShort(name, value);
        return this;
    }

    @Override
    public TextHeaders addInt(CharSequence name, int value) {
        super.addInt(name, value);
        return this;
    }

    @Override
    public TextHeaders addLong(CharSequence name, long value) {
        super.addLong(name, value);
        return this;
    }

    @Override
    public TextHeaders addFloat(CharSequence name, float value) {
        super.addFloat(name, value);
        return this;
    }

    @Override
    public TextHeaders addDouble(CharSequence name, double value) {
        super.addDouble(name, value);
        return this;
    }

    @Override
    public TextHeaders addTimeMillis(CharSequence name, long value) {
        super.addTimeMillis(name, value);
        return this;
    }

    @Override
    public TextHeaders add(TextHeaders headers) {
        super.add(headers);
        return this;
    }

    @Override
    public TextHeaders set(CharSequence name, CharSequence value) {
        super.set(name, value);
        return this;
    }

    @Override
    public TextHeaders set(CharSequence name, Iterable<? extends CharSequence> values) {
        return this.valuesComposer.set(name, values);
    }

    @Override
    public TextHeaders set(CharSequence name, CharSequence ... values) {
        return this.valuesComposer.set(name, values);
    }

    @Override
    public TextHeaders setObject(CharSequence name, Object value) {
        super.setObject(name, value);
        return this;
    }

    @Override
    public TextHeaders setObject(CharSequence name, Iterable<?> values) {
        return this.valuesComposer.setObject(name, values);
    }

    @Override
    public TextHeaders setObject(CharSequence name, Object ... values) {
        return this.valuesComposer.setObject(name, values);
    }

    @Override
    public TextHeaders setBoolean(CharSequence name, boolean value) {
        super.setBoolean(name, value);
        return this;
    }

    @Override
    public TextHeaders setChar(CharSequence name, char value) {
        super.setChar(name, value);
        return this;
    }

    @Override
    public TextHeaders setByte(CharSequence name, byte value) {
        super.setByte(name, value);
        return this;
    }

    @Override
    public TextHeaders setShort(CharSequence name, short value) {
        super.setShort(name, value);
        return this;
    }

    @Override
    public TextHeaders setInt(CharSequence name, int value) {
        super.setInt(name, value);
        return this;
    }

    @Override
    public TextHeaders setLong(CharSequence name, long value) {
        super.setLong(name, value);
        return this;
    }

    @Override
    public TextHeaders setFloat(CharSequence name, float value) {
        super.setFloat(name, value);
        return this;
    }

    @Override
    public TextHeaders setDouble(CharSequence name, double value) {
        super.setDouble(name, value);
        return this;
    }

    @Override
    public TextHeaders setTimeMillis(CharSequence name, long value) {
        super.setTimeMillis(name, value);
        return this;
    }

    @Override
    public TextHeaders set(TextHeaders headers) {
        super.set(headers);
        return this;
    }

    @Override
    public TextHeaders setAll(TextHeaders headers) {
        super.setAll(headers);
        return this;
    }

    @Override
    public TextHeaders clear() {
        super.clear();
        return this;
    }

    private static Comparator<CharSequence> comparator(boolean ignoreCase) {
        return ignoreCase ? AsciiString.CHARSEQUENCE_CASE_INSENSITIVE_ORDER : AsciiString.CHARSEQUENCE_CASE_SENSITIVE_ORDER;
    }

    private static interface CsvValueEscaper<T> {
        public CharSequence escape(T var1);
    }

    private final class SingleHeaderValuesComposer
    implements ValuesComposer {
        private final Headers.ValueConverter<CharSequence> valueConverter;
        private CsvValueEscaper<Object> objectEscaper;
        private CsvValueEscaper<CharSequence> charSequenceEscaper;

        private SingleHeaderValuesComposer() {
            this.valueConverter = DefaultTextHeaders.this.valueConverter();
        }

        private CsvValueEscaper<Object> objectEscaper() {
            if (this.objectEscaper == null) {
                this.objectEscaper = new CsvValueEscaper<Object>(){

                    @Override
                    public CharSequence escape(Object value) {
                        return StringUtil.escapeCsv((CharSequence)((CharSequence)SingleHeaderValuesComposer.this.valueConverter.convertObject(value)));
                    }
                };
            }
            return this.objectEscaper;
        }

        private CsvValueEscaper<CharSequence> charSequenceEscaper() {
            if (this.charSequenceEscaper == null) {
                this.charSequenceEscaper = new CsvValueEscaper<CharSequence>(){

                    @Override
                    public CharSequence escape(CharSequence value) {
                        return StringUtil.escapeCsv((CharSequence)value);
                    }
                };
            }
            return this.charSequenceEscaper;
        }

        @Override
        public TextHeaders add(CharSequence name, CharSequence value) {
            return this.addEscapedValue(name, StringUtil.escapeCsv((CharSequence)value));
        }

        @Override
        public TextHeaders add(CharSequence name, CharSequence ... values) {
            return this.addEscapedValue(name, this.commaSeparate(this.charSequenceEscaper(), values));
        }

        @Override
        public TextHeaders add(CharSequence name, Iterable<? extends CharSequence> values) {
            return this.addEscapedValue(name, this.commaSeparate(this.charSequenceEscaper(), values));
        }

        @Override
        public TextHeaders addObject(CharSequence name, Iterable<?> values) {
            return this.addEscapedValue(name, this.commaSeparate(this.objectEscaper(), values));
        }

        @Override
        public TextHeaders addObject(CharSequence name, Object ... values) {
            return this.addEscapedValue(name, this.commaSeparate(this.objectEscaper(), values));
        }

        @Override
        public TextHeaders set(CharSequence name, CharSequence ... values) {
            DefaultTextHeaders.super.set(name, this.commaSeparate(this.charSequenceEscaper(), values));
            return DefaultTextHeaders.this;
        }

        @Override
        public TextHeaders set(CharSequence name, Iterable<? extends CharSequence> values) {
            DefaultTextHeaders.super.set(name, this.commaSeparate(this.charSequenceEscaper(), values));
            return DefaultTextHeaders.this;
        }

        @Override
        public TextHeaders setObject(CharSequence name, Object ... values) {
            DefaultTextHeaders.super.set(name, this.commaSeparate(this.objectEscaper(), values));
            return DefaultTextHeaders.this;
        }

        @Override
        public TextHeaders setObject(CharSequence name, Iterable<?> values) {
            DefaultTextHeaders.super.set(name, this.commaSeparate(this.objectEscaper(), values));
            return DefaultTextHeaders.this;
        }

        private TextHeaders addEscapedValue(CharSequence name, CharSequence escapedValue) {
            CharSequence currentValue = (CharSequence)DefaultTextHeaders.super.get(name);
            if (currentValue == null) {
                DefaultTextHeaders.super.add(name, escapedValue);
            } else {
                DefaultTextHeaders.super.set(name, this.commaSeparateEscapedValues(currentValue, escapedValue));
            }
            return DefaultTextHeaders.this;
        }

        private <T> CharSequence commaSeparate(CsvValueEscaper<T> escaper, T ... values) {
            StringBuilder sb = new StringBuilder(values.length * 10);
            if (values.length > 0) {
                int end = values.length - 1;
                for (int i = 0; i < end; ++i) {
                    sb.append(escaper.escape(values[i])).append(',');
                }
                sb.append(escaper.escape(values[end]));
            }
            return sb;
        }

        private <T> CharSequence commaSeparate(CsvValueEscaper<T> escaper, Iterable<? extends T> values) {
            StringBuilder sb = new StringBuilder();
            Iterator<T> iterator = values.iterator();
            if (iterator.hasNext()) {
                T next = iterator.next();
                while (iterator.hasNext()) {
                    sb.append(escaper.escape(next)).append(',');
                    next = iterator.next();
                }
                sb.append(escaper.escape(next));
            }
            return sb;
        }

        private CharSequence commaSeparateEscapedValues(CharSequence currentValue, CharSequence value) {
            return new StringBuilder(currentValue.length() + 1 + value.length()).append(currentValue).append(',').append(value);
        }
    }

    private final class MultipleFieldsValueComposer
    implements ValuesComposer {
        private MultipleFieldsValueComposer() {
        }

        @Override
        public TextHeaders add(CharSequence name, CharSequence value) {
            DefaultTextHeaders.super.add(name, value);
            return DefaultTextHeaders.this;
        }

        @Override
        public TextHeaders add(CharSequence name, CharSequence ... values) {
            DefaultTextHeaders.super.add(name, values);
            return DefaultTextHeaders.this;
        }

        @Override
        public TextHeaders add(CharSequence name, Iterable<? extends CharSequence> values) {
            DefaultTextHeaders.super.add(name, values);
            return DefaultTextHeaders.this;
        }

        @Override
        public TextHeaders addObject(CharSequence name, Iterable<?> values) {
            DefaultTextHeaders.super.addObject(name, values);
            return DefaultTextHeaders.this;
        }

        @Override
        public TextHeaders addObject(CharSequence name, Object ... values) {
            DefaultTextHeaders.super.addObject(name, values);
            return DefaultTextHeaders.this;
        }

        @Override
        public TextHeaders set(CharSequence name, CharSequence ... values) {
            DefaultTextHeaders.super.set(name, values);
            return DefaultTextHeaders.this;
        }

        @Override
        public TextHeaders set(CharSequence name, Iterable<? extends CharSequence> values) {
            DefaultTextHeaders.super.set(name, values);
            return DefaultTextHeaders.this;
        }

        @Override
        public TextHeaders setObject(CharSequence name, Object ... values) {
            DefaultTextHeaders.super.setObject(name, values);
            return DefaultTextHeaders.this;
        }

        @Override
        public TextHeaders setObject(CharSequence name, Iterable<?> values) {
            DefaultTextHeaders.super.setObject(name, values);
            return DefaultTextHeaders.this;
        }
    }

    private static interface ValuesComposer {
        public TextHeaders add(CharSequence var1, CharSequence var2);

        public TextHeaders add(CharSequence var1, CharSequence ... var2);

        public TextHeaders add(CharSequence var1, Iterable<? extends CharSequence> var2);

        public TextHeaders addObject(CharSequence var1, Iterable<?> var2);

        public TextHeaders addObject(CharSequence var1, Object ... var2);

        public TextHeaders set(CharSequence var1, CharSequence ... var2);

        public TextHeaders set(CharSequence var1, Iterable<? extends CharSequence> var2);

        public TextHeaders setObject(CharSequence var1, Object ... var2);

        public TextHeaders setObject(CharSequence var1, Iterable<?> var2);
    }

    public static class DefaultTextValueTypeConverter
    implements Headers.ValueConverter<CharSequence> {
        @Override
        public CharSequence convertObject(Object value) {
            if (value instanceof CharSequence) {
                return (CharSequence)value;
            }
            return value.toString();
        }

        @Override
        public CharSequence convertInt(int value) {
            return String.valueOf(value);
        }

        @Override
        public CharSequence convertLong(long value) {
            return String.valueOf(value);
        }

        @Override
        public CharSequence convertDouble(double value) {
            return String.valueOf(value);
        }

        @Override
        public CharSequence convertChar(char value) {
            return String.valueOf(value);
        }

        @Override
        public CharSequence convertBoolean(boolean value) {
            return String.valueOf(value);
        }

        @Override
        public CharSequence convertFloat(float value) {
            return String.valueOf(value);
        }

        @Override
        public boolean convertToBoolean(CharSequence value) {
            return Boolean.parseBoolean(value.toString());
        }

        @Override
        public CharSequence convertByte(byte value) {
            return String.valueOf(value);
        }

        @Override
        public byte convertToByte(CharSequence value) {
            return Byte.valueOf(value.toString());
        }

        @Override
        public char convertToChar(CharSequence value) {
            return value.charAt(0);
        }

        @Override
        public CharSequence convertShort(short value) {
            return String.valueOf(value);
        }

        @Override
        public short convertToShort(CharSequence value) {
            return Short.valueOf(value.toString());
        }

        @Override
        public int convertToInt(CharSequence value) {
            return Integer.parseInt(value.toString());
        }

        @Override
        public long convertToLong(CharSequence value) {
            return Long.parseLong(value.toString());
        }

        @Override
        public AsciiString convertTimeMillis(long value) {
            return new AsciiString(String.valueOf(value));
        }

        @Override
        public long convertToTimeMillis(CharSequence value) {
            try {
                return DefaultHeaders.HeaderDateFormat.get().parse(value.toString());
            }
            catch (ParseException e) {
                PlatformDependent.throwException((Throwable)e);
                return 0L;
            }
        }

        @Override
        public float convertToFloat(CharSequence value) {
            return Float.valueOf(value.toString()).floatValue();
        }

        @Override
        public double convertToDouble(CharSequence value) {
            return Double.valueOf(value.toString());
        }
    }
}

