/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.compression.Bzip2BlockDecompressor;
import io.netty.handler.codec.compression.Bzip2HuffmanStageDecoder;
import io.netty.handler.codec.compression.Bzip2MoveToFrontTable;
import io.netty.handler.codec.compression.DecompressionException;
import java.util.List;

public class Bzip2Decoder
extends ByteToMessageDecoder {
    private State currentState = State.INIT;
    private Bzip2BlockDecompressor blockDecompressor;
    private Bzip2HuffmanStageDecoder huffmanStageDecoder;
    private int blockSize;
    private int blockCRC;
    private int streamCRC;
    private int bitBuffer;
    private int bitCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (!in.isReadable()) {
            return;
        }
        block15: while (true) {
            switch (this.currentState) {
                case INIT: {
                    if (in.readableBytes() < 4) {
                        return;
                    }
                    int magicNumber = in.readUnsignedMedium();
                    if (magicNumber != 4348520) {
                        throw new DecompressionException("Unexpected stream identifier contents. Mismatched bzip2 protocol version?");
                    }
                    int blockSize = in.readByte() - 48;
                    if (blockSize < 1 || blockSize > 9) {
                        throw new DecompressionException("block size is invalid");
                    }
                    this.blockSize = blockSize * 100000;
                    this.streamCRC = 0;
                    this.currentState = State.INIT_BLOCK;
                }
                case INIT_BLOCK: {
                    if (in.readableBytes() < 10) {
                        return;
                    }
                    long magic = (long)this.readBits(in, 24) << 24 | (long)this.readBits(in, 24);
                    if (magic == 25779555029136L) {
                        int storedCombinedCRC = this.readInt(in);
                        if (storedCombinedCRC != this.streamCRC) {
                            throw new DecompressionException("stream CRC error");
                        }
                        this.currentState = State.EOF;
                        continue block15;
                    }
                    if (magic != 54156738319193L) {
                        throw new DecompressionException("bad block header");
                    }
                    this.blockCRC = this.readInt(in);
                    this.currentState = State.INIT_BLOCK_PARAMS;
                }
                case INIT_BLOCK_PARAMS: {
                    if (in.readableBytes() < 4) {
                        return;
                    }
                    boolean blockRandomised = this.readBoolean(in);
                    int bwtStartPointer = this.readBits(in, 24);
                    this.blockDecompressor = new Bzip2BlockDecompressor(this.blockSize, this.blockCRC, blockRandomised, bwtStartPointer);
                    this.currentState = State.RECEIVE_HUFFMAN_USED_MAP;
                }
                case RECEIVE_HUFFMAN_USED_MAP: {
                    if (in.readableBytes() < 2) {
                        return;
                    }
                    this.blockDecompressor.huffmanInUse16 = this.readBits(in, 16);
                    this.currentState = State.RECEIVE_HUFFMAN_USED_BITMAPS;
                }
                case RECEIVE_HUFFMAN_USED_BITMAPS: {
                    Bzip2BlockDecompressor blockDecompressor = this.blockDecompressor;
                    int inUse16 = blockDecompressor.huffmanInUse16;
                    int bitNumber = Integer.bitCount(inUse16);
                    byte[] huffmanSymbolMap = blockDecompressor.huffmanSymbolMap;
                    if (in.readableBytes() < bitNumber * 16 / 8 + 1) {
                        return;
                    }
                    int huffmanSymbolCount = 0;
                    if (bitNumber > 0) {
                        for (int i = 0; i < 16; ++i) {
                            if ((inUse16 & 32768 >>> i) == 0) continue;
                            int j = 0;
                            int k = i << 4;
                            while (j < 16) {
                                if (this.readBoolean(in)) {
                                    huffmanSymbolMap[huffmanSymbolCount++] = (byte)k;
                                }
                                ++j;
                                ++k;
                            }
                        }
                    }
                    blockDecompressor.huffmanEndOfBlockSymbol = huffmanSymbolCount + 1;
                    int totalTables = this.readBits(in, 3);
                    if (totalTables < 2 || totalTables > 6) {
                        throw new DecompressionException("incorrect huffman groups number");
                    }
                    int alphaSize = huffmanSymbolCount + 2;
                    if (alphaSize > 258) {
                        throw new DecompressionException("incorrect alphabet size");
                    }
                    this.huffmanStageDecoder = new Bzip2HuffmanStageDecoder(this, totalTables, alphaSize);
                    this.currentState = State.RECEIVE_SELECTORS_NUMBER;
                }
                case RECEIVE_SELECTORS_NUMBER: {
                    if (in.readableBytes() < 2) {
                        return;
                    }
                    int totalSelectors = this.readBits(in, 15);
                    if (totalSelectors < 1 || totalSelectors > 18002) {
                        throw new DecompressionException("incorrect selectors number");
                    }
                    this.huffmanStageDecoder.selectors = new byte[totalSelectors];
                    this.currentState = State.RECEIVE_SELECTORS;
                }
                case RECEIVE_SELECTORS: {
                    Bzip2HuffmanStageDecoder huffmanStageDecoder = this.huffmanStageDecoder;
                    byte[] selectors = huffmanStageDecoder.selectors;
                    int totalSelectors = selectors.length;
                    Bzip2MoveToFrontTable tableMtf = huffmanStageDecoder.tableMTF;
                    for (int currSelector = huffmanStageDecoder.currentSelector; currSelector < totalSelectors; ++currSelector) {
                        if (!in.isReadable()) {
                            huffmanStageDecoder.currentSelector = currSelector;
                            return;
                        }
                        int index = 0;
                        while (this.readBoolean(in)) {
                            ++index;
                        }
                        selectors[currSelector] = tableMtf.indexToFront(index);
                    }
                    this.currentState = State.RECEIVE_HUFFMAN_LENGTH;
                }
                case RECEIVE_HUFFMAN_LENGTH: {
                    int currGroup;
                    Bzip2HuffmanStageDecoder huffmanStageDecoder = this.huffmanStageDecoder;
                    int totalTables = huffmanStageDecoder.totalTables;
                    byte[][] codeLength = huffmanStageDecoder.tableCodeLengths;
                    int alphaSize = huffmanStageDecoder.alphabetSize;
                    int currLength = huffmanStageDecoder.currentLength;
                    int currAlpha = 0;
                    boolean modifyLength = huffmanStageDecoder.modifyLength;
                    boolean saveStateAndReturn = false;
                    block20: for (currGroup = huffmanStageDecoder.currentGroup; currGroup < totalTables; ++currGroup) {
                        if (!in.isReadable()) {
                            saveStateAndReturn = true;
                            break;
                        }
                        if (currLength < 0) {
                            currLength = this.readBits(in, 5);
                        }
                        for (currAlpha = huffmanStageDecoder.currentAlpha; currAlpha < alphaSize; ++currAlpha) {
                            if (!this.hasBit(in)) {
                                saveStateAndReturn = true;
                                break block20;
                            }
                            while (modifyLength || this.readBoolean(in)) {
                                if (!this.hasBit(in)) {
                                    modifyLength = true;
                                    saveStateAndReturn = true;
                                    break block20;
                                }
                                currLength += this.readBoolean(in) ? -1 : 1;
                                modifyLength = false;
                                if (this.hasBit(in)) continue;
                                saveStateAndReturn = true;
                                break block20;
                            }
                            codeLength[currGroup][currAlpha] = (byte)currLength;
                        }
                        currLength = -1;
                        huffmanStageDecoder.currentAlpha = 0;
                        currAlpha = 0;
                        modifyLength = false;
                    }
                    if (saveStateAndReturn) {
                        huffmanStageDecoder.currentGroup = currGroup;
                        huffmanStageDecoder.currentLength = currLength;
                        huffmanStageDecoder.currentAlpha = currAlpha;
                        huffmanStageDecoder.modifyLength = modifyLength;
                        return;
                    }
                    huffmanStageDecoder.createHuffmanDecodingTables();
                    this.currentState = State.DECODE_HUFFMAN_DATA;
                }
                case DECODE_HUFFMAN_DATA: {
                    Bzip2BlockDecompressor blockDecompressor = this.blockDecompressor;
                    boolean decoded = blockDecompressor.decodeHuffmanData(this.huffmanStageDecoder, in);
                    if (!decoded) {
                        return;
                    }
                    int blockLength = blockDecompressor.blockLength();
                    ByteBuf uncompressed = ctx.alloc().buffer(blockLength);
                    boolean success = false;
                    try {
                        int uncByte;
                        while ((uncByte = blockDecompressor.read()) >= 0) {
                            uncompressed.writeByte(uncByte);
                        }
                        int currentBlockCRC = blockDecompressor.checkCRC();
                        this.streamCRC = (this.streamCRC << 1 | this.streamCRC >>> 31) ^ currentBlockCRC;
                        out.add(uncompressed);
                        success = true;
                    }
                    finally {
                        if (!success) {
                            uncompressed.release();
                        }
                    }
                    this.currentState = State.INIT_BLOCK;
                    continue block15;
                }
                case EOF: {
                    in.skipBytes(in.readableBytes());
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    public boolean isClosed() {
        return this.currentState == State.EOF;
    }

    int readBits(ByteBuf in, int n) {
        int bitCount = this.bitCount;
        int bitBuffer = this.bitBuffer;
        if (bitCount < n) {
            do {
                short uByte = in.readUnsignedByte();
                bitBuffer = bitBuffer << 8 | uByte;
            } while ((bitCount += 8) < n);
            this.bitBuffer = bitBuffer;
        }
        this.bitCount = bitCount -= n;
        return bitBuffer >>> bitCount & (1 << n) - 1;
    }

    private boolean readBoolean(ByteBuf in) {
        return this.readBits(in, 1) != 0;
    }

    private int readInt(ByteBuf in) {
        return this.readBits(in, 16) << 16 | this.readBits(in, 16);
    }

    private boolean hasBit(ByteBuf in) {
        return this.bitCount > 0 || in.isReadable();
    }

    static enum State {
        INIT,
        INIT_BLOCK,
        INIT_BLOCK_PARAMS,
        RECEIVE_HUFFMAN_USED_MAP,
        RECEIVE_HUFFMAN_USED_BITMAPS,
        RECEIVE_SELECTORS_NUMBER,
        RECEIVE_SELECTORS,
        RECEIVE_HUFFMAN_LENGTH,
        DECODE_HUFFMAN_DATA,
        END_BLOCK,
        EOF;

    }
}

