/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.MessageList;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.TypeParameterMatcher;

public abstract class MessageToByteEncoder<I>
extends ChannelOutboundHandlerAdapter {
    private final TypeParameterMatcher matcher;
    private final boolean preferDirect;

    protected MessageToByteEncoder() {
        this(true);
    }

    protected MessageToByteEncoder(Class<? extends I> outboundMessageType) {
        this(outboundMessageType, true);
    }

    protected MessageToByteEncoder(boolean preferDirect) {
        this.matcher = TypeParameterMatcher.find((Object)((Object)this), MessageToByteEncoder.class, (String)"I");
        this.preferDirect = preferDirect;
    }

    protected MessageToByteEncoder(Class<? extends I> outboundMessageType, boolean preferDirect) {
        this.matcher = TypeParameterMatcher.get(outboundMessageType);
        this.preferDirect = preferDirect;
    }

    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return this.matcher.match(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, MessageList<Object> msgs, ChannelPromise promise) throws Exception {
        MessageList out = MessageList.newInstance();
        boolean success = false;
        ByteBuf buf = null;
        try {
            int size = msgs.size();
            for (int i = 0; i < size; ++i) {
                if (ctx.isRemoved()) {
                    if (buf != null && buf.isReadable()) {
                        out.add(buf);
                        buf = null;
                    }
                    out.add(msgs, i, size - i);
                    break;
                }
                Object m = msgs.get(i);
                if (this.acceptOutboundMessage(m)) {
                    Object cast = m;
                    if (buf == null) {
                        buf = this.preferDirect ? ctx.alloc().ioBuffer() : ctx.alloc().heapBuffer();
                    }
                    try {
                        this.encode(ctx, cast, buf);
                        continue;
                    }
                    finally {
                        ReferenceCountUtil.release((Object)cast);
                    }
                }
                if (buf != null && buf.isReadable()) {
                    out.add(buf);
                    buf = null;
                }
                out.add(m);
            }
            if (buf != null && buf.isReadable()) {
                out.add(buf);
                buf = null;
            }
            success = true;
        }
        catch (EncoderException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new EncoderException(e);
        }
        finally {
            msgs.recycle();
            if (buf != null) {
                buf.release();
            }
            if (success) {
                ctx.write(out, promise);
            } else {
                out.releaseAllAndRecycle();
            }
        }
    }

    protected abstract void encode(ChannelHandlerContext var1, I var2, ByteBuf var3) throws Exception;
}

