/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.MessageList;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.DecoderException;
import io.netty.util.internal.StringUtil;

public abstract class ByteToMessageDecoder
extends ChannelInboundHandlerAdapter {
    protected ByteBuf cumulation;
    private boolean singleDecode;
    private boolean decodeWasNull;
    private MessageList<Object> out;

    public void setSingleDecode(boolean singleDecode) {
        this.singleDecode = singleDecode;
    }

    public boolean isSingleDecode() {
        return this.singleDecode;
    }

    protected int actualReadableBytes() {
        return this.internalBuffer().readableBytes();
    }

    protected ByteBuf internalBuffer() {
        if (this.cumulation != null) {
            return this.cumulation;
        }
        return Unpooled.EMPTY_BUFFER;
    }

    public final void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        ByteBuf buf = this.internalBuffer();
        if (buf.isReadable()) {
            if (this.out == null) {
                ctx.fireMessageReceived((Object)buf);
            } else {
                this.out.add((Object)buf.copy());
            }
            buf.clear();
        }
        this.handlerRemoved0(ctx);
    }

    protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageList<Object> msgs) throws Exception {
        this.out = MessageList.newInstance();
        try {
            int size = msgs.size();
            for (int i = 0; i < size; ++i) {
                Object m = msgs.get(i);
                if (ctx.isRemoved()) {
                    this.out.add(msgs, i, size - i);
                    return;
                }
                if (m instanceof ByteBuf) {
                    ByteBuf data = (ByteBuf)m;
                    if (this.cumulation == null) {
                        this.cumulation = data;
                        try {
                            this.callDecode(ctx, data, this.out);
                            continue;
                        }
                        finally {
                            if (!data.isReadable()) {
                                this.cumulation = null;
                                data.release();
                            }
                        }
                    }
                    try {
                        if (this.cumulation.writerIndex() > this.cumulation.maxCapacity() - data.readableBytes()) {
                            ByteBuf oldCumulation = this.cumulation;
                            this.cumulation = ctx.alloc().buffer(oldCumulation.readableBytes() + data.readableBytes());
                            this.cumulation.writeBytes(oldCumulation);
                            oldCumulation.release();
                        }
                        this.cumulation.writeBytes(data);
                        this.callDecode(ctx, this.cumulation, this.out);
                        continue;
                    }
                    finally {
                        if (!this.cumulation.isReadable()) {
                            this.cumulation.release();
                            this.cumulation = null;
                        } else {
                            this.cumulation.discardSomeReadBytes();
                        }
                        data.release();
                    }
                }
                this.out.add(m);
            }
        }
        catch (DecoderException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new DecoderException(t);
        }
        finally {
            if (ctx.isRemoved() && this.cumulation != null) {
                this.cumulation.release();
                this.cumulation = null;
            }
            MessageList<Object> out = this.out;
            this.out = null;
            if (out.isEmpty()) {
                this.decodeWasNull = true;
            }
            msgs.recycle();
            ctx.fireMessageReceived(out);
        }
    }

    public void channelReadSuspended(ChannelHandlerContext ctx) throws Exception {
        if (this.decodeWasNull) {
            this.decodeWasNull = false;
            if (!ctx.channel().config().isAutoRead()) {
                ctx.read();
            }
        }
        super.channelReadSuspended(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        MessageList out = MessageList.newInstance();
        try {
            if (this.cumulation != null) {
                this.callDecode(ctx, this.cumulation, (MessageList<Object>)out);
                this.decodeLast(ctx, this.cumulation, (MessageList<Object>)out);
            } else {
                this.decodeLast(ctx, Unpooled.EMPTY_BUFFER, (MessageList<Object>)out);
            }
        }
        catch (DecoderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DecoderException(e);
        }
        finally {
            if (this.cumulation != null) {
                this.cumulation.release();
                this.cumulation = null;
            }
            ctx.fireMessageReceived(out);
            ctx.fireChannelInactive();
        }
    }

    protected void callDecode(ChannelHandlerContext ctx, ByteBuf in, MessageList<Object> out) {
        try {
            while (in.isReadable()) {
                int outSize = out.size();
                int oldInputLength = in.readableBytes();
                this.decode(ctx, in, out);
                if (outSize == out.size()) {
                    if (oldInputLength != in.readableBytes()) continue;
                } else {
                    if (oldInputLength == in.readableBytes()) {
                        throw new DecoderException(StringUtil.simpleClassName(((Object)((Object)this)).getClass()) + ".decode() did not read anything but decoded a message.");
                    }
                    if (!this.isSingleDecode()) continue;
                }
                break;
            }
        }
        catch (CodecException e) {
            throw e;
        }
        catch (Throwable cause) {
            throw new DecoderException(cause);
        }
    }

    protected abstract void decode(ChannelHandlerContext var1, ByteBuf var2, MessageList<Object> var3) throws Exception;

    protected void decodeLast(ChannelHandlerContext ctx, ByteBuf in, MessageList<Object> out) throws Exception {
        this.decode(ctx, in, out);
    }
}

