/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.BufType;
import io.netty.buffer.BufUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.DefaultMessageBuf;
import io.netty.buffer.MessageBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.Collection;

final class OutputMessageBuf
extends DefaultMessageBuf<Object> {
    private static final ThreadLocal<OutputMessageBuf> output = new ThreadLocal<OutputMessageBuf>(){

        @Override
        protected OutputMessageBuf initialValue() {
            return new OutputMessageBuf();
        }

        @Override
        public OutputMessageBuf get() {
            OutputMessageBuf buf = (OutputMessageBuf)((Object)super.get());
            assert (buf.isEmpty());
            return buf;
        }
    };
    private int byteBufCnt;

    static OutputMessageBuf get() {
        return output.get();
    }

    private OutputMessageBuf() {
        super(2);
    }

    public boolean offer(Object e) {
        boolean added = super.offer(e);
        if (added && e instanceof ByteBuf) {
            ++this.byteBufCnt;
        }
        return added;
    }

    public boolean remove(Object o) {
        boolean removed = super.remove(o);
        if (removed && o instanceof ByteBuf) {
            --this.byteBufCnt;
        }
        return removed;
    }

    public Object poll() {
        Object o = super.poll();
        if (o == null) {
            return o;
        }
        if (o instanceof ByteBuf) {
            --this.byteBufCnt;
        }
        return o;
    }

    public void clear() {
        super.clear();
        this.byteBufCnt = 0;
    }

    public boolean drainToNextInbound(ChannelHandlerContext ctx) {
        int size = this.size();
        if (size == 0) {
            return false;
        }
        int byteBufCnt = this.byteBufCnt;
        if (byteBufCnt == 0 || ctx.nextInboundBufferType() != BufType.BYTE) {
            return this.drainTo((Collection)ctx.nextInboundMessageBuffer()) > 0;
        }
        ByteBuf nextByteBuf = ctx.nextInboundByteBuffer();
        if (byteBufCnt == size) {
            Object o = this.poll();
            do {
                OutputMessageBuf.writeAndRelease(nextByteBuf, (ByteBuf)o);
            } while ((o = this.poll()) != null);
        } else {
            MessageBuf nextMsgBuf = ctx.nextInboundMessageBuffer();
            Object o = this.poll();
            do {
                if (o instanceof ByteBuf) {
                    OutputMessageBuf.writeAndRelease(nextByteBuf, (ByteBuf)o);
                    continue;
                }
                nextMsgBuf.add(o);
            } while ((o = this.poll()) != null);
        }
        return true;
    }

    public boolean drainToNextOutbound(ChannelHandlerContext ctx) {
        int size = this.size();
        if (size == 0) {
            return false;
        }
        int byteBufCnt = this.byteBufCnt;
        if (byteBufCnt == 0 || ctx.nextOutboundBufferType() != BufType.BYTE) {
            return this.drainTo((Collection)ctx.nextOutboundMessageBuffer()) > 0;
        }
        ByteBuf nextByteBuf = ctx.nextOutboundByteBuffer();
        if (byteBufCnt == size) {
            Object o = this.poll();
            do {
                OutputMessageBuf.writeAndRelease(nextByteBuf, (ByteBuf)o);
            } while ((o = this.poll()) != null);
        } else {
            MessageBuf nextMsgBuf = ctx.nextOutboundMessageBuffer();
            Object o = this.poll();
            do {
                if (o instanceof ByteBuf) {
                    OutputMessageBuf.writeAndRelease(nextByteBuf, (ByteBuf)o);
                    continue;
                }
                nextMsgBuf.add(o);
            } while ((o = this.poll()) != null);
        }
        return true;
    }

    private static void writeAndRelease(ByteBuf dst, ByteBuf src) {
        try {
            dst.writeBytes(src, src.readerIndex(), src.readableBytes());
        }
        finally {
            BufUtil.release((Object)src);
        }
    }
}

