/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.compression.CompressionException;

public class Snappy {
    private static final int MAX_HT_SIZE = 16384;
    private static final int MIN_COMPRESSIBLE_BYTES = 15;
    private static final int PREAMBLE_NOT_FULL = -1;
    private static final int LITERAL = 0;
    private static final int COPY_1_BYTE_OFFSET = 1;
    private static final int COPY_2_BYTE_OFFSET = 2;
    private static final int COPY_4_BYTE_OFFSET = 3;
    private State state = State.READY;
    private byte tag;

    public void reset() {
        this.state = State.READY;
        this.tag = 0;
    }

    public void encode(ByteBuf in, ByteBuf out, int length) {
        int b;
        int i = 0;
        while (true) {
            if (((b = length >>> i * 7) & 0xFFFFFF80) == 0) break;
            out.writeByte(b & 0x7F | 0x80);
            ++i;
        }
        out.writeByte(b);
        int inIndex = in.readerIndex();
        int baseIndex = in.readerIndex();
        int maxIndex = length;
        short[] table = Snappy.getHashTable(maxIndex);
        int shift = 32 - (int)Math.floor(Math.log(table.length) / Math.log(2.0));
        int nextEmit = inIndex;
        if (maxIndex - inIndex >= 15) {
            int nextHash = Snappy.hash(in, ++inIndex, shift);
            block1: while (true) {
                int insertTail;
                int candidate;
                int skip = 32;
                int nextIndex = inIndex;
                do {
                    int bytesBetweenHashLookups;
                    inIndex = nextIndex;
                    int hash = nextHash;
                    if ((nextIndex = inIndex + (bytesBetweenHashLookups = skip++ >> 5)) > maxIndex) break block1;
                    nextHash = Snappy.hash(in, nextIndex, shift);
                    candidate = baseIndex + table[hash];
                    table[hash] = (short)(inIndex - baseIndex);
                } while (in.getInt(inIndex) != in.getInt(candidate));
                Snappy.encodeLiteral(in, out, inIndex - nextEmit);
                do {
                    int base = inIndex;
                    int matched = 4 + Snappy.findMatchingLength(in, candidate + 4, inIndex + 4, maxIndex);
                    int offset = base - candidate;
                    Snappy.encodeCopy(out, offset, matched);
                    in.readerIndex(in.readerIndex() + matched);
                    insertTail = (inIndex += matched) - 1;
                    nextEmit = inIndex;
                    if (inIndex >= maxIndex - 4) break block1;
                    int prevHash = Snappy.hash(in, insertTail, shift);
                    table[prevHash] = (short)(inIndex - baseIndex - 1);
                    int currentHash = Snappy.hash(in, insertTail + 1, shift);
                    candidate = baseIndex + table[currentHash];
                    table[currentHash] = (short)(inIndex - baseIndex);
                } while (in.getInt(insertTail + 1) == in.getInt(candidate));
                nextHash = Snappy.hash(in, insertTail + 2, shift);
                ++inIndex;
            }
        }
        if (nextEmit < maxIndex) {
            Snappy.encodeLiteral(in, out, maxIndex - nextEmit);
        }
    }

    private static int hash(ByteBuf in, int index, int shift) {
        return in.getInt(index) + 506832829 >>> shift;
    }

    private static short[] getHashTable(int inputSize) {
        int htSize;
        for (htSize = 256; htSize < 16384 && htSize < inputSize; htSize <<= 1) {
        }
        short[] table = htSize <= 256 ? new short[256] : new short[16384];
        return table;
    }

    private static int findMatchingLength(ByteBuf in, int minIndex, int inIndex, int maxIndex) {
        int matched = 0;
        while (inIndex <= maxIndex - 4 && in.getInt(inIndex) == in.getInt(minIndex + matched)) {
            inIndex += 4;
            matched += 4;
        }
        while (inIndex < maxIndex && in.getByte(minIndex + matched) == in.getByte(inIndex)) {
            ++inIndex;
            ++matched;
        }
        return matched;
    }

    private static int bitsToEncode(int value) {
        int highestOneBit = Integer.highestOneBit(value);
        int bitLength = 0;
        while ((highestOneBit >>= 1) != 0) {
            ++bitLength;
        }
        return bitLength;
    }

    private static void encodeLiteral(ByteBuf in, ByteBuf out, int length) {
        if (length < 61) {
            out.writeByte(length - 1 << 2);
        } else {
            int bitLength = Snappy.bitsToEncode(length - 1);
            int bytesToEncode = 1 + bitLength / 8;
            out.writeByte(59 + bytesToEncode << 2);
            for (int i = 0; i < bytesToEncode; ++i) {
                out.writeByte(length - 1 >> i * 8 & 0xFF);
            }
        }
        out.writeBytes(in, length);
    }

    private static void encodeCopyWithOffset(ByteBuf out, int offset, int length) {
        if (length < 12 && offset < 2048) {
            out.writeByte(1 | length - 4 << 2 | offset >> 8 << 5);
            out.writeByte(offset & 0xFF);
        } else {
            out.writeByte(2 | length - 1 << 2);
            out.writeByte(offset & 0xFF);
            out.writeByte(offset >> 8 & 0xFF);
        }
    }

    private static void encodeCopy(ByteBuf out, int offset, int length) {
        while (length >= 68) {
            Snappy.encodeCopyWithOffset(out, offset, 64);
            length -= 64;
        }
        if (length > 64) {
            Snappy.encodeCopyWithOffset(out, offset, 60);
            length -= 60;
        }
        Snappy.encodeCopyWithOffset(out, offset, length);
    }

    public void decode(ByteBuf in, ByteBuf out) {
        while (in.isReadable()) {
            block0 : switch (this.state) {
                case READY: {
                    this.state = State.READING_PREAMBLE;
                }
                case READING_PREAMBLE: {
                    int uncompressedLength = Snappy.readPreamble(in);
                    if (uncompressedLength == -1) {
                        return;
                    }
                    if (uncompressedLength == 0) {
                        this.state = State.READY;
                        return;
                    }
                    out.ensureWritable(uncompressedLength);
                    this.state = State.READING_TAG;
                }
                case READING_TAG: {
                    if (!in.isReadable()) {
                        return;
                    }
                    this.tag = in.readByte();
                    switch (this.tag & 3) {
                        case 0: {
                            this.state = State.READING_LITERAL;
                            break block0;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            this.state = State.READING_COPY;
                        }
                    }
                    break;
                }
                case READING_LITERAL: {
                    if (Snappy.decodeLiteral(this.tag, in, out)) {
                        this.state = State.READING_TAG;
                        break;
                    }
                    return;
                }
                case READING_COPY: {
                    switch (this.tag & 3) {
                        case 1: {
                            if (Snappy.decodeCopyWith1ByteOffset(this.tag, in, out)) {
                                this.state = State.READING_TAG;
                                break block0;
                            }
                            return;
                        }
                        case 2: {
                            if (Snappy.decodeCopyWith2ByteOffset(this.tag, in, out)) {
                                this.state = State.READING_TAG;
                                break block0;
                            }
                            return;
                        }
                        case 3: {
                            if (Snappy.decodeCopyWith4ByteOffset(this.tag, in, out)) {
                                this.state = State.READING_TAG;
                                break block0;
                            }
                            return;
                        }
                    }
                }
            }
        }
    }

    private static int readPreamble(ByteBuf in) {
        int length = 0;
        int byteIndex = 0;
        while (in.isReadable()) {
            short current = in.readUnsignedByte();
            length |= (current & 0x7F) << byteIndex++ * 7;
            if ((current & 0x80) == 0) {
                return length;
            }
            if (byteIndex < 4) continue;
            throw new CompressionException("Preamble is greater than 4 bytes");
        }
        return 0;
    }

    private static boolean decodeLiteral(byte tag, ByteBuf in, ByteBuf out) {
        int length;
        in.markReaderIndex();
        switch (tag >> 2 & 0x3F) {
            case 60: {
                if (!in.isReadable()) {
                    return false;
                }
                length = in.readUnsignedByte();
                break;
            }
            case 61: {
                if (in.readableBytes() < 2) {
                    return false;
                }
                length = in.readUnsignedByte() | in.readUnsignedByte() << 8;
                break;
            }
            case 62: {
                if (in.readableBytes() < 3) {
                    return false;
                }
                length = in.readUnsignedByte() | in.readUnsignedByte() << 8 | in.readUnsignedByte() << 16;
                break;
            }
            case 64: {
                if (in.readableBytes() < 4) {
                    return false;
                }
                length = in.readUnsignedByte() | in.readUnsignedByte() << 8 | in.readUnsignedByte() << 16 | in.readUnsignedByte() << 24;
                break;
            }
            default: {
                length = tag >> 2 & 0x3F;
            }
        }
        if (in.readableBytes() < ++length) {
            in.resetReaderIndex();
            return false;
        }
        out.writeBytes(in, length);
        return true;
    }

    private static boolean decodeCopyWith1ByteOffset(byte tag, ByteBuf in, ByteBuf out) {
        if (!in.isReadable()) {
            return false;
        }
        int initialIndex = out.readableBytes();
        int length = 4 + ((tag & 0x1C) >> 2);
        int offset = (tag & 0xE0) << 8 | in.readUnsignedByte();
        Snappy.validateOffset(offset, initialIndex);
        out.markReaderIndex();
        if (offset < length) {
            for (int copies = length / offset; copies > 0; --copies) {
                out.readerIndex(initialIndex - offset);
                out.readBytes(out, offset);
            }
            if (length % offset != 0) {
                out.readerIndex(initialIndex - offset);
                out.readBytes(out, length % offset);
            }
        } else {
            out.readerIndex(initialIndex - offset);
            out.readBytes(out, length);
        }
        out.resetReaderIndex();
        return true;
    }

    private static boolean decodeCopyWith2ByteOffset(byte tag, ByteBuf in, ByteBuf out) {
        if (in.readableBytes() < 2) {
            return false;
        }
        int initialIndex = out.readableBytes();
        int length = 1 + (tag >> 2 & 0x3F);
        int offset = in.readUnsignedByte() | in.readUnsignedByte() << 8;
        Snappy.validateOffset(offset, initialIndex);
        out.markReaderIndex();
        if (offset < length) {
            for (int copies = length / offset; copies > 0; --copies) {
                out.readerIndex(initialIndex - offset);
                out.readBytes(out, offset);
            }
            if (length % offset != 0) {
                out.readerIndex(initialIndex - offset);
                out.readBytes(out, length % offset);
            }
        } else {
            out.readerIndex(initialIndex - offset);
            out.readBytes(out, length);
        }
        out.resetReaderIndex();
        return true;
    }

    private static boolean decodeCopyWith4ByteOffset(byte tag, ByteBuf in, ByteBuf out) {
        if (in.readableBytes() < 4) {
            return false;
        }
        int initialIndex = out.readableBytes();
        int length = 1 + (tag >> 2 & 0x3F);
        int offset = in.readUnsignedByte() | in.readUnsignedByte() << 8 | in.readUnsignedByte() << 16 | in.readUnsignedByte() << 24;
        Snappy.validateOffset(offset, initialIndex);
        out.markReaderIndex();
        if (offset < length) {
            for (int copies = length / offset; copies > 0; --copies) {
                out.readerIndex(initialIndex - offset);
                out.readBytes(out, offset);
            }
            if (length % offset != 0) {
                out.readerIndex(initialIndex - offset);
                out.readBytes(out, length % offset);
            }
        } else {
            out.readerIndex(initialIndex - offset);
            out.readBytes(out, length);
        }
        out.resetReaderIndex();
        return true;
    }

    private static void validateOffset(int offset, int chunkSizeSoFar) {
        if (offset > Short.MAX_VALUE) {
            throw new CompressionException("Offset exceeds maximum permissible value");
        }
        if (offset <= 0) {
            throw new CompressionException("Offset is less than minimum permissible value");
        }
        if (offset > chunkSizeSoFar) {
            throw new CompressionException("Offset exceeds size of chunk");
        }
    }

    private static enum State {
        READY,
        READING_PREAMBLE,
        READING_TAG,
        READING_LITERAL,
        READING_COPY;

    }
}

