/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.xml;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.xml.XmlAttribute;
import io.netty.handler.codec.xml.XmlCdata;
import io.netty.handler.codec.xml.XmlCharacters;
import io.netty.handler.codec.xml.XmlComment;
import io.netty.handler.codec.xml.XmlDTD;
import io.netty.handler.codec.xml.XmlDecoder;
import io.netty.handler.codec.xml.XmlDocumentStart;
import io.netty.handler.codec.xml.XmlElementEnd;
import io.netty.handler.codec.xml.XmlElementStart;
import io.netty.handler.codec.xml.XmlEntityReference;
import io.netty.handler.codec.xml.XmlNamespace;
import io.netty.handler.codec.xml.XmlProcessingInstruction;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class XmlDecoderTest {
    private static final String XML1 = "<?xml version=\"1.0\"?><!DOCTYPE employee SYSTEM \"employee.dtd\"><?xml-stylesheet type=\"text/css\" href=\"netty.css\"?><?xml-test ?><employee xmlns:nettya=\"https://netty.io/netty/a\"><nettya:id>&plusmn;1</nettya:id>\n<name ";
    private static final String XML2 = "type=\"given\">Alba</name><![CDATA[ <some data &gt;/> ]]>   <!-- namespaced --><nettyb:salary xmlns:nettyb=\"https://netty.io/netty/b\" nettyb:period=\"weekly\">100</nettyb:salary><last/></employee>";
    private static final String XML3 = "<?xml version=\"1.1\" encoding=\"UTf-8\" standalone=\"yes\"?><netty></netty>";
    private static final String XML4 = "<netty></netty>";
    private EmbeddedChannel channel;

    @Before
    public void setup() throws Exception {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new XmlDecoder()});
    }

    @After
    public void teardown() throws Exception {
        this.channel.finish();
    }

    @Test
    public void shouldDecodeRequestWithSimpleXml() {
        this.write(XML1);
        Object temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlDocumentStart.class));
        MatcherAssert.assertThat((Object)((XmlDocumentStart)temp).version(), (Matcher)CoreMatchers.is((Object)"1.0"));
        MatcherAssert.assertThat((Object)((XmlDocumentStart)temp).encoding(), (Matcher)CoreMatchers.is((Object)"UTF-8"));
        MatcherAssert.assertThat((Object)((XmlDocumentStart)temp).standalone(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)((XmlDocumentStart)temp).encodingScheme(), (Matcher)CoreMatchers.is((Matcher)IsNull.nullValue()));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlDTD.class));
        MatcherAssert.assertThat((Object)((XmlDTD)temp).text(), (Matcher)CoreMatchers.is((Object)"employee.dtd"));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlProcessingInstruction.class));
        MatcherAssert.assertThat((Object)((XmlProcessingInstruction)temp).target(), (Matcher)CoreMatchers.is((Object)"xml-stylesheet"));
        MatcherAssert.assertThat((Object)((XmlProcessingInstruction)temp).data(), (Matcher)CoreMatchers.is((Object)"type=\"text/css\" href=\"netty.css\""));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlProcessingInstruction.class));
        MatcherAssert.assertThat((Object)((XmlProcessingInstruction)temp).target(), (Matcher)CoreMatchers.is((Object)"xml-test"));
        MatcherAssert.assertThat((Object)((XmlProcessingInstruction)temp).data(), (Matcher)CoreMatchers.is((Object)""));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlElementStart.class));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).name(), (Matcher)CoreMatchers.is((Object)"employee"));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).prefix(), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).namespace(), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).attributes().size(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).namespaces().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((XmlNamespace)((XmlElementStart)temp).namespaces().get(0)).prefix(), (Matcher)CoreMatchers.is((Object)"nettya"));
        MatcherAssert.assertThat((Object)((XmlNamespace)((XmlElementStart)temp).namespaces().get(0)).uri(), (Matcher)CoreMatchers.is((Object)"https://netty.io/netty/a"));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlElementStart.class));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).name(), (Matcher)CoreMatchers.is((Object)"id"));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).prefix(), (Matcher)CoreMatchers.is((Object)"nettya"));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).namespace(), (Matcher)CoreMatchers.is((Object)"https://netty.io/netty/a"));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).attributes().size(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).namespaces().size(), (Matcher)CoreMatchers.is((Object)0));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlEntityReference.class));
        MatcherAssert.assertThat((Object)((XmlEntityReference)temp).name(), (Matcher)CoreMatchers.is((Object)"plusmn"));
        MatcherAssert.assertThat((Object)((XmlEntityReference)temp).text(), (Matcher)CoreMatchers.is((Object)""));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlCharacters.class));
        MatcherAssert.assertThat((Object)((XmlCharacters)temp).data(), (Matcher)CoreMatchers.is((Object)"1"));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlElementEnd.class));
        MatcherAssert.assertThat((Object)((XmlElementEnd)temp).name(), (Matcher)CoreMatchers.is((Object)"id"));
        MatcherAssert.assertThat((Object)((XmlElementEnd)temp).prefix(), (Matcher)CoreMatchers.is((Object)"nettya"));
        MatcherAssert.assertThat((Object)((XmlElementEnd)temp).namespace(), (Matcher)CoreMatchers.is((Object)"https://netty.io/netty/a"));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlCharacters.class));
        MatcherAssert.assertThat((Object)((XmlCharacters)temp).data(), (Matcher)CoreMatchers.is((Object)"\n"));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)IsNull.nullValue());
        this.write(XML2);
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlElementStart.class));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).name(), (Matcher)CoreMatchers.is((Object)"name"));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).prefix(), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).namespace(), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).attributes().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((XmlAttribute)((XmlElementStart)temp).attributes().get(0)).name(), (Matcher)CoreMatchers.is((Object)"type"));
        MatcherAssert.assertThat((Object)((XmlAttribute)((XmlElementStart)temp).attributes().get(0)).value(), (Matcher)CoreMatchers.is((Object)"given"));
        MatcherAssert.assertThat((Object)((XmlAttribute)((XmlElementStart)temp).attributes().get(0)).prefix(), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)((XmlAttribute)((XmlElementStart)temp).attributes().get(0)).namespace(), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).namespaces().size(), (Matcher)CoreMatchers.is((Object)0));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlCharacters.class));
        MatcherAssert.assertThat((Object)((XmlCharacters)temp).data(), (Matcher)CoreMatchers.is((Object)"Alba"));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlElementEnd.class));
        MatcherAssert.assertThat((Object)((XmlElementEnd)temp).name(), (Matcher)CoreMatchers.is((Object)"name"));
        MatcherAssert.assertThat((Object)((XmlElementEnd)temp).prefix(), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)((XmlElementEnd)temp).namespace(), (Matcher)CoreMatchers.is((Object)""));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlCdata.class));
        MatcherAssert.assertThat((Object)((XmlCdata)temp).data(), (Matcher)CoreMatchers.is((Object)" <some data &gt;/> "));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlCharacters.class));
        MatcherAssert.assertThat((Object)((XmlCharacters)temp).data(), (Matcher)CoreMatchers.is((Object)"   "));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlComment.class));
        MatcherAssert.assertThat((Object)((XmlComment)temp).data(), (Matcher)CoreMatchers.is((Object)" namespaced "));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlElementStart.class));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).name(), (Matcher)CoreMatchers.is((Object)"salary"));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).prefix(), (Matcher)CoreMatchers.is((Object)"nettyb"));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).namespace(), (Matcher)CoreMatchers.is((Object)"https://netty.io/netty/b"));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).attributes().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((XmlAttribute)((XmlElementStart)temp).attributes().get(0)).name(), (Matcher)CoreMatchers.is((Object)"period"));
        MatcherAssert.assertThat((Object)((XmlAttribute)((XmlElementStart)temp).attributes().get(0)).value(), (Matcher)CoreMatchers.is((Object)"weekly"));
        MatcherAssert.assertThat((Object)((XmlAttribute)((XmlElementStart)temp).attributes().get(0)).prefix(), (Matcher)CoreMatchers.is((Object)"nettyb"));
        MatcherAssert.assertThat((Object)((XmlAttribute)((XmlElementStart)temp).attributes().get(0)).namespace(), (Matcher)CoreMatchers.is((Object)"https://netty.io/netty/b"));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).namespaces().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((XmlNamespace)((XmlElementStart)temp).namespaces().get(0)).prefix(), (Matcher)CoreMatchers.is((Object)"nettyb"));
        MatcherAssert.assertThat((Object)((XmlNamespace)((XmlElementStart)temp).namespaces().get(0)).uri(), (Matcher)CoreMatchers.is((Object)"https://netty.io/netty/b"));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlCharacters.class));
        MatcherAssert.assertThat((Object)((XmlCharacters)temp).data(), (Matcher)CoreMatchers.is((Object)"100"));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlElementEnd.class));
        MatcherAssert.assertThat((Object)((XmlElementEnd)temp).name(), (Matcher)CoreMatchers.is((Object)"salary"));
        MatcherAssert.assertThat((Object)((XmlElementEnd)temp).prefix(), (Matcher)CoreMatchers.is((Object)"nettyb"));
        MatcherAssert.assertThat((Object)((XmlElementEnd)temp).namespace(), (Matcher)CoreMatchers.is((Object)"https://netty.io/netty/b"));
        MatcherAssert.assertThat((Object)((XmlElementEnd)temp).namespaces().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((XmlNamespace)((XmlElementEnd)temp).namespaces().get(0)).prefix(), (Matcher)CoreMatchers.is((Object)"nettyb"));
        MatcherAssert.assertThat((Object)((XmlNamespace)((XmlElementEnd)temp).namespaces().get(0)).uri(), (Matcher)CoreMatchers.is((Object)"https://netty.io/netty/b"));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlElementStart.class));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).name(), (Matcher)CoreMatchers.is((Object)"last"));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).prefix(), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).namespace(), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).attributes().size(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).namespaces().size(), (Matcher)CoreMatchers.is((Object)0));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlElementEnd.class));
        MatcherAssert.assertThat((Object)((XmlElementEnd)temp).name(), (Matcher)CoreMatchers.is((Object)"last"));
        MatcherAssert.assertThat((Object)((XmlElementEnd)temp).prefix(), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)((XmlElementEnd)temp).namespace(), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)((XmlElementEnd)temp).namespaces().size(), (Matcher)CoreMatchers.is((Object)0));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlElementEnd.class));
        MatcherAssert.assertThat((Object)((XmlElementEnd)temp).name(), (Matcher)CoreMatchers.is((Object)"employee"));
        MatcherAssert.assertThat((Object)((XmlElementEnd)temp).prefix(), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)((XmlElementEnd)temp).namespace(), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)((XmlElementEnd)temp).namespaces().size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((XmlNamespace)((XmlElementEnd)temp).namespaces().get(0)).prefix(), (Matcher)CoreMatchers.is((Object)"nettya"));
        MatcherAssert.assertThat((Object)((XmlNamespace)((XmlElementEnd)temp).namespaces().get(0)).uri(), (Matcher)CoreMatchers.is((Object)"https://netty.io/netty/a"));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)IsNull.nullValue());
    }

    @Test
    public void shouldDecodeXmlHeader() {
        this.write(XML3);
        Object temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlDocumentStart.class));
        MatcherAssert.assertThat((Object)((XmlDocumentStart)temp).version(), (Matcher)CoreMatchers.is((Object)"1.1"));
        MatcherAssert.assertThat((Object)((XmlDocumentStart)temp).encoding(), (Matcher)CoreMatchers.is((Object)"UTF-8"));
        MatcherAssert.assertThat((Object)((XmlDocumentStart)temp).standalone(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((XmlDocumentStart)temp).encodingScheme(), (Matcher)CoreMatchers.is((Object)"UTF-8"));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlElementStart.class));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).name(), (Matcher)CoreMatchers.is((Object)"netty"));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).prefix(), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).namespace(), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).attributes().size(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).namespaces().size(), (Matcher)CoreMatchers.is((Object)0));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlElementEnd.class));
        MatcherAssert.assertThat((Object)((XmlElementEnd)temp).name(), (Matcher)CoreMatchers.is((Object)"netty"));
        MatcherAssert.assertThat((Object)((XmlElementEnd)temp).prefix(), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)((XmlElementEnd)temp).namespace(), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)((XmlElementEnd)temp).namespaces().size(), (Matcher)CoreMatchers.is((Object)0));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)IsNull.nullValue());
    }

    @Test
    public void shouldDecodeWithoutHeader() {
        this.write(XML4);
        Object temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlDocumentStart.class));
        MatcherAssert.assertThat((Object)((XmlDocumentStart)temp).version(), (Matcher)CoreMatchers.is((Matcher)IsNull.nullValue()));
        MatcherAssert.assertThat((Object)((XmlDocumentStart)temp).encoding(), (Matcher)CoreMatchers.is((Object)"UTF-8"));
        MatcherAssert.assertThat((Object)((XmlDocumentStart)temp).standalone(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)((XmlDocumentStart)temp).encodingScheme(), (Matcher)CoreMatchers.is((Matcher)IsNull.nullValue()));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlElementStart.class));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).name(), (Matcher)CoreMatchers.is((Object)"netty"));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).prefix(), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).namespace(), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).attributes().size(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)((XmlElementStart)temp).namespaces().size(), (Matcher)CoreMatchers.is((Object)0));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)CoreMatchers.instanceOf(XmlElementEnd.class));
        MatcherAssert.assertThat((Object)((XmlElementEnd)temp).name(), (Matcher)CoreMatchers.is((Object)"netty"));
        MatcherAssert.assertThat((Object)((XmlElementEnd)temp).prefix(), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)((XmlElementEnd)temp).namespace(), (Matcher)CoreMatchers.is((Object)""));
        MatcherAssert.assertThat((Object)((XmlElementEnd)temp).namespaces().size(), (Matcher)CoreMatchers.is((Object)0));
        temp = this.channel.readInbound();
        MatcherAssert.assertThat((Object)temp, (Matcher)IsNull.nullValue());
    }

    private void write(String content) {
        MatcherAssert.assertThat((Object)this.channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)content, (Charset)CharsetUtil.UTF_8)}), (Matcher)CoreMatchers.is((Object)true));
    }
}

