/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.stomp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.stomp.StompCommand;
import io.netty.handler.codec.stomp.StompFrame;
import io.netty.handler.codec.stomp.StompSubframeAggregator;
import io.netty.handler.codec.stomp.StompSubframeDecoder;
import io.netty.handler.codec.stomp.StompTestConstants;
import io.netty.util.CharsetUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StompSubframeAggregatorTest {
    private EmbeddedChannel channel;

    @Before
    public void setup() throws Exception {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new StompSubframeDecoder(), new StompSubframeAggregator(100000)});
    }

    @After
    public void teardown() throws Exception {
        Assert.assertFalse((boolean)this.channel.finish());
    }

    @Test
    public void testSingleFrameDecoding() {
        ByteBuf incoming = Unpooled.buffer();
        incoming.writeBytes("CONNECT\nhost:stomp.github.org\naccept-version:1.1,1.2\n\n\u0000".getBytes());
        this.channel.writeInbound(new Object[]{incoming});
        StompFrame frame = (StompFrame)this.channel.readInbound();
        frame.release();
        Assert.assertNull((Object)this.channel.readInbound());
    }

    @Test
    public void testSingleFrameWithBodyAndContentLength() {
        ByteBuf incoming = Unpooled.buffer();
        incoming.writeBytes("SEND\ndestination:/queue/a\ncontent-type:text/plain\ncontent-length:17\n\nhello, queue a!!!\u0000\n".getBytes());
        this.channel.writeInbound(new Object[]{incoming});
        StompFrame frame = (StompFrame)this.channel.readInbound();
        Assert.assertNotNull((Object)frame);
        Assert.assertEquals((Object)StompCommand.SEND, (Object)frame.command());
        Assert.assertEquals((Object)"hello, queue a!!!", (Object)frame.content().toString(CharsetUtil.UTF_8));
        frame.release();
        Assert.assertNull((Object)this.channel.readInbound());
    }

    @Test
    public void testSingleFrameWithBodyAndNoContentLength() {
        ByteBuf incoming = Unpooled.buffer();
        incoming.writeBytes("SEND\ndestination:/queue/a\ncontent-type:text/plain\n\nbody\u0000".getBytes());
        this.channel.writeInbound(new Object[]{incoming});
        StompFrame frame = (StompFrame)this.channel.readInbound();
        Assert.assertNotNull((Object)frame);
        Assert.assertEquals((Object)StompCommand.SEND, (Object)frame.command());
        Assert.assertEquals((Object)"body", (Object)frame.content().toString(CharsetUtil.UTF_8));
        frame.release();
        Assert.assertNull((Object)this.channel.readInbound());
    }

    @Test
    public void testSingleFrameWithSplitBodyAndNoContentLength() {
        for (int n = 0; n < StompTestConstants.SEND_FRAMES_3.length; ++n) {
            ByteBuf incoming = Unpooled.buffer();
            incoming.writeBytes(StompTestConstants.SEND_FRAMES_3[n].getBytes());
            this.channel.writeInbound(new Object[]{incoming});
            this.channel.flush();
        }
        StompFrame frame = (StompFrame)this.channel.readInbound();
        Assert.assertNotNull((Object)frame);
        Assert.assertEquals((Object)StompCommand.SEND, (Object)frame.command());
        Assert.assertEquals((Object)"first part of body\nsecond part of body", (Object)frame.content().toString(CharsetUtil.UTF_8));
        frame.release();
        Assert.assertNull((Object)this.channel.readInbound());
    }

    @Test
    public void testSingleFrameChunked() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new StompSubframeDecoder(10000, 5), new StompSubframeAggregator(100000)});
        ByteBuf incoming = Unpooled.buffer();
        incoming.writeBytes("SEND\ndestination:/queue/a\ncontent-type:text/plain\ncontent-length:17\n\nhello, queue a!!!\u0000\n".getBytes());
        channel.writeInbound(new Object[]{incoming});
        StompFrame frame = (StompFrame)channel.readInbound();
        Assert.assertNotNull((Object)frame);
        Assert.assertEquals((Object)StompCommand.SEND, (Object)frame.command());
        frame.release();
        Assert.assertNull((Object)channel.readInbound());
    }

    @Test
    public void testMultipleFramesDecoding() {
        ByteBuf incoming = Unpooled.buffer();
        incoming.writeBytes("CONNECT\nhost:stomp.github.org\naccept-version:1.1,1.2\n\n\u0000".getBytes());
        incoming.writeBytes("CONNECTED\nversion:1.2\n\n\u0000\n".getBytes());
        this.channel.writeInbound(new Object[]{incoming});
        this.channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])"SEND\ndestination:/queue/a\ncontent-type:text/plain\n\nhello, queue a!\u0000\n".getBytes())});
        StompFrame frame = (StompFrame)this.channel.readInbound();
        Assert.assertEquals((Object)StompCommand.CONNECT, (Object)frame.command());
        frame.release();
        frame = (StompFrame)this.channel.readInbound();
        Assert.assertEquals((Object)StompCommand.CONNECTED, (Object)frame.command());
        frame.release();
        frame = (StompFrame)this.channel.readInbound();
        Assert.assertEquals((Object)StompCommand.SEND, (Object)frame.command());
        frame.release();
        Assert.assertNull((Object)this.channel.readInbound());
    }

    @Test(expected=TooLongFrameException.class)
    public void testTooLongFrameException() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new StompSubframeDecoder(), new StompSubframeAggregator(10)});
        channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])"SEND\ndestination:/queue/a\ncontent-type:text/plain\n\nhello, queue a!\u0000\n".getBytes())});
    }
}

