/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.stomp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.stomp.DefaultStompFrame;
import io.netty.handler.codec.stomp.DefaultStompHeadersSubframe;
import io.netty.handler.codec.stomp.LastStompContentSubframe;
import io.netty.handler.codec.stomp.StompCommand;
import io.netty.handler.codec.stomp.StompHeaders;
import io.netty.handler.codec.stomp.StompSubframeEncoder;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StompSubframeEncoderTest {
    private EmbeddedChannel channel;

    @Before
    public void setup() throws Exception {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new StompSubframeEncoder()});
    }

    @After
    public void teardown() throws Exception {
        Assert.assertFalse((boolean)this.channel.finish());
    }

    @Test
    public void testFrameAndContentEncoding() {
        DefaultStompHeadersSubframe frame = new DefaultStompHeadersSubframe(StompCommand.CONNECT);
        StompHeaders headers = frame.headers();
        headers.set((Object)StompHeaders.HOST, (Object)"stomp.github.org");
        headers.set((Object)StompHeaders.ACCEPT_VERSION, (Object)"1.1,1.2");
        this.channel.writeOutbound(new Object[]{frame});
        this.channel.writeOutbound(new Object[]{LastStompContentSubframe.EMPTY_LAST_CONTENT});
        ByteBuf aggregatedBuffer = Unpooled.buffer();
        ByteBuf byteBuf = (ByteBuf)this.channel.readOutbound();
        Assert.assertNotNull((Object)byteBuf);
        aggregatedBuffer.writeBytes(byteBuf);
        byteBuf.release();
        byteBuf = (ByteBuf)this.channel.readOutbound();
        Assert.assertNotNull((Object)byteBuf);
        aggregatedBuffer.writeBytes(byteBuf);
        byteBuf.release();
        aggregatedBuffer.resetReaderIndex();
        String content = aggregatedBuffer.toString(CharsetUtil.UTF_8);
        Assert.assertEquals((Object)"CONNECT\nhost:stomp.github.org\naccept-version:1.1,1.2\n\n\u0000", (Object)content);
        aggregatedBuffer.release();
    }

    @Test
    public void testUtf8FrameEncoding() {
        DefaultStompFrame frame = new DefaultStompFrame(StompCommand.SEND, Unpooled.wrappedBuffer((byte[])"body".getBytes(CharsetUtil.UTF_8)));
        StompHeaders incoming = frame.headers();
        incoming.set((Object)StompHeaders.DESTINATION, (Object)"/queue/\u211611\u00b1\u265b\u043d\u0435\u0442\u0442\u0438\u2655");
        incoming.set((Object)StompHeaders.CONTENT_TYPE, (Object)AsciiString.of((CharSequence)"text/plain"));
        this.channel.writeOutbound(new Object[]{frame});
        ByteBuf headers = (ByteBuf)this.channel.readOutbound();
        ByteBuf content = (ByteBuf)this.channel.readOutbound();
        ByteBuf fullFrame = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{headers, content});
        Assert.assertEquals((Object)"SEND\ndestination:/queue/\u211611\u00b1\u265b\u043d\u0435\u0442\u0442\u0438\u2655\ncontent-type:text/plain\n\nbody\u0000", (Object)fullFrame.toString(CharsetUtil.UTF_8));
        Assert.assertTrue((boolean)fullFrame.release());
    }
}

