/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socks;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.socks.SocksAddressType;
import io.netty.handler.codec.socks.SocksCmdResponse;
import io.netty.handler.codec.socks.SocksCmdStatus;
import io.netty.handler.codec.socks.SocksProtocolVersion;
import io.netty.util.CharsetUtil;
import java.net.IDN;
import java.nio.CharBuffer;
import org.junit.Assert;
import org.junit.Test;

public class SocksCmdResponseTest {
    @Test
    public void testConstructorParamsAreNotNull() {
        try {
            new SocksCmdResponse(null, SocksAddressType.UNKNOWN);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof NullPointerException));
        }
        try {
            new SocksCmdResponse(SocksCmdStatus.UNASSIGNED, null);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof NullPointerException));
        }
    }

    @Test
    public void testEmptyDomain() {
        SocksCmdResponse socksCmdResponse = new SocksCmdResponse(SocksCmdStatus.SUCCESS, SocksAddressType.DOMAIN);
        Assert.assertNull((Object)socksCmdResponse.host());
        Assert.assertEquals((long)0L, (long)socksCmdResponse.port());
        ByteBuf buffer = Unpooled.buffer((int)20);
        socksCmdResponse.encodeAsByteBuf(buffer);
        byte[] expected = new byte[]{5, 0, 0, 3, 1, 0, 0, 0};
        SocksCmdResponseTest.assertByteBufEquals(expected, buffer);
    }

    @Test
    public void testIPv4Host() {
        SocksCmdResponse socksCmdResponse = new SocksCmdResponse(SocksCmdStatus.SUCCESS, SocksAddressType.IPv4, "127.0.0.1", 80);
        Assert.assertEquals((Object)"127.0.0.1", (Object)socksCmdResponse.host());
        Assert.assertEquals((long)80L, (long)socksCmdResponse.port());
        ByteBuf buffer = Unpooled.buffer((int)20);
        socksCmdResponse.encodeAsByteBuf(buffer);
        byte[] expected = new byte[]{5, 0, 0, 1, 127, 0, 0, 1, 0, 80};
        SocksCmdResponseTest.assertByteBufEquals(expected, buffer);
    }

    @Test
    public void testEmptyBoundAddress() {
        SocksCmdResponse socksCmdResponse = new SocksCmdResponse(SocksCmdStatus.SUCCESS, SocksAddressType.DOMAIN, "", 80);
        Assert.assertEquals((Object)"", (Object)socksCmdResponse.host());
        Assert.assertEquals((long)80L, (long)socksCmdResponse.port());
        ByteBuf buffer = Unpooled.buffer((int)20);
        socksCmdResponse.encodeAsByteBuf(buffer);
        byte[] expected = new byte[]{5, 0, 0, 3, 0, 0, 80};
        SocksCmdResponseTest.assertByteBufEquals(expected, buffer);
    }

    @Test
    public void testHostNotEncodedForUnknown() {
        String asciiHost = "xn--e1aybc.xn--p1ai";
        int port = 10000;
        SocksCmdResponse rs = new SocksCmdResponse(SocksCmdStatus.SUCCESS, SocksAddressType.UNKNOWN, asciiHost, port);
        Assert.assertEquals((Object)asciiHost, (Object)rs.host());
        ByteBuf buffer = Unpooled.buffer((int)16);
        rs.encodeAsByteBuf(buffer);
        buffer.resetReaderIndex();
        Assert.assertEquals((long)SocksProtocolVersion.SOCKS5.byteValue(), (long)buffer.readByte());
        Assert.assertEquals((long)SocksCmdStatus.SUCCESS.byteValue(), (long)buffer.readByte());
        Assert.assertEquals((long)0L, (long)buffer.readByte());
        Assert.assertEquals((long)SocksAddressType.UNKNOWN.byteValue(), (long)buffer.readByte());
        Assert.assertFalse((boolean)buffer.isReadable());
        buffer.release();
    }

    @Test
    public void testIDNEncodeToAsciiForDomain() {
        String host = "\u0442\u0435\u0441\u0442.\u0440\u0444";
        CharBuffer asciiHost = CharBuffer.wrap(IDN.toASCII(host));
        int port = 10000;
        SocksCmdResponse rs = new SocksCmdResponse(SocksCmdStatus.SUCCESS, SocksAddressType.DOMAIN, host, port);
        Assert.assertEquals((Object)host, (Object)rs.host());
        ByteBuf buffer = Unpooled.buffer((int)24);
        rs.encodeAsByteBuf(buffer);
        buffer.resetReaderIndex();
        Assert.assertEquals((long)SocksProtocolVersion.SOCKS5.byteValue(), (long)buffer.readByte());
        Assert.assertEquals((long)SocksCmdStatus.SUCCESS.byteValue(), (long)buffer.readByte());
        Assert.assertEquals((long)0L, (long)buffer.readByte());
        Assert.assertEquals((long)SocksAddressType.DOMAIN.byteValue(), (long)buffer.readByte());
        Assert.assertEquals((long)((byte)asciiHost.length()), (long)buffer.readUnsignedByte());
        Assert.assertEquals((Object)asciiHost, (Object)CharBuffer.wrap(buffer.readCharSequence(asciiHost.length(), CharsetUtil.US_ASCII)));
        Assert.assertEquals((long)port, (long)buffer.readUnsignedShort());
        buffer.release();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidBoundAddress() {
        new SocksCmdResponse(SocksCmdStatus.SUCCESS, SocksAddressType.IPv4, "127.0.0", 1000);
    }

    private static void assertByteBufEquals(byte[] expected, ByteBuf actual) {
        byte[] actualBytes = new byte[actual.readableBytes()];
        actual.readBytes(actualBytes);
        Assert.assertEquals((String)"Generated response has incorrect length", (long)expected.length, (long)actualBytes.length);
        Assert.assertArrayEquals((String)"Generated response differs from expected", (byte[])expected, (byte[])actualBytes);
    }

    @Test
    public void testValidPortRange() {
        try {
            new SocksCmdResponse(SocksCmdStatus.SUCCESS, SocksAddressType.IPv4, "127.0.0", 0);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
        try {
            new SocksCmdResponse(SocksCmdStatus.SUCCESS, SocksAddressType.IPv4, "127.0.0", 65536);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }
}

