/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socksx.v4;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.socksx.v4.DefaultSocks4CommandRequest;
import io.netty.handler.codec.socksx.v4.Socks4CommandRequest;
import io.netty.handler.codec.socksx.v4.Socks4CommandType;
import io.netty.handler.codec.socksx.v4.Socks4CommonTestUtils;
import io.netty.handler.codec.socksx.v4.Socks4Message;
import io.netty.handler.codec.socksx.v4.Socks4ServerDecoder;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class Socks4ServerDecoderTest {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Socks4ServerDecoderTest.class);

    private static void test(String userId, Socks4CommandType type, String dstAddr, int dstPort) {
        logger.debug("Testing type: " + type + " dstAddr: " + dstAddr + " dstPort: " + dstPort + " userId: " + userId);
        DefaultSocks4CommandRequest msg = new DefaultSocks4CommandRequest(type, dstAddr, dstPort, userId);
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new Socks4ServerDecoder()});
        Socks4CommonTestUtils.writeMessageIntoEmbedder(embedder, (Socks4Message)msg);
        msg = (Socks4CommandRequest)embedder.readInbound();
        Assert.assertSame((Object)msg.type(), (Object)type);
        Assert.assertEquals((Object)msg.dstAddr(), (Object)dstAddr);
        Assert.assertEquals((long)msg.dstPort(), (long)dstPort);
        Assert.assertEquals((Object)msg.userId(), (Object)userId);
        Assert.assertNull((Object)embedder.readInbound());
    }

    @Test
    public void testCmdRequestDecoder() {
        String[] hosts = new String[]{"127.0.0.1"};
        String[] userIds = new String[]{"test"};
        int[] ports = new int[]{1, 32769, 65535};
        for (Socks4CommandType cmdType : Arrays.asList(Socks4CommandType.BIND, Socks4CommandType.CONNECT)) {
            for (String userId : userIds) {
                for (String host : hosts) {
                    for (int port : ports) {
                        Socks4ServerDecoderTest.test(userId, cmdType, host, port);
                    }
                }
            }
        }
    }
}

