/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socksx.v5;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.socksx.v5.DefaultSocks5CommandResponse;
import io.netty.handler.codec.socksx.v5.Socks5AddressType;
import io.netty.handler.codec.socksx.v5.Socks5CommandStatus;
import io.netty.handler.codec.socksx.v5.Socks5CommonTestUtils;
import io.netty.handler.codec.socksx.v5.Socks5Message;
import org.junit.Assert;
import org.junit.Test;

public class DefaultSocks5CommandResponseTest {
    @Test
    public void testConstructorParamsAreNotNull() {
        try {
            new DefaultSocks5CommandResponse(null, Socks5AddressType.DOMAIN);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof NullPointerException));
        }
        try {
            new DefaultSocks5CommandResponse(Socks5CommandStatus.FAILURE, null);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof NullPointerException));
        }
    }

    @Test
    public void testEmptyDomain() {
        DefaultSocks5CommandResponse socks5CmdResponse = new DefaultSocks5CommandResponse(Socks5CommandStatus.SUCCESS, Socks5AddressType.DOMAIN);
        Assert.assertNull((Object)socks5CmdResponse.bndAddr());
        Assert.assertEquals((long)0L, (long)socks5CmdResponse.bndPort());
        ByteBuf buffer = Socks5CommonTestUtils.encodeServer((Socks5Message)socks5CmdResponse);
        byte[] expected = new byte[]{5, 0, 0, 3, 0, 0, 0};
        DefaultSocks5CommandResponseTest.assertByteBufEquals(expected, buffer);
        buffer.release();
    }

    @Test
    public void testIPv4Host() {
        DefaultSocks5CommandResponse socks5CmdResponse = new DefaultSocks5CommandResponse(Socks5CommandStatus.SUCCESS, Socks5AddressType.IPv4, "127.0.0.1", 80);
        Assert.assertEquals((Object)"127.0.0.1", (Object)socks5CmdResponse.bndAddr());
        Assert.assertEquals((long)80L, (long)socks5CmdResponse.bndPort());
        ByteBuf buffer = Socks5CommonTestUtils.encodeServer((Socks5Message)socks5CmdResponse);
        byte[] expected = new byte[]{5, 0, 0, 1, 127, 0, 0, 1, 0, 80};
        DefaultSocks5CommandResponseTest.assertByteBufEquals(expected, buffer);
        buffer.release();
    }

    @Test
    public void testEmptyBoundAddress() {
        DefaultSocks5CommandResponse socks5CmdResponse = new DefaultSocks5CommandResponse(Socks5CommandStatus.SUCCESS, Socks5AddressType.DOMAIN, "", 80);
        Assert.assertEquals((Object)"", (Object)socks5CmdResponse.bndAddr());
        Assert.assertEquals((long)80L, (long)socks5CmdResponse.bndPort());
        ByteBuf buffer = Socks5CommonTestUtils.encodeServer((Socks5Message)socks5CmdResponse);
        byte[] expected = new byte[]{5, 0, 0, 3, 0, 0, 80};
        DefaultSocks5CommandResponseTest.assertByteBufEquals(expected, buffer);
        buffer.release();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidBoundAddress() {
        new DefaultSocks5CommandResponse(Socks5CommandStatus.SUCCESS, Socks5AddressType.IPv4, "127.0.0", 1000);
    }

    private static void assertByteBufEquals(byte[] expected, ByteBuf actual) {
        byte[] actualBytes = new byte[actual.readableBytes()];
        actual.readBytes(actualBytes);
        Assert.assertEquals((String)"Generated response has incorrect length", (long)expected.length, (long)actualBytes.length);
        Assert.assertArrayEquals((String)"Generated response differs from expected", (byte[])expected, (byte[])actualBytes);
    }

    @Test
    public void testValidPortRange() {
        try {
            new DefaultSocks5CommandResponse(Socks5CommandStatus.SUCCESS, Socks5AddressType.IPv4, "127.0.0", 0);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
        try {
            new DefaultSocks5CommandResponse(Socks5CommandStatus.SUCCESS, Socks5AddressType.IPv4, "127.0.0", 65536);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
    }
}

