/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socksx.v5;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.socksx.v5.Socks5AuthRequest;
import io.netty.handler.codec.socksx.v5.Socks5Request;
import io.netty.handler.codec.socksx.v5.Socks5SubnegotiationVersion;
import io.netty.handler.codec.socksx.v5.UnknownSocks5Request;
import io.netty.util.CharsetUtil;
import java.util.List;

public class Socks5AuthRequestDecoder
extends ReplayingDecoder<State> {
    private Socks5SubnegotiationVersion version;
    private int fieldLength;
    private String username;
    private String password;
    private Socks5Request msg = UnknownSocks5Request.INSTANCE;

    public Socks5AuthRequestDecoder() {
        super((Object)State.CHECK_PROTOCOL_VERSION);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf byteBuf, List<Object> out) throws Exception {
        switch ((State)((Object)this.state())) {
            case CHECK_PROTOCOL_VERSION: {
                this.version = Socks5SubnegotiationVersion.valueOf(byteBuf.readByte());
                if (this.version != Socks5SubnegotiationVersion.AUTH_PASSWORD) break;
                this.checkpoint((Object)State.READ_USERNAME);
            }
            case READ_USERNAME: {
                this.fieldLength = byteBuf.readByte();
                this.username = byteBuf.readBytes(this.fieldLength).toString(CharsetUtil.US_ASCII);
                this.checkpoint((Object)State.READ_PASSWORD);
            }
            case READ_PASSWORD: {
                this.fieldLength = byteBuf.readByte();
                this.password = byteBuf.readBytes(this.fieldLength).toString(CharsetUtil.US_ASCII);
                this.msg = new Socks5AuthRequest(this.username, this.password);
            }
        }
        ctx.pipeline().remove((ChannelHandler)this);
        out.add(this.msg);
    }

    static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_USERNAME,
        READ_PASSWORD;

    }
}

