/*
 * Decompiled with CFR 0.152.
 */
package io.netty.codec.socks;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.codec.socks.SocksCmdResponse;
import io.netty.codec.socks.SocksCommonUtils;
import io.netty.codec.socks.SocksMessage;
import io.netty.codec.socks.SocksResponse;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.util.CharsetUtil;

public class SocksCmdResponseDecoder
extends ReplayingDecoder<SocksResponse, State> {
    private static final String name = "SOCKS_CMD_RESPONSE_DECODER";
    private SocksMessage.ProtocolVersion version;
    private int fieldLength;
    private SocksMessage.CmdStatus cmdStatus;
    private SocksMessage.AddressType addressType;
    private byte reserved;
    private String host;
    private int port;
    private SocksResponse msg = SocksCommonUtils.UNKNOWN_SOCKS_RESPONSE;

    public static String getName() {
        return name;
    }

    public SocksCmdResponseDecoder() {
        super((Object)State.CHECK_PROTOCOL_VERSION);
    }

    public SocksResponse decode(ChannelHandlerContext ctx, ByteBuf byteBuf) throws Exception {
        block0 : switch ((State)((Object)this.state())) {
            case CHECK_PROTOCOL_VERSION: {
                this.version = SocksMessage.ProtocolVersion.fromByte(byteBuf.readByte());
                if (this.version != SocksMessage.ProtocolVersion.SOCKS5) break;
                this.checkpoint((Object)State.READ_CMD_HEADER);
            }
            case READ_CMD_HEADER: {
                this.cmdStatus = SocksMessage.CmdStatus.fromByte(byteBuf.readByte());
                this.reserved = byteBuf.readByte();
                this.addressType = SocksMessage.AddressType.fromByte(byteBuf.readByte());
                this.checkpoint((Object)State.READ_CMD_ADDRESS);
            }
            case READ_CMD_ADDRESS: {
                switch (this.addressType) {
                    case IPv4: {
                        this.host = SocksCommonUtils.intToIp(byteBuf.readInt());
                        this.port = byteBuf.readUnsignedShort();
                        this.msg = new SocksCmdResponse(this.cmdStatus, this.addressType);
                        break block0;
                    }
                    case DOMAIN: {
                        this.fieldLength = byteBuf.readByte();
                        this.host = byteBuf.readBytes(this.fieldLength).toString(CharsetUtil.US_ASCII);
                        this.port = byteBuf.readUnsignedShort();
                        this.msg = new SocksCmdResponse(this.cmdStatus, this.addressType);
                        break block0;
                    }
                    case IPv6: {
                        this.host = SocksCommonUtils.ipv6toStr(byteBuf.readBytes(16).array());
                        this.port = byteBuf.readUnsignedShort();
                        this.msg = new SocksCmdResponse(this.cmdStatus, this.addressType);
                        break block0;
                    }
                }
            }
        }
        ctx.pipeline().remove((ChannelHandler)this);
        return this.msg;
    }

    public static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_CMD_HEADER,
        READ_CMD_ADDRESS;

    }
}

