/*
 * Decompiled with CFR 0.152.
 */
package io.netty.codec.socks;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.codec.socks.SocksAuthResponse;
import io.netty.codec.socks.SocksCommonUtils;
import io.netty.codec.socks.SocksMessage;
import io.netty.codec.socks.SocksResponse;
import io.netty.handler.codec.ReplayingDecoder;

public class SocksAuthResponseDecoder
extends ReplayingDecoder<SocksResponse, State> {
    private static final String name = "SOCKS_AUTH_RESPONSE_DECODER";
    private SocksMessage.SubnegotiationVersion version;
    private SocksMessage.AuthStatus authStatus;
    private SocksResponse msg = SocksCommonUtils.UNKNOWN_SOCKS_RESPONSE;

    public static String getName() {
        return name;
    }

    public SocksAuthResponseDecoder() {
        super((Object)State.CHECK_PROTOCOL_VERSION);
    }

    public SocksResponse decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) throws Exception {
        switch ((State)((Object)this.state())) {
            case CHECK_PROTOCOL_VERSION: {
                this.version = SocksMessage.SubnegotiationVersion.fromByte(byteBuf.readByte());
                if (this.version != SocksMessage.SubnegotiationVersion.AUTH_PASSWORD) break;
                this.checkpoint((Object)State.READ_AUTH_RESPONSE);
            }
            case READ_AUTH_RESPONSE: {
                this.authStatus = SocksMessage.AuthStatus.fromByte(byteBuf.readByte());
                this.msg = new SocksAuthResponse(this.authStatus);
            }
        }
        channelHandlerContext.pipeline().remove((ChannelHandler)this);
        return this.msg;
    }

    public static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_AUTH_RESPONSE;

    }
}

