/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.smtp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.smtp.SmtpResponse;
import io.netty.handler.codec.smtp.SmtpResponseDecoder;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class SmtpResponseDecoderTest {
    @Test
    public void testDecodeOneLineResponse() {
        EmbeddedChannel channel = SmtpResponseDecoderTest.newChannel();
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{SmtpResponseDecoderTest.newBuffer("200 Ok\r\n")}));
        Assert.assertTrue((boolean)channel.finish());
        SmtpResponse response = (SmtpResponse)channel.readInbound();
        Assert.assertEquals((long)200L, (long)response.code());
        List sequences = response.details();
        Assert.assertEquals((long)1L, (long)sequences.size());
        Assert.assertEquals((Object)"Ok", (Object)((CharSequence)sequences.get(0)).toString());
        Assert.assertNull((Object)channel.readInbound());
    }

    @Test
    public void testDecodeOneLineResponseNoDetails() {
        EmbeddedChannel channel = SmtpResponseDecoderTest.newChannel();
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{SmtpResponseDecoderTest.newBuffer("250 \r\n")}));
        Assert.assertTrue((boolean)channel.finish());
        SmtpResponse response = (SmtpResponse)channel.readInbound();
        Assert.assertEquals((long)250L, (long)response.code());
        List sequences = response.details();
        Assert.assertEquals((long)0L, (long)sequences.size());
    }

    @Test
    public void testDecodeOneLineResponseChunked() {
        EmbeddedChannel channel = SmtpResponseDecoderTest.newChannel();
        Assert.assertFalse((boolean)channel.writeInbound(new Object[]{SmtpResponseDecoderTest.newBuffer("200 Ok")}));
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{SmtpResponseDecoderTest.newBuffer("\r\n")}));
        Assert.assertTrue((boolean)channel.finish());
        SmtpResponse response = (SmtpResponse)channel.readInbound();
        Assert.assertEquals((long)200L, (long)response.code());
        List sequences = response.details();
        Assert.assertEquals((long)1L, (long)sequences.size());
        Assert.assertEquals((Object)"Ok", (Object)((CharSequence)sequences.get(0)).toString());
        Assert.assertNull((Object)channel.readInbound());
    }

    @Test
    public void testDecodeTwoLineResponse() {
        EmbeddedChannel channel = SmtpResponseDecoderTest.newChannel();
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{SmtpResponseDecoderTest.newBuffer("200-Hello\r\n200 Ok\r\n")}));
        Assert.assertTrue((boolean)channel.finish());
        SmtpResponse response = (SmtpResponse)channel.readInbound();
        Assert.assertEquals((long)200L, (long)response.code());
        List sequences = response.details();
        Assert.assertEquals((long)2L, (long)sequences.size());
        Assert.assertEquals((Object)"Hello", (Object)((CharSequence)sequences.get(0)).toString());
        Assert.assertEquals((Object)"Ok", (Object)((CharSequence)sequences.get(1)).toString());
        Assert.assertNull((Object)channel.readInbound());
    }

    @Test
    public void testDecodeTwoLineResponseChunked() {
        EmbeddedChannel channel = SmtpResponseDecoderTest.newChannel();
        Assert.assertFalse((boolean)channel.writeInbound(new Object[]{SmtpResponseDecoderTest.newBuffer("200-")}));
        Assert.assertFalse((boolean)channel.writeInbound(new Object[]{SmtpResponseDecoderTest.newBuffer("Hello\r\n2")}));
        Assert.assertFalse((boolean)channel.writeInbound(new Object[]{SmtpResponseDecoderTest.newBuffer("00 Ok")}));
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{SmtpResponseDecoderTest.newBuffer("\r\n")}));
        Assert.assertTrue((boolean)channel.finish());
        SmtpResponse response = (SmtpResponse)channel.readInbound();
        Assert.assertEquals((long)200L, (long)response.code());
        List sequences = response.details();
        Assert.assertEquals((long)2L, (long)sequences.size());
        Assert.assertEquals((Object)"Hello", (Object)((CharSequence)sequences.get(0)).toString());
        Assert.assertEquals((Object)"Ok", (Object)((CharSequence)sequences.get(1)).toString());
        Assert.assertNull((Object)channel.readInbound());
    }

    @Test(expected=DecoderException.class)
    public void testDecodeInvalidSeparator() {
        EmbeddedChannel channel = SmtpResponseDecoderTest.newChannel();
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{SmtpResponseDecoderTest.newBuffer("200:Ok\r\n")}));
    }

    @Test(expected=DecoderException.class)
    public void testDecodeInvalidCode() {
        EmbeddedChannel channel = SmtpResponseDecoderTest.newChannel();
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{SmtpResponseDecoderTest.newBuffer("xyz Ok\r\n")}));
    }

    @Test(expected=DecoderException.class)
    public void testDecodeInvalidLine() {
        EmbeddedChannel channel = SmtpResponseDecoderTest.newChannel();
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{SmtpResponseDecoderTest.newBuffer("Ok\r\n")}));
    }

    private static EmbeddedChannel newChannel() {
        return new EmbeddedChannel(new ChannelHandler[]{new SmtpResponseDecoder(Integer.MAX_VALUE)});
    }

    private static ByteBuf newBuffer(CharSequence seq) {
        return Unpooled.copiedBuffer((CharSequence)seq, (Charset)CharsetUtil.US_ASCII);
    }
}

