/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.redis;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.redis.ArrayRedisMessage;
import io.netty.handler.codec.redis.ErrorRedisMessage;
import io.netty.handler.codec.redis.FullBulkStringRedisMessage;
import io.netty.handler.codec.redis.InlineCommandRedisMessage;
import io.netty.handler.codec.redis.IntegerRedisMessage;
import io.netty.handler.codec.redis.RedisArrayAggregator;
import io.netty.handler.codec.redis.RedisBulkStringAggregator;
import io.netty.handler.codec.redis.RedisCodecTestUtil;
import io.netty.handler.codec.redis.RedisDecoder;
import io.netty.handler.codec.redis.RedisMessage;
import io.netty.handler.codec.redis.SimpleStringRedisMessage;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ReferenceCountUtil;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RedisDecoderTest {
    private EmbeddedChannel channel;

    @Before
    public void setup() throws Exception {
        this.channel = RedisDecoderTest.newChannel(false);
    }

    private static EmbeddedChannel newChannel(boolean decodeInlineCommands) {
        return new EmbeddedChannel(new ChannelHandler[]{new RedisDecoder(decodeInlineCommands), new RedisBulkStringAggregator(), new RedisArrayAggregator()});
    }

    @After
    public void teardown() throws Exception {
        Assert.assertFalse((boolean)this.channel.finish());
    }

    @Test
    public void splitEOLDoesNotInfiniteLoop() throws Exception {
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("$6\r\nfoobar\r")}));
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\n")}));
        RedisMessage msg = (RedisMessage)this.channel.readInbound();
        Assert.assertTrue((boolean)(msg instanceof FullBulkStringRedisMessage));
        ReferenceCountUtil.release((Object)msg);
    }

    @Test(expected=DecoderException.class)
    public void shouldNotDecodeInlineCommandByDefault() {
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("P")}));
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("I")}));
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("N")}));
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("G")}));
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\r\n")}));
        this.channel.readInbound();
    }

    @Test
    public void shouldDecodeInlineCommand() {
        this.channel = RedisDecoderTest.newChannel(true);
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("P")}));
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("I")}));
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("N")}));
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("G")}));
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\r\n")}));
        InlineCommandRedisMessage msg = (InlineCommandRedisMessage)this.channel.readInbound();
        Assert.assertThat((Object)msg.content(), (Matcher)CoreMatchers.is((Object)"PING"));
        ReferenceCountUtil.release((Object)msg);
    }

    @Test
    public void shouldDecodeSimpleString() {
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("+")}));
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("O")}));
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("K")}));
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\r\n")}));
        SimpleStringRedisMessage msg = (SimpleStringRedisMessage)this.channel.readInbound();
        Assert.assertThat((Object)msg.content(), (Matcher)CoreMatchers.is((Object)"OK"));
        ReferenceCountUtil.release((Object)msg);
    }

    @Test
    public void shouldDecodeTwoSimpleStrings() {
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("+")}));
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("O")}));
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("K")}));
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\r\n+SEC")}));
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("OND\r\n")}));
        SimpleStringRedisMessage msg1 = (SimpleStringRedisMessage)this.channel.readInbound();
        Assert.assertThat((Object)msg1.content(), (Matcher)CoreMatchers.is((Object)"OK"));
        ReferenceCountUtil.release((Object)msg1);
        SimpleStringRedisMessage msg2 = (SimpleStringRedisMessage)this.channel.readInbound();
        Assert.assertThat((Object)msg2.content(), (Matcher)CoreMatchers.is((Object)"SECOND"));
        ReferenceCountUtil.release((Object)msg2);
    }

    @Test
    public void shouldDecodeError() {
        String content = "ERROR sample message";
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("-")}));
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf(content)}));
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\r")}));
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\n")}));
        ErrorRedisMessage msg = (ErrorRedisMessage)this.channel.readInbound();
        Assert.assertThat((Object)msg.content(), (Matcher)CoreMatchers.is((Object)content));
        ReferenceCountUtil.release((Object)msg);
    }

    @Test
    public void shouldDecodeInteger() {
        long value = 1234L;
        byte[] content = RedisCodecTestUtil.bytesOf(value);
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf(":")}));
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf(content)}));
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\r\n")}));
        IntegerRedisMessage msg = (IntegerRedisMessage)this.channel.readInbound();
        Assert.assertThat((Object)msg.value(), (Matcher)CoreMatchers.is((Object)value));
        ReferenceCountUtil.release((Object)msg);
    }

    @Test
    public void shouldDecodeBulkString() {
        String buf1 = "bulk\nst";
        String buf2 = "ring\ntest\n1234";
        byte[] content = RedisCodecTestUtil.bytesOf(buf1 + buf2);
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("$")}));
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf(Integer.toString(content.length))}));
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\r\n")}));
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf(buf1)}));
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf(buf2)}));
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\r\n")}));
        FullBulkStringRedisMessage msg = (FullBulkStringRedisMessage)this.channel.readInbound();
        Assert.assertThat((Object)RedisCodecTestUtil.bytesOf(msg.content()), (Matcher)CoreMatchers.is((Object)content));
        ReferenceCountUtil.release((Object)msg);
    }

    @Test
    public void shouldDecodeEmptyBulkString() {
        byte[] content = RedisCodecTestUtil.bytesOf("");
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("$")}));
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf(Integer.toString(content.length))}));
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\r\n")}));
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf(content)}));
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\r\n")}));
        FullBulkStringRedisMessage msg = (FullBulkStringRedisMessage)this.channel.readInbound();
        Assert.assertThat((Object)RedisCodecTestUtil.bytesOf(msg.content()), (Matcher)CoreMatchers.is((Object)content));
        ReferenceCountUtil.release((Object)msg);
    }

    @Test
    public void shouldDecodeNullBulkString() {
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("$")}));
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf(Integer.toString(-1))}));
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\r\n")}));
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("$")}));
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf(Integer.toString(-1))}));
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\r\n")}));
        FullBulkStringRedisMessage msg1 = (FullBulkStringRedisMessage)this.channel.readInbound();
        Assert.assertThat((Object)msg1.isNull(), (Matcher)CoreMatchers.is((Object)true));
        ReferenceCountUtil.release((Object)msg1);
        FullBulkStringRedisMessage msg2 = (FullBulkStringRedisMessage)this.channel.readInbound();
        Assert.assertThat((Object)msg2.isNull(), (Matcher)CoreMatchers.is((Object)true));
        ReferenceCountUtil.release((Object)msg2);
        FullBulkStringRedisMessage msg3 = (FullBulkStringRedisMessage)this.channel.readInbound();
        Assert.assertThat((Object)msg3, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldDecodeSimpleArray() throws Exception {
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("*3\r\n")}));
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf(":1234\r\n")}));
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("+sim")}));
        Assert.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("ple\r\n-err")}));
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("or\r\n")}));
        ArrayRedisMessage msg = (ArrayRedisMessage)this.channel.readInbound();
        List children = msg.children();
        Assert.assertThat((Object)msg.children().size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)3)));
        Assert.assertThat(children.get(0), (Matcher)CoreMatchers.instanceOf(IntegerRedisMessage.class));
        Assert.assertThat((Object)((IntegerRedisMessage)children.get(0)).value(), (Matcher)CoreMatchers.is((Object)1234L));
        Assert.assertThat(children.get(1), (Matcher)CoreMatchers.instanceOf(SimpleStringRedisMessage.class));
        Assert.assertThat((Object)((SimpleStringRedisMessage)children.get(1)).content(), (Matcher)CoreMatchers.is((Object)"simple"));
        Assert.assertThat(children.get(2), (Matcher)CoreMatchers.instanceOf(ErrorRedisMessage.class));
        Assert.assertThat((Object)((ErrorRedisMessage)children.get(2)).content(), (Matcher)CoreMatchers.is((Object)"error"));
        ReferenceCountUtil.release((Object)msg);
    }

    @Test
    public void shouldDecodeNestedArray() throws Exception {
        ByteBuf buf = Unpooled.buffer();
        buf.writeBytes(RedisCodecTestUtil.byteBufOf("*2\r\n"));
        buf.writeBytes(RedisCodecTestUtil.byteBufOf("*3\r\n:1\r\n:2\r\n:3\r\n"));
        buf.writeBytes(RedisCodecTestUtil.byteBufOf("*2\r\n+Foo\r\n-Bar\r\n"));
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{buf}));
        ArrayRedisMessage msg = (ArrayRedisMessage)this.channel.readInbound();
        List children = msg.children();
        Assert.assertThat((Object)msg.children().size(), (Matcher)CoreMatchers.is((Object)2));
        ArrayRedisMessage intArray = (ArrayRedisMessage)children.get(0);
        ArrayRedisMessage strArray = (ArrayRedisMessage)children.get(1);
        Assert.assertThat((Object)intArray.children().size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)((IntegerRedisMessage)intArray.children().get(0)).value(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((IntegerRedisMessage)intArray.children().get(1)).value(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)((IntegerRedisMessage)intArray.children().get(2)).value(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)strArray.children().size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((SimpleStringRedisMessage)strArray.children().get(0)).content(), (Matcher)CoreMatchers.is((Object)"Foo"));
        Assert.assertThat((Object)((ErrorRedisMessage)strArray.children().get(1)).content(), (Matcher)CoreMatchers.is((Object)"Bar"));
        ReferenceCountUtil.release((Object)msg);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void shouldErrorOnDoubleReleaseArrayReferenceCounted() throws Exception {
        ByteBuf buf = Unpooled.buffer();
        buf.writeBytes(RedisCodecTestUtil.byteBufOf("*2\r\n"));
        buf.writeBytes(RedisCodecTestUtil.byteBufOf("*3\r\n:1\r\n:2\r\n:3\r\n"));
        buf.writeBytes(RedisCodecTestUtil.byteBufOf("*2\r\n+Foo\r\n-Bar\r\n"));
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{buf}));
        ArrayRedisMessage msg = (ArrayRedisMessage)this.channel.readInbound();
        ReferenceCountUtil.release((Object)msg);
        ReferenceCountUtil.release((Object)msg);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void shouldErrorOnReleaseArrayChildReferenceCounted() throws Exception {
        ByteBuf buf = Unpooled.buffer();
        buf.writeBytes(RedisCodecTestUtil.byteBufOf("*2\r\n"));
        buf.writeBytes(RedisCodecTestUtil.byteBufOf("*3\r\n:1\r\n:2\r\n:3\r\n"));
        buf.writeBytes(RedisCodecTestUtil.byteBufOf("$3\r\nFoo\r\n"));
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{buf}));
        ArrayRedisMessage msg = (ArrayRedisMessage)this.channel.readInbound();
        List children = msg.children();
        ReferenceCountUtil.release((Object)msg);
        ReferenceCountUtil.release(children.get(1));
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void shouldErrorOnReleasecontentOfArrayChildReferenceCounted() throws Exception {
        ByteBuf buf = Unpooled.buffer();
        buf.writeBytes(RedisCodecTestUtil.byteBufOf("*2\r\n"));
        buf.writeBytes(RedisCodecTestUtil.byteBufOf("$3\r\nFoo\r\n$3\r\nBar\r\n"));
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{buf}));
        ArrayRedisMessage msg = (ArrayRedisMessage)this.channel.readInbound();
        List children = msg.children();
        ByteBuf childBuf = ((FullBulkStringRedisMessage)children.get(0)).content();
        ReferenceCountUtil.release((Object)msg);
        ReferenceCountUtil.release((Object)childBuf);
    }

    @Test
    public void testPredefinedMessagesNotEqual() {
        Assert.assertNotEquals((Object)FullBulkStringRedisMessage.EMPTY_INSTANCE, (Object)FullBulkStringRedisMessage.NULL_INSTANCE);
        Assert.assertNotEquals((Object)FullBulkStringRedisMessage.NULL_INSTANCE, (Object)FullBulkStringRedisMessage.EMPTY_INSTANCE);
    }
}

