/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.redis;

import io.netty.handler.codec.redis.RedisMessage;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.util.Collections;
import java.util.List;

public class ArrayRedisMessage
extends AbstractReferenceCounted
implements RedisMessage {
    private final List<RedisMessage> children;
    public static final ArrayRedisMessage NULL_INSTANCE = new ArrayRedisMessage(){

        @Override
        public boolean isNull() {
            return true;
        }

        public ArrayRedisMessage retain() {
            return this;
        }

        public ArrayRedisMessage retain(int increment) {
            return this;
        }

        public ArrayRedisMessage touch() {
            return this;
        }

        @Override
        public ArrayRedisMessage touch(Object hint) {
            return this;
        }

        public boolean release() {
            return false;
        }

        public boolean release(int decrement) {
            return false;
        }

        @Override
        public String toString() {
            return "NullArrayRedisMessage";
        }
    };
    public static final ArrayRedisMessage EMPTY_INSTANCE = new ArrayRedisMessage(){

        @Override
        public boolean isNull() {
            return false;
        }

        public ArrayRedisMessage retain() {
            return this;
        }

        public ArrayRedisMessage retain(int increment) {
            return this;
        }

        public ArrayRedisMessage touch() {
            return this;
        }

        @Override
        public ArrayRedisMessage touch(Object hint) {
            return this;
        }

        public boolean release() {
            return false;
        }

        public boolean release(int decrement) {
            return false;
        }

        @Override
        public String toString() {
            return "EmptyArrayRedisMessage";
        }
    };

    private ArrayRedisMessage() {
        this.children = Collections.emptyList();
    }

    public ArrayRedisMessage(List<RedisMessage> children) {
        this.children = (List)ObjectUtil.checkNotNull(children, (String)"children");
    }

    public final List<RedisMessage> children() {
        return this.children;
    }

    public boolean isNull() {
        return false;
    }

    protected void deallocate() {
        for (RedisMessage msg : this.children) {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public ArrayRedisMessage touch(Object hint) {
        for (RedisMessage msg : this.children) {
            ReferenceCountUtil.touch((Object)msg);
        }
        return this;
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)this) + '[' + "children=" + this.children.size() + ']';
    }
}

