/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.mqtt;

import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageBuilders;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttUnsubAckMessage;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MqttMessageBuildersPacketIdTest {
    @Parameterized.Parameter
    public Integer id;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Integer> data() {
        return Arrays.asList(1, 15, 255, 4095, 65535);
    }

    @Test
    public void testUnsubAckMessageIdAsShort() {
        MqttUnsubAckMessage msg = MqttMessageBuilders.unsubAck().packetId(this.id.shortValue()).build();
        Assert.assertEquals((long)this.id.intValue(), (long)msg.variableHeader().messageId());
    }

    @Test
    public void testSubAckMessageIdAsShort() {
        MqttSubAckMessage msg = MqttMessageBuilders.subAck().packetId(this.id.shortValue()).build();
        Assert.assertEquals((long)this.id.intValue(), (long)msg.variableHeader().messageId());
    }

    @Test
    public void testPubAckMessageIdAsShort() {
        MqttMessage msg = MqttMessageBuilders.pubAck().packetId(this.id.shortValue()).build();
        Assert.assertEquals((long)this.id.intValue(), (long)((MqttMessageIdVariableHeader)msg.variableHeader()).messageId());
    }

    @Test
    public void testUnsubAckMessageIdAsInt() {
        MqttUnsubAckMessage msg = MqttMessageBuilders.unsubAck().packetId(this.id.intValue()).build();
        Assert.assertEquals((long)this.id.intValue(), (long)msg.variableHeader().messageId());
    }

    @Test
    public void testSubAckMessageIdAsInt() {
        MqttSubAckMessage msg = MqttMessageBuilders.subAck().packetId(this.id.intValue()).build();
        Assert.assertEquals((long)this.id.intValue(), (long)msg.variableHeader().messageId());
    }

    @Test
    public void testPubAckMessageIdAsInt() {
        MqttMessage msg = MqttMessageBuilders.pubAck().packetId(this.id.intValue()).build();
        Assert.assertEquals((long)this.id.intValue(), (long)((MqttMessageIdVariableHeader)msg.variableHeader()).messageId());
    }
}

