/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.mqtt;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.mqtt.MqttCodecUtil;
import io.netty.handler.codec.mqtt.MqttConnAckMessage;
import io.netty.handler.codec.mqtt.MqttConnAckVariableHeader;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectPayload;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttConnectVariableHeader;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageBuilders;
import io.netty.handler.codec.mqtt.MqttMessageIdAndPropertiesVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttPubReplyMessageVariableHeader;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttReasonCodeAndPropertiesVariableHeader;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubAckPayload;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttSubscribePayload;
import io.netty.handler.codec.mqtt.MqttSubscriptionOption;
import io.netty.handler.codec.mqtt.MqttTestUtils;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import io.netty.handler.codec.mqtt.MqttUnsubAckMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribePayload;
import io.netty.handler.codec.mqtt.MqttVersion;
import io.netty.util.Attribute;
import io.netty.util.CharsetUtil;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class MqttCodecTest {
    private static final String CLIENT_ID = "RANDOM_TEST_CLIENT";
    private static final String WILL_TOPIC = "/my_will";
    private static final String WILL_MESSAGE = "gone";
    private static final String USER_NAME = "happy_user";
    private static final String PASSWORD = "123_or_no_pwd";
    private static final int KEEP_ALIVE_SECONDS = 600;
    private static final ByteBufAllocator ALLOCATOR = new UnpooledByteBufAllocator(false);
    private static final int DEFAULT_MAX_BYTES_IN_MESSAGE = 8092;
    @Mock
    private final ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
    @Mock
    private final Channel channel = (Channel)Mockito.mock(Channel.class);
    @Mock
    private final Attribute<MqttVersion> versionAttrMock = (Attribute)Mockito.mock(Attribute.class);
    private final MqttDecoder mqttDecoder = new MqttDecoder();
    private final MqttDecoder mqttDecoderLimitedMessageSize = new MqttDecoder(1);

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.ctx.channel()).thenReturn((Object)this.channel);
        Mockito.when((Object)this.ctx.alloc()).thenReturn((Object)ALLOCATOR);
        Mockito.when((Object)this.channel.attr(MqttCodecUtil.MQTT_VERSION_KEY)).thenReturn(this.versionAttrMock);
    }

    @Test
    public void testConnectMessageForMqtt31() throws Exception {
        MqttConnectMessage message = MqttCodecTest.createConnectMessage(MqttVersion.MQTT_3_1);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttConnectMessage decodedMessage = (MqttConnectMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateConnectVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
        MqttCodecTest.validateConnectPayload(message.payload(), decodedMessage.payload());
    }

    @Test
    public void testConnectMessageForMqtt311() throws Exception {
        MqttConnectMessage message = MqttCodecTest.createConnectMessage(MqttVersion.MQTT_3_1_1);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttConnectMessage decodedMessage = (MqttConnectMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateConnectVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
        MqttCodecTest.validateConnectPayload(message.payload(), decodedMessage.payload());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectMessageWithNonZeroReservedFlagForMqtt311() throws Exception {
        MqttConnectMessage message = MqttCodecTest.createConnectMessage(MqttVersion.MQTT_3_1_1);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        try {
            byteBuf.setByte(9, byteBuf.getByte(9) | 1);
            LinkedList out = new LinkedList();
            this.mqttDecoder.decode(this.ctx, byteBuf, out);
            Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
            MqttMessage decodedMessage = (MqttMessage)out.get(0);
            Assert.assertTrue((boolean)decodedMessage.decoderResult().isFailure());
            Throwable cause = decodedMessage.decoderResult().cause();
            Assert.assertTrue((boolean)(cause instanceof DecoderException));
            Assert.assertEquals((Object)"non-zero reserved flag", (Object)cause.getMessage());
        }
        finally {
            byteBuf.release();
        }
    }

    @Test
    public void testConnectMessageNoPassword() throws Exception {
        MqttConnectMessage message = MqttCodecTest.createConnectMessage(MqttVersion.MQTT_3_1_1, null, PASSWORD, MqttProperties.NO_PROPERTIES, MqttProperties.NO_PROPERTIES);
        try {
            ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        }
        catch (Exception cause) {
            Assert.assertTrue((boolean)(cause instanceof EncoderException));
        }
    }

    @Test
    public void testConnAckMessage() throws Exception {
        MqttConnAckMessage message = MqttCodecTest.createConnAckMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttConnAckMessage decodedMessage = (MqttConnAckMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateConnAckVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
    }

    @Test
    public void testPublishMessage() throws Exception {
        MqttPublishMessage message = MqttCodecTest.createPublishMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttPublishMessage decodedMessage = (MqttPublishMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validatePublishVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
        MqttCodecTest.validatePublishPayload(message.payload(), decodedMessage.payload());
    }

    @Test
    public void testPubAckMessage() throws Exception {
        this.testMessageWithOnlyFixedHeaderAndMessageIdVariableHeader(MqttMessageType.PUBACK);
    }

    @Test
    public void testPubRecMessage() throws Exception {
        this.testMessageWithOnlyFixedHeaderAndMessageIdVariableHeader(MqttMessageType.PUBREC);
    }

    @Test
    public void testPubRelMessage() throws Exception {
        this.testMessageWithOnlyFixedHeaderAndMessageIdVariableHeader(MqttMessageType.PUBREL);
    }

    @Test
    public void testPubCompMessage() throws Exception {
        this.testMessageWithOnlyFixedHeaderAndMessageIdVariableHeader(MqttMessageType.PUBCOMP);
    }

    @Test
    public void testSubscribeMessage() throws Exception {
        MqttSubscribeMessage message = MqttCodecTest.createSubscribeMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttSubscribeMessage decodedMessage = (MqttSubscribeMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateMessageIdVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
        MqttTestUtils.validateSubscribePayload(message.payload(), decodedMessage.payload());
    }

    @Test
    public void testSubAckMessage() throws Exception {
        MqttSubAckMessage message = MqttCodecTest.createSubAckMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttSubAckMessage decodedMessage = (MqttSubAckMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateMessageIdVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
        MqttCodecTest.validateSubAckPayload(message.payload(), decodedMessage.payload());
    }

    @Test
    public void testSubAckMessageWithFailureInPayload() throws Exception {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.SUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader mqttMessageIdVariableHeader = MqttMessageIdVariableHeader.from((int)12345);
        MqttSubAckPayload mqttSubAckPayload = new MqttSubAckPayload(new int[]{MqttQoS.FAILURE.value()});
        MqttSubAckMessage message = new MqttSubAckMessage(mqttFixedHeader, mqttMessageIdVariableHeader, mqttSubAckPayload);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttSubAckMessage decodedMessage = (MqttSubAckMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateMessageIdVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
        MqttCodecTest.validateSubAckPayload(message.payload(), decodedMessage.payload());
        Assert.assertEquals((long)1L, (long)decodedMessage.payload().grantedQoSLevels().size());
        Assert.assertEquals((Object)MqttQoS.FAILURE, (Object)MqttQoS.valueOf((int)((Integer)decodedMessage.payload().grantedQoSLevels().get(0))));
    }

    @Test
    public void testUnSubscribeMessage() throws Exception {
        MqttUnsubscribeMessage message = MqttCodecTest.createUnsubscribeMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttUnsubscribeMessage decodedMessage = (MqttUnsubscribeMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateMessageIdVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
        MqttTestUtils.validateUnsubscribePayload(message.payload(), decodedMessage.payload());
    }

    @Test
    public void testUnsubAckMessage() throws Exception {
        this.testMessageWithOnlyFixedHeaderAndMessageIdVariableHeader(MqttMessageType.UNSUBACK);
    }

    @Test
    public void testPingReqMessage() throws Exception {
        this.testMessageWithOnlyFixedHeader(MqttMessage.PINGREQ);
    }

    @Test
    public void testPingRespMessage() throws Exception {
        this.testMessageWithOnlyFixedHeader(MqttMessage.PINGRESP);
    }

    @Test
    public void testDisconnectMessage() throws Exception {
        this.testMessageWithOnlyFixedHeader(MqttMessage.DISCONNECT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnknownMessageType() throws Exception {
        MqttMessage message = MqttCodecTest.createMessageWithFixedHeader(MqttMessageType.PINGREQ);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        try {
            byteBuf.setByte(0, 240);
            LinkedList out = new LinkedList();
            this.mqttDecoder.decode(this.ctx, byteBuf, out);
            Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
            MqttMessage decodedMessage = (MqttMessage)out.get(0);
            Assert.assertTrue((boolean)decodedMessage.decoderResult().isFailure());
            Throwable cause = decodedMessage.decoderResult().cause();
            Assert.assertTrue((boolean)(cause instanceof DecoderException));
            Assert.assertEquals((Object)"AUTH message requires at least MQTT 5", (Object)cause.getMessage());
        }
        finally {
            byteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectMessageForMqtt31TooLarge() throws Exception {
        MqttConnectMessage message = MqttCodecTest.createConnectMessage(MqttVersion.MQTT_3_1);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        try {
            LinkedList out = new LinkedList();
            this.mqttDecoderLimitedMessageSize.decode(this.ctx, byteBuf, out);
            Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
            MqttMessage decodedMessage = (MqttMessage)out.get(0);
            MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
            MqttCodecTest.validateConnectVariableHeader(message.variableHeader(), (MqttConnectVariableHeader)decodedMessage.variableHeader());
            MqttCodecTest.validateDecoderExceptionTooLargeMessage(decodedMessage);
        }
        finally {
            byteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectMessageForMqtt311TooLarge() throws Exception {
        MqttConnectMessage message = MqttCodecTest.createConnectMessage(MqttVersion.MQTT_3_1_1);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        try {
            LinkedList out = new LinkedList();
            this.mqttDecoderLimitedMessageSize.decode(this.ctx, byteBuf, out);
            Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
            MqttMessage decodedMessage = (MqttMessage)out.get(0);
            MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
            MqttCodecTest.validateConnectVariableHeader(message.variableHeader(), (MqttConnectVariableHeader)decodedMessage.variableHeader());
            MqttCodecTest.validateDecoderExceptionTooLargeMessage(decodedMessage);
        }
        finally {
            byteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnAckMessageTooLarge() throws Exception {
        MqttConnAckMessage message = MqttCodecTest.createConnAckMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        try {
            LinkedList out = new LinkedList();
            this.mqttDecoderLimitedMessageSize.decode(this.ctx, byteBuf, out);
            Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
            MqttMessage decodedMessage = (MqttMessage)out.get(0);
            MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
            MqttCodecTest.validateDecoderExceptionTooLargeMessage(decodedMessage);
        }
        finally {
            byteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPublishMessageTooLarge() throws Exception {
        MqttPublishMessage message = MqttCodecTest.createPublishMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        try {
            LinkedList out = new LinkedList();
            this.mqttDecoderLimitedMessageSize.decode(this.ctx, byteBuf, out);
            Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
            MqttMessage decodedMessage = (MqttMessage)out.get(0);
            MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
            MqttCodecTest.validatePublishVariableHeader(message.variableHeader(), (MqttPublishVariableHeader)decodedMessage.variableHeader());
            MqttCodecTest.validateDecoderExceptionTooLargeMessage(decodedMessage);
        }
        finally {
            byteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubscribeMessageTooLarge() throws Exception {
        MqttSubscribeMessage message = MqttCodecTest.createSubscribeMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        try {
            LinkedList out = new LinkedList();
            this.mqttDecoderLimitedMessageSize.decode(this.ctx, byteBuf, out);
            Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
            MqttMessage decodedMessage = (MqttMessage)out.get(0);
            MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
            MqttCodecTest.validateMessageIdVariableHeader(message.variableHeader(), (MqttMessageIdVariableHeader)decodedMessage.variableHeader());
            MqttCodecTest.validateDecoderExceptionTooLargeMessage(decodedMessage);
        }
        finally {
            byteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubAckMessageTooLarge() throws Exception {
        MqttSubAckMessage message = MqttCodecTest.createSubAckMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        try {
            LinkedList out = new LinkedList();
            this.mqttDecoderLimitedMessageSize.decode(this.ctx, byteBuf, out);
            Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
            MqttMessage decodedMessage = (MqttMessage)out.get(0);
            MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
            MqttCodecTest.validateMessageIdVariableHeader(message.variableHeader(), (MqttMessageIdVariableHeader)decodedMessage.variableHeader());
            MqttCodecTest.validateDecoderExceptionTooLargeMessage(decodedMessage);
        }
        finally {
            byteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnSubscribeMessageTooLarge() throws Exception {
        MqttUnsubscribeMessage message = MqttCodecTest.createUnsubscribeMessage();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        try {
            LinkedList out = new LinkedList();
            this.mqttDecoderLimitedMessageSize.decode(this.ctx, byteBuf, out);
            Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
            MqttMessage decodedMessage = (MqttMessage)out.get(0);
            MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
            MqttCodecTest.validateMessageIdVariableHeader(message.variableHeader(), (MqttMessageIdVariableHeader)decodedMessage.variableHeader());
            MqttCodecTest.validateDecoderExceptionTooLargeMessage(decodedMessage);
        }
        finally {
            byteBuf.release();
        }
    }

    @Test
    public void testConnectMessageForMqtt5() throws Exception {
        MqttProperties props = new MqttProperties();
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SESSION_EXPIRY_INTERVAL.value(), Integer.valueOf(10)));
        props.add((MqttProperties.MqttProperty)new MqttProperties.StringProperty(MqttProperties.MqttPropertyType.AUTHENTICATION_METHOD.value(), "Plain"));
        MqttProperties willProps = new MqttProperties();
        willProps.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.WILL_DELAY_INTERVAL.value(), Integer.valueOf(100)));
        MqttConnectMessage message = MqttCodecTest.createConnectMessage(MqttVersion.MQTT_5, USER_NAME, PASSWORD, props, willProps);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttConnectMessage decodedMessage = (MqttConnectMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateConnectVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
        MqttCodecTest.validateConnectPayload(message.payload(), decodedMessage.payload());
    }

    @Test
    public void testConnAckMessageForMqtt5() throws Exception {
        MqttProperties props = new MqttProperties();
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SESSION_EXPIRY_INTERVAL.value(), Integer.valueOf(10)));
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.MAXIMUM_QOS.value(), Integer.valueOf(1)));
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.MAXIMUM_PACKET_SIZE.value(), Integer.valueOf(1000)));
        MqttConnAckMessage message = MqttCodecTest.createConnAckMessage(props);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttConnAckMessage decodedMessage = (MqttConnAckMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateConnAckVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
    }

    @Test
    public void testPublishMessageForMqtt5() throws Exception {
        Mockito.when((Object)this.versionAttrMock.get()).thenReturn((Object)MqttVersion.MQTT_5);
        MqttProperties props = new MqttProperties();
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value(), Integer.valueOf(10)));
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value(), Integer.valueOf(20)));
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.PAYLOAD_FORMAT_INDICATOR.value(), Integer.valueOf(6)));
        props.add((MqttProperties.MqttProperty)new MqttProperties.UserProperty("isSecret", "true"));
        props.add((MqttProperties.MqttProperty)new MqttProperties.UserProperty("tag", "firstTag"));
        props.add((MqttProperties.MqttProperty)new MqttProperties.UserProperty("tag", "secondTag"));
        Assert.assertEquals((String)"Subscription IDs count mismatch", (long)2L, (long)props.getProperties(MqttProperties.MqttPropertyType.SUBSCRIPTION_IDENTIFIER.value()).size());
        Assert.assertEquals((String)"User properties count mismatch", (long)3L, (long)props.getProperties(MqttProperties.MqttPropertyType.USER_PROPERTY.value()).size());
        Assert.assertEquals((String)"UserProperties count mismatch", (long)3L, (long)((List)((MqttProperties.UserProperties)props.getProperty((int)MqttProperties.MqttPropertyType.USER_PROPERTY.value())).value).size());
        MqttPublishMessage message = MqttCodecTest.createPublishMessage(props);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttPublishMessage decodedMessage = (MqttPublishMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validatePublishVariableHeader(message.variableHeader(), decodedMessage.variableHeader());
        MqttCodecTest.validatePublishPayload(message.payload(), decodedMessage.payload());
    }

    @Test
    public void testPubAckMessageForMqtt5() throws Exception {
        Mockito.when((Object)this.versionAttrMock.get()).thenReturn((Object)MqttVersion.MQTT_5);
        MqttProperties props = new MqttProperties();
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.PAYLOAD_FORMAT_INDICATOR.value(), Integer.valueOf(6)));
        MqttMessage message = this.createPubAckMessage((byte)-121, props);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttMessage decodedMessage = (MqttMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validatePubReplyVariableHeader((MqttPubReplyMessageVariableHeader)message.variableHeader(), (MqttPubReplyMessageVariableHeader)decodedMessage.variableHeader());
    }

    @Test
    public void testPubAckMessageSkipCodeForMqtt5() throws Exception {
        MqttMessage message = this.createPubAckMessage((byte)0, MqttProperties.NO_PROPERTIES);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttMessage decodedMessage = (MqttMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validatePubReplyVariableHeader((MqttPubReplyMessageVariableHeader)message.variableHeader(), (MqttPubReplyMessageVariableHeader)decodedMessage.variableHeader());
    }

    @Test
    public void testSubAckMessageForMqtt5() throws Exception {
        MqttProperties props = new MqttProperties();
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.PAYLOAD_FORMAT_INDICATOR.value(), Integer.valueOf(6)));
        MqttSubAckMessage message = MqttCodecTest.createSubAckMessage(props, new int[]{1, 2, 0, 135});
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttSubAckMessage decodedMessage = (MqttSubAckMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        this.validatePacketIdAndPropertiesVariableHeader((MqttMessageIdAndPropertiesVariableHeader)message.variableHeader(), (MqttMessageIdAndPropertiesVariableHeader)decodedMessage.variableHeader());
        MqttCodecTest.validateSubAckPayload(message.payload(), decodedMessage.payload());
        Assert.assertArrayEquals((String)"MqttSubAckPayload QoS mismatch ", (Object[])new Integer[]{1, 2, 0, 128}, (Object[])decodedMessage.payload().grantedQoSLevels().toArray());
    }

    @Test
    public void testSubscribeMessageForMqtt5() throws Exception {
        Mockito.when((Object)this.versionAttrMock.get()).thenReturn((Object)MqttVersion.MQTT_5);
        MqttProperties props = new MqttProperties();
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.PAYLOAD_FORMAT_INDICATOR.value(), Integer.valueOf(6)));
        MqttSubscribeMessage message = MqttMessageBuilders.subscribe().messageId(1).properties(props).addSubscription("/topic", new MqttSubscriptionOption(MqttQoS.AT_LEAST_ONCE, true, true, MqttSubscriptionOption.RetainedHandlingPolicy.SEND_AT_SUBSCRIBE_IF_NOT_YET_EXISTS)).build();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttSubscribeMessage decodedMessage = (MqttSubscribeMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttMessageIdAndPropertiesVariableHeader expectedHeader = (MqttMessageIdAndPropertiesVariableHeader)message.variableHeader();
        MqttMessageIdAndPropertiesVariableHeader actualHeader = (MqttMessageIdAndPropertiesVariableHeader)decodedMessage.variableHeader();
        this.validatePacketIdAndPropertiesVariableHeader(expectedHeader, actualHeader);
        MqttTestUtils.validateSubscribePayload(message.payload(), decodedMessage.payload());
    }

    @Test
    public void testSubscribeMessageMqtt5EncodeAsMqtt3() throws Exception {
        Mockito.when((Object)this.versionAttrMock.get()).thenReturn((Object)MqttVersion.MQTT_3_1_1);
        MqttProperties props = new MqttProperties();
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.PAYLOAD_FORMAT_INDICATOR.value(), Integer.valueOf(6)));
        MqttSubscribeMessage message = MqttMessageBuilders.subscribe().messageId(1).properties(props).addSubscription("/topic", new MqttSubscriptionOption(MqttQoS.AT_LEAST_ONCE, true, true, MqttSubscriptionOption.RetainedHandlingPolicy.SEND_AT_SUBSCRIBE_IF_NOT_YET_EXISTS)).build();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttSubscribeMessage decodedMessage = (MqttSubscribeMessage)out.get(0);
        MqttSubscribeMessage expectedMessage = MqttMessageBuilders.subscribe().messageId(1).addSubscription("/topic", MqttSubscriptionOption.onlyFromQos((MqttQoS)MqttQoS.AT_LEAST_ONCE)).build();
        MqttCodecTest.validateFixedHeaders(expectedMessage.fixedHeader(), decodedMessage.fixedHeader());
        MqttMessageIdAndPropertiesVariableHeader expectedHeader = (MqttMessageIdAndPropertiesVariableHeader)expectedMessage.variableHeader();
        MqttMessageIdAndPropertiesVariableHeader actualHeader = (MqttMessageIdAndPropertiesVariableHeader)decodedMessage.variableHeader();
        this.validatePacketIdAndPropertiesVariableHeader(expectedHeader, actualHeader);
        MqttTestUtils.validateSubscribePayload(expectedMessage.payload(), decodedMessage.payload());
    }

    @Test
    public void testUnsubAckMessageForMqtt5() throws Exception {
        Mockito.when((Object)this.versionAttrMock.get()).thenReturn((Object)MqttVersion.MQTT_5);
        MqttProperties props = new MqttProperties();
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.PAYLOAD_FORMAT_INDICATOR.value(), Integer.valueOf(6)));
        MqttUnsubAckMessage message = MqttMessageBuilders.unsubAck().packetId((short)1).properties(props).addReasonCode((short)131).build();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttUnsubAckMessage decodedMessage = (MqttUnsubAckMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        this.validatePacketIdAndPropertiesVariableHeader((MqttMessageIdAndPropertiesVariableHeader)message.variableHeader(), (MqttMessageIdAndPropertiesVariableHeader)decodedMessage.variableHeader());
        Assert.assertEquals((String)"Reason code list doesn't match", (Object)message.payload().unsubscribeReasonCodes(), (Object)decodedMessage.payload().unsubscribeReasonCodes());
    }

    @Test
    public void testDisconnectMessageForMqtt5() throws Exception {
        Mockito.when((Object)this.versionAttrMock.get()).thenReturn((Object)MqttVersion.MQTT_5);
        MqttProperties props = new MqttProperties();
        props.add((MqttProperties.MqttProperty)new MqttProperties.IntegerProperty(MqttProperties.MqttPropertyType.SESSION_EXPIRY_INTERVAL.value(), Integer.valueOf(6)));
        MqttMessage message = MqttMessageBuilders.disconnect().reasonCode((byte)-106).properties(props).build();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttMessage decodedMessage = (MqttMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        this.validateReasonCodeAndPropertiesVariableHeader((MqttReasonCodeAndPropertiesVariableHeader)message.variableHeader(), (MqttReasonCodeAndPropertiesVariableHeader)decodedMessage.variableHeader());
    }

    @Test
    public void testDisconnectMessageSkipCodeForMqtt5() throws Exception {
        MqttMessage message = MqttMessageBuilders.disconnect().reasonCode((byte)0).properties(MqttProperties.NO_PROPERTIES).build();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttMessage decodedMessage = (MqttMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        this.validateReasonCodeAndPropertiesVariableHeader((MqttReasonCodeAndPropertiesVariableHeader)message.variableHeader(), (MqttReasonCodeAndPropertiesVariableHeader)decodedMessage.variableHeader());
    }

    @Test
    public void testAuthMessageForMqtt5() throws Exception {
        Mockito.when((Object)this.versionAttrMock.get()).thenReturn((Object)MqttVersion.MQTT_5);
        MqttProperties props = new MqttProperties();
        props.add((MqttProperties.MqttProperty)new MqttProperties.BinaryProperty(MqttProperties.MqttPropertyType.AUTHENTICATION_DATA.value(), "secret".getBytes(CharsetUtil.UTF_8)));
        MqttMessage message = MqttMessageBuilders.auth().reasonCode((byte)24).properties(props).build();
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttMessage decodedMessage = (MqttMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        this.validateReasonCodeAndPropertiesVariableHeader((MqttReasonCodeAndPropertiesVariableHeader)message.variableHeader(), (MqttReasonCodeAndPropertiesVariableHeader)decodedMessage.variableHeader());
    }

    @Test
    public void testMqttVersionDetection() throws Exception {
        Mockito.clearInvocations((Object[])new Attribute[]{this.versionAttrMock});
        MqttConnectMessage connectMessage = MqttCodecTest.createConnectMessage(MqttVersion.MQTT_5);
        ByteBuf connectByteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)connectMessage);
        ((Attribute)Mockito.verify(this.versionAttrMock, (VerificationMode)Mockito.times((int)1))).set((Object)MqttVersion.MQTT_5);
        Mockito.clearInvocations((Object[])new Attribute[]{this.versionAttrMock});
        LinkedList connectOut = new LinkedList();
        this.mqttDecoder.decode(this.ctx, connectByteBuf, connectOut);
        ((Attribute)Mockito.verify(this.versionAttrMock, (VerificationMode)Mockito.times((int)1))).set((Object)MqttVersion.MQTT_5);
        Assert.assertEquals((String)("Expected one CONNECT object but got " + connectOut.size()), (long)1L, (long)connectOut.size());
        MqttConnectMessage decodedConnectMessage = (MqttConnectMessage)connectOut.get(0);
        MqttCodecTest.validateFixedHeaders(connectMessage.fixedHeader(), decodedConnectMessage.fixedHeader());
        MqttCodecTest.validateConnectVariableHeader(connectMessage.variableHeader(), decodedConnectMessage.variableHeader());
        MqttCodecTest.validateConnectPayload(connectMessage.payload(), decodedConnectMessage.payload());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.versionAttrMock});
    }

    private void testMessageWithOnlyFixedHeader(MqttMessage message) throws Exception {
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttMessage decodedMessage = (MqttMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
    }

    private void testMessageWithOnlyFixedHeaderAndMessageIdVariableHeader(MqttMessageType messageType) throws Exception {
        MqttMessage message = MqttCodecTest.createMessageWithFixedHeaderAndMessageIdVariableHeader(messageType);
        ByteBuf byteBuf = MqttEncoder.doEncode((ChannelHandlerContext)this.ctx, (MqttMessage)message);
        LinkedList out = new LinkedList();
        this.mqttDecoder.decode(this.ctx, byteBuf, out);
        Assert.assertEquals((String)("Expected one object but got " + out.size()), (long)1L, (long)out.size());
        MqttMessage decodedMessage = (MqttMessage)out.get(0);
        MqttCodecTest.validateFixedHeaders(message.fixedHeader(), decodedMessage.fixedHeader());
        MqttCodecTest.validateMessageIdVariableHeader((MqttMessageIdVariableHeader)message.variableHeader(), (MqttMessageIdVariableHeader)decodedMessage.variableHeader());
    }

    private static MqttMessage createMessageWithFixedHeader(MqttMessageType messageType) {
        return new MqttMessage(new MqttFixedHeader(messageType, false, MqttQoS.AT_MOST_ONCE, false, 0));
    }

    private static MqttMessage createMessageWithFixedHeaderAndMessageIdVariableHeader(MqttMessageType messageType) {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(messageType, false, messageType == MqttMessageType.PUBREL ? MqttQoS.AT_LEAST_ONCE : MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader mqttMessageIdVariableHeader = MqttMessageIdVariableHeader.from((int)12345);
        return new MqttMessage(mqttFixedHeader, (Object)mqttMessageIdVariableHeader);
    }

    private static MqttConnectMessage createConnectMessage(MqttVersion mqttVersion) {
        return MqttCodecTest.createConnectMessage(mqttVersion, USER_NAME, PASSWORD, MqttProperties.NO_PROPERTIES, MqttProperties.NO_PROPERTIES);
    }

    private static MqttConnectMessage createConnectMessage(MqttVersion mqttVersion, String username, String password, MqttProperties properties, MqttProperties willProperties) {
        return MqttMessageBuilders.connect().clientId(CLIENT_ID).protocolVersion(mqttVersion).username(username).password(password.getBytes(CharsetUtil.UTF_8)).properties(properties).willRetain(true).willQoS(MqttQoS.AT_LEAST_ONCE).willFlag(true).willTopic(WILL_TOPIC).willMessage(WILL_MESSAGE.getBytes(CharsetUtil.UTF_8)).willProperties(willProperties).cleanSession(true).keepAlive(600).build();
    }

    private static MqttConnAckMessage createConnAckMessage() {
        return MqttCodecTest.createConnAckMessage(MqttProperties.NO_PROPERTIES);
    }

    private static MqttConnAckMessage createConnAckMessage(MqttProperties properties) {
        return MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_ACCEPTED).properties(properties).sessionPresent(true).build();
    }

    private static MqttPublishMessage createPublishMessage() {
        return MqttCodecTest.createPublishMessage(MqttProperties.NO_PROPERTIES);
    }

    private static MqttPublishMessage createPublishMessage(MqttProperties properties) {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.PUBLISH, false, MqttQoS.AT_LEAST_ONCE, true, 0);
        MqttPublishVariableHeader mqttPublishVariableHeader = new MqttPublishVariableHeader("/abc", 1234, properties);
        ByteBuf payload = ALLOCATOR.buffer();
        payload.writeBytes("whatever".getBytes(CharsetUtil.UTF_8));
        return new MqttPublishMessage(mqttFixedHeader, mqttPublishVariableHeader, payload);
    }

    private static MqttSubscribeMessage createSubscribeMessage() {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.SUBSCRIBE, false, MqttQoS.AT_LEAST_ONCE, true, 0);
        MqttMessageIdVariableHeader mqttMessageIdVariableHeader = MqttMessageIdVariableHeader.from((int)12345);
        LinkedList<MqttTopicSubscription> topicSubscriptions = new LinkedList<MqttTopicSubscription>();
        topicSubscriptions.add(new MqttTopicSubscription("/abc", MqttQoS.AT_LEAST_ONCE));
        topicSubscriptions.add(new MqttTopicSubscription("/def", MqttQoS.AT_LEAST_ONCE));
        topicSubscriptions.add(new MqttTopicSubscription("/xyz", MqttQoS.EXACTLY_ONCE));
        MqttSubscribePayload mqttSubscribePayload = new MqttSubscribePayload(topicSubscriptions);
        return new MqttSubscribeMessage(mqttFixedHeader, mqttMessageIdVariableHeader, mqttSubscribePayload);
    }

    private static MqttSubAckMessage createSubAckMessage() {
        return MqttCodecTest.createSubAckMessage(MqttProperties.NO_PROPERTIES, new int[]{1, 2, 0});
    }

    private static MqttSubAckMessage createSubAckMessage(MqttProperties properties, int[] reasonCodes) {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.SUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader mqttMessageIdVariableHeader = MqttMessageIdVariableHeader.from((int)12345);
        MqttSubAckPayload mqttSubAckPayload = new MqttSubAckPayload(reasonCodes);
        return new MqttSubAckMessage(mqttFixedHeader, mqttMessageIdVariableHeader, mqttSubAckPayload);
    }

    private static MqttUnsubscribeMessage createUnsubscribeMessage() {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.UNSUBSCRIBE, false, MqttQoS.AT_LEAST_ONCE, true, 0);
        MqttMessageIdVariableHeader mqttMessageIdVariableHeader = MqttMessageIdVariableHeader.from((int)12345);
        LinkedList<String> topics = new LinkedList<String>();
        topics.add("/abc");
        topics.add("/def");
        topics.add("/xyz");
        MqttUnsubscribePayload mqttUnsubscribePayload = new MqttUnsubscribePayload(topics);
        return new MqttUnsubscribeMessage(mqttFixedHeader, mqttMessageIdVariableHeader, mqttUnsubscribePayload);
    }

    private MqttMessage createPubAckMessage(byte reasonCode, MqttProperties properties) {
        return MqttMessageBuilders.pubAck().packetId((short)1).reasonCode(reasonCode).properties(properties).build();
    }

    private static void validateFixedHeaders(MqttFixedHeader expected, MqttFixedHeader actual) {
        Assert.assertEquals((String)"MqttFixedHeader MqttMessageType mismatch ", (Object)expected.messageType(), (Object)actual.messageType());
        Assert.assertEquals((String)"MqttFixedHeader Qos mismatch ", (Object)expected.qosLevel(), (Object)actual.qosLevel());
    }

    private static void validateConnectVariableHeader(MqttConnectVariableHeader expected, MqttConnectVariableHeader actual) {
        Assert.assertEquals((String)"MqttConnectVariableHeader Name mismatch ", (Object)expected.name(), (Object)actual.name());
        Assert.assertEquals((String)"MqttConnectVariableHeader KeepAliveTimeSeconds mismatch ", (long)expected.keepAliveTimeSeconds(), (long)actual.keepAliveTimeSeconds());
        Assert.assertEquals((String)"MqttConnectVariableHeader Version mismatch ", (long)expected.version(), (long)actual.version());
        Assert.assertEquals((String)"MqttConnectVariableHeader Version mismatch ", (long)expected.version(), (long)actual.version());
        MqttTestUtils.validateProperties(expected.properties(), actual.properties());
        Assert.assertEquals((String)"MqttConnectVariableHeader WillQos mismatch ", (long)expected.willQos(), (long)actual.willQos());
        Assert.assertEquals((String)"MqttConnectVariableHeader HasUserName mismatch ", (Object)expected.hasUserName(), (Object)actual.hasUserName());
        Assert.assertEquals((String)"MqttConnectVariableHeader HasPassword mismatch ", (Object)expected.hasPassword(), (Object)actual.hasPassword());
        Assert.assertEquals((String)"MqttConnectVariableHeader IsCleanSession mismatch ", (Object)expected.isCleanSession(), (Object)actual.isCleanSession());
        Assert.assertEquals((String)"MqttConnectVariableHeader IsWillFlag mismatch ", (Object)expected.isWillFlag(), (Object)actual.isWillFlag());
        Assert.assertEquals((String)"MqttConnectVariableHeader IsWillRetain mismatch ", (Object)expected.isWillRetain(), (Object)actual.isWillRetain());
    }

    private static void validateConnectPayload(MqttConnectPayload expected, MqttConnectPayload actual) {
        Assert.assertEquals((String)"MqttConnectPayload ClientIdentifier mismatch ", (Object)expected.clientIdentifier(), (Object)actual.clientIdentifier());
        Assert.assertEquals((String)"MqttConnectPayload UserName mismatch ", (Object)expected.userName(), (Object)actual.userName());
        Assert.assertEquals((String)"MqttConnectPayload Password mismatch ", (Object)expected.password(), (Object)actual.password());
        Assert.assertTrue((String)"MqttConnectPayload Password bytes mismatch ", (boolean)Arrays.equals(expected.passwordInBytes(), actual.passwordInBytes()));
        Assert.assertEquals((String)"MqttConnectPayload WillMessage mismatch ", (Object)expected.willMessage(), (Object)actual.willMessage());
        Assert.assertTrue((String)"MqttConnectPayload WillMessage bytes mismatch ", (boolean)Arrays.equals(expected.willMessageInBytes(), actual.willMessageInBytes()));
        Assert.assertEquals((String)"MqttConnectPayload WillTopic mismatch ", (Object)expected.willTopic(), (Object)actual.willTopic());
        MqttTestUtils.validateProperties(expected.willProperties(), actual.willProperties());
    }

    private static void validateConnAckVariableHeader(MqttConnAckVariableHeader expected, MqttConnAckVariableHeader actual) {
        Assert.assertEquals((String)"MqttConnAckVariableHeader MqttConnectReturnCode mismatch", (Object)expected.connectReturnCode(), (Object)actual.connectReturnCode());
    }

    private static void validatePublishVariableHeader(MqttPublishVariableHeader expected, MqttPublishVariableHeader actual) {
        Assert.assertEquals((String)"MqttPublishVariableHeader TopicName mismatch ", (Object)expected.topicName(), (Object)actual.topicName());
        Assert.assertEquals((String)"MqttPublishVariableHeader MessageId mismatch ", (long)expected.packetId(), (long)actual.packetId());
        MqttTestUtils.validateProperties(expected.properties(), actual.properties());
    }

    private static void validatePublishPayload(ByteBuf expected, ByteBuf actual) {
        Assert.assertEquals((String)"PublishPayload mismatch ", (long)0L, (long)expected.compareTo(actual));
    }

    private static void validateMessageIdVariableHeader(MqttMessageIdVariableHeader expected, MqttMessageIdVariableHeader actual) {
        Assert.assertEquals((String)"MqttMessageIdVariableHeader MessageId mismatch ", (long)expected.messageId(), (long)actual.messageId());
    }

    private static void validateSubAckPayload(MqttSubAckPayload expected, MqttSubAckPayload actual) {
        Assert.assertArrayEquals((String)"MqttSubAckPayload reason codes mismatch ", (Object[])expected.reasonCodes().toArray(), (Object[])actual.reasonCodes().toArray());
        Assert.assertArrayEquals((String)"MqttSubAckPayload QoS level mismatch ", (Object[])expected.grantedQoSLevels().toArray(), (Object[])actual.grantedQoSLevels().toArray());
    }

    private static void validateDecoderExceptionTooLargeMessage(MqttMessage message) {
        Assert.assertNull((String)"MqttMessage payload expected null ", (Object)message.payload());
        Assert.assertTrue((boolean)message.decoderResult().isFailure());
        Throwable cause = message.decoderResult().cause();
        Assert.assertTrue((String)"MqttMessage DecoderResult cause expected instance of DecoderException ", (boolean)(cause instanceof DecoderException));
        Assert.assertTrue((String)"MqttMessage DecoderResult cause reason expect to contain 'too large message' ", (boolean)cause.getMessage().contains("too large message:"));
    }

    private static void validatePubReplyVariableHeader(MqttPubReplyMessageVariableHeader expected, MqttPubReplyMessageVariableHeader actual) {
        Assert.assertEquals((String)"MqttPubReplyMessageVariableHeader MessageId mismatch ", (long)expected.messageId(), (long)actual.messageId());
        Assert.assertEquals((String)"MqttPubReplyMessageVariableHeader reasonCode mismatch ", (long)expected.reasonCode(), (long)actual.reasonCode());
        MqttProperties expectedProps = expected.properties();
        MqttProperties actualProps = actual.properties();
        MqttTestUtils.validateProperties(expectedProps, actualProps);
    }

    private void validatePacketIdAndPropertiesVariableHeader(MqttMessageIdAndPropertiesVariableHeader expected, MqttMessageIdAndPropertiesVariableHeader actual) {
        Assert.assertEquals((String)"MqttMessageIdAndPropertiesVariableHeader MessageId mismatch ", (long)expected.messageId(), (long)actual.messageId());
        MqttProperties expectedProps = expected.properties();
        MqttProperties actualProps = actual.properties();
        MqttTestUtils.validateProperties(expectedProps, actualProps);
    }

    private void validateReasonCodeAndPropertiesVariableHeader(MqttReasonCodeAndPropertiesVariableHeader expected, MqttReasonCodeAndPropertiesVariableHeader actual) {
        Assert.assertEquals((String)"MqttReasonCodeAndPropertiesVariableHeader reason mismatch ", (long)expected.reasonCode(), (long)actual.reasonCode());
        MqttProperties expectedProps = expected.properties();
        MqttProperties actualProps = actual.properties();
        MqttTestUtils.validateProperties(expectedProps, actualProps);
    }
}

