/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.mqtt;

import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttSubscribePayload;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import io.netty.handler.codec.mqtt.MqttUnsubscribePayload;
import java.util.List;
import org.junit.Assert;

public final class MqttTestUtils {
    private MqttTestUtils() {
    }

    public static void validateProperties(MqttProperties expected, MqttProperties actual) {
        block9: for (MqttProperties.MqttProperty expectedProperty : expected.listAll()) {
            MqttProperties.MqttProperty actualProperty = actual.getProperty(expectedProperty.propertyId);
            switch (MqttProperties.MqttPropertyType.valueOf((int)expectedProperty.propertyId)) {
                case PAYLOAD_FORMAT_INDICATOR: 
                case REQUEST_PROBLEM_INFORMATION: 
                case REQUEST_RESPONSE_INFORMATION: 
                case MAXIMUM_QOS: 
                case RETAIN_AVAILABLE: 
                case WILDCARD_SUBSCRIPTION_AVAILABLE: 
                case SUBSCRIPTION_IDENTIFIER_AVAILABLE: 
                case SHARED_SUBSCRIPTION_AVAILABLE: {
                    Object expectedValue = (Integer)((MqttProperties.IntegerProperty)expectedProperty).value;
                    Object actualValue = (Integer)((MqttProperties.IntegerProperty)actualProperty).value;
                    Assert.assertEquals((String)"one byte property doesn't match", (Object)expectedValue, (Object)actualValue);
                    break;
                }
                case SERVER_KEEP_ALIVE: 
                case RECEIVE_MAXIMUM: 
                case TOPIC_ALIAS_MAXIMUM: 
                case TOPIC_ALIAS: {
                    Object expectedValue = (Integer)((MqttProperties.IntegerProperty)expectedProperty).value;
                    Object actualValue = (Integer)((MqttProperties.IntegerProperty)actualProperty).value;
                    Assert.assertEquals((String)"two byte property doesn't match", (Object)expectedValue, (Object)actualValue);
                    break;
                }
                case PUBLICATION_EXPIRY_INTERVAL: 
                case SESSION_EXPIRY_INTERVAL: 
                case WILL_DELAY_INTERVAL: 
                case MAXIMUM_PACKET_SIZE: {
                    Object expectedValue = (Integer)((MqttProperties.IntegerProperty)expectedProperty).value;
                    Object actualValue = (Integer)((MqttProperties.IntegerProperty)actualProperty).value;
                    Assert.assertEquals((String)"four byte property doesn't match", (Object)expectedValue, (Object)actualValue);
                    break;
                }
                case SUBSCRIPTION_IDENTIFIER: {
                    Object expectedValue = (Integer)((MqttProperties.IntegerProperty)expectedProperty).value;
                    Object actualValue = (Integer)((MqttProperties.IntegerProperty)actualProperty).value;
                    Assert.assertEquals((String)"variable byte integer property doesn't match", (Object)expectedValue, (Object)actualValue);
                    break;
                }
                case CONTENT_TYPE: 
                case RESPONSE_TOPIC: 
                case ASSIGNED_CLIENT_IDENTIFIER: 
                case AUTHENTICATION_METHOD: 
                case RESPONSE_INFORMATION: 
                case SERVER_REFERENCE: 
                case REASON_STRING: {
                    Object expectedValue = (String)((MqttProperties.StringProperty)expectedProperty).value;
                    Object actualValue = (String)((MqttProperties.StringProperty)actualProperty).value;
                    Assert.assertEquals((String)"String property doesn't match", (Object)expectedValue, (Object)actualValue);
                    break;
                }
                case USER_PROPERTY: {
                    List expectedPairs = (List)((MqttProperties.UserProperties)expectedProperty).value;
                    List actualPairs = (List)((MqttProperties.UserProperties)actualProperty).value;
                    Assert.assertEquals((String)"User properties count doesn't match", (Object)expectedPairs, (Object)actualPairs);
                    for (int i = 0; i < expectedPairs.size(); ++i) {
                        Assert.assertEquals((String)"User property mismatch", expectedPairs.get(i), actualPairs.get(i));
                    }
                    continue block9;
                }
                case CORRELATION_DATA: 
                case AUTHENTICATION_DATA: {
                    Object expectedValue = (byte[])((MqttProperties.BinaryProperty)expectedProperty).value;
                    Object actualValue = (byte[])((MqttProperties.BinaryProperty)actualProperty).value;
                    String expectedHexDump = ByteBufUtil.hexDump((byte[])expectedValue);
                    String actualHexDump = ByteBufUtil.hexDump((byte[])actualValue);
                    Assert.assertEquals((String)"byte[] property doesn't match", (Object)expectedHexDump, (Object)actualHexDump);
                    break;
                }
                default: {
                    Assert.fail((String)("Property Id not recognized " + Integer.toHexString(expectedProperty.propertyId)));
                }
            }
        }
        for (MqttProperties.MqttProperty actualProperty : actual.listAll()) {
            MqttProperties.MqttProperty expectedProperty = expected.getProperty(actualProperty.propertyId);
            Assert.assertNotNull((String)("Property " + actualProperty.propertyId + " not expected"), (Object)expectedProperty);
        }
    }

    public static void validateSubscribePayload(MqttSubscribePayload expected, MqttSubscribePayload actual) {
        List expectedTopicSubscriptions = expected.topicSubscriptions();
        List actualTopicSubscriptions = actual.topicSubscriptions();
        Assert.assertEquals((String)"MqttSubscribePayload TopicSubscriptionList size mismatch ", (long)expectedTopicSubscriptions.size(), (long)actualTopicSubscriptions.size());
        for (int i = 0; i < expectedTopicSubscriptions.size(); ++i) {
            MqttTestUtils.validateTopicSubscription((MqttTopicSubscription)expectedTopicSubscriptions.get(i), (MqttTopicSubscription)actualTopicSubscriptions.get(i));
        }
    }

    public static void validateTopicSubscription(MqttTopicSubscription expected, MqttTopicSubscription actual) {
        Assert.assertEquals((String)"MqttTopicSubscription TopicName mismatch ", (Object)expected.topicName(), (Object)actual.topicName());
        Assert.assertEquals((String)"MqttTopicSubscription Qos mismatch ", (Object)expected.qualityOfService(), (Object)actual.qualityOfService());
        Assert.assertEquals((String)"MqttTopicSubscription options mismatch ", (Object)expected.option(), (Object)actual.option());
    }

    public static void validateUnsubscribePayload(MqttUnsubscribePayload expected, MqttUnsubscribePayload actual) {
        Assert.assertArrayEquals((String)"MqttUnsubscribePayload TopicList mismatch ", (Object[])expected.topics().toArray(), (Object[])actual.topics().toArray());
    }
}

