/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.memcache.binary;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.memcache.binary.DefaultFullBinaryMemcacheResponse;
import io.netty.handler.codec.memcache.binary.FullBinaryMemcacheResponse;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultFullBinaryMemcacheResponseTest {
    private DefaultFullBinaryMemcacheResponse response;

    @Before
    public void setUp() {
        this.response = new DefaultFullBinaryMemcacheResponse(Unpooled.copiedBuffer((CharSequence)"key", (Charset)CharsetUtil.UTF_8), Unpooled.wrappedBuffer((byte[])new byte[]{1, 3, 4, 9}), Unpooled.copiedBuffer((CharSequence)"some value", (Charset)CharsetUtil.UTF_8));
        this.response.setStatus((short)1);
        this.response.setMagic((byte)3);
        this.response.setOpcode((byte)2);
        this.response.setKeyLength((short)32);
        this.response.setExtrasLength((byte)34);
        this.response.setDataType((byte)43);
        this.response.setTotalBodyLength(345);
        this.response.setOpaque(3);
        this.response.setCas(345345L);
    }

    @Test
    public void fullCopy() {
        FullBinaryMemcacheResponse newInstance = this.response.copy();
        try {
            this.assertResponseEquals((FullBinaryMemcacheResponse)this.response, this.response.content(), newInstance);
        }
        finally {
            this.response.release();
            newInstance.release();
        }
    }

    @Test
    public void fullDuplicate() {
        try {
            this.assertResponseEquals((FullBinaryMemcacheResponse)this.response, this.response.content(), this.response.duplicate());
        }
        finally {
            this.response.release();
        }
    }

    @Test
    public void fullReplace() {
        ByteBuf newContent = Unpooled.copiedBuffer((CharSequence)"new value", (Charset)CharsetUtil.UTF_8);
        FullBinaryMemcacheResponse newInstance = this.response.replace(newContent);
        try {
            this.assertResponseEquals((FullBinaryMemcacheResponse)this.response, newContent, newInstance);
        }
        finally {
            this.response.release();
            newInstance.release();
        }
    }

    private void assertResponseEquals(FullBinaryMemcacheResponse expected, ByteBuf expectedContent, FullBinaryMemcacheResponse actual) {
        Assert.assertNotSame((Object)expected, (Object)actual);
        Assert.assertEquals((Object)expected.key(), (Object)actual.key());
        Assert.assertEquals((Object)expected.extras(), (Object)actual.extras());
        Assert.assertEquals((Object)expectedContent, (Object)actual.content());
        Assert.assertEquals((long)expected.status(), (long)actual.status());
        Assert.assertEquals((long)expected.magic(), (long)actual.magic());
        Assert.assertEquals((long)expected.opcode(), (long)actual.opcode());
        Assert.assertEquals((long)expected.keyLength(), (long)actual.keyLength());
        Assert.assertEquals((long)expected.extrasLength(), (long)actual.extrasLength());
        Assert.assertEquals((long)expected.dataType(), (long)actual.dataType());
        Assert.assertEquals((long)expected.totalBodyLength(), (long)actual.totalBodyLength());
        Assert.assertEquals((long)expected.opaque(), (long)actual.opaque());
        Assert.assertEquals((long)expected.cas(), (long)actual.cas());
    }
}

