/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.memcache.binary;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.memcache.binary.DefaultFullBinaryMemcacheRequest;
import io.netty.handler.codec.memcache.binary.FullBinaryMemcacheRequest;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultFullBinaryMemcacheRequestTest {
    private DefaultFullBinaryMemcacheRequest request;

    @Before
    public void setUp() {
        this.request = new DefaultFullBinaryMemcacheRequest(Unpooled.copiedBuffer((CharSequence)"key", (Charset)CharsetUtil.UTF_8), Unpooled.wrappedBuffer((byte[])new byte[]{1, 3, 4, 9}), Unpooled.copiedBuffer((CharSequence)"some value", (Charset)CharsetUtil.UTF_8));
        this.request.setReserved((short)534);
        this.request.setMagic((byte)3);
        this.request.setOpcode((byte)2);
        this.request.setKeyLength((short)32);
        this.request.setExtrasLength((byte)34);
        this.request.setDataType((byte)43);
        this.request.setTotalBodyLength(345);
        this.request.setOpaque(3);
        this.request.setCas(345345L);
    }

    @Test
    public void fullCopy() {
        FullBinaryMemcacheRequest newInstance = this.request.copy();
        try {
            this.assertCopy((FullBinaryMemcacheRequest)this.request, this.request.content(), newInstance);
        }
        finally {
            this.request.release();
            newInstance.release();
        }
    }

    @Test
    public void fullDuplicate() {
        FullBinaryMemcacheRequest newInstance = this.request.duplicate();
        try {
            this.assertCopy((FullBinaryMemcacheRequest)this.request, this.request.content(), newInstance);
        }
        finally {
            this.request.release();
        }
    }

    @Test
    public void fullReplace() {
        ByteBuf newContent = Unpooled.copiedBuffer((CharSequence)"new value", (Charset)CharsetUtil.UTF_8);
        FullBinaryMemcacheRequest newInstance = this.request.replace(newContent);
        try {
            this.assertCopy((FullBinaryMemcacheRequest)this.request, newContent, newInstance);
        }
        finally {
            this.request.release();
            newInstance.release();
        }
    }

    private void assertCopy(FullBinaryMemcacheRequest expected, ByteBuf expectedContent, FullBinaryMemcacheRequest actual) {
        Assert.assertNotSame((Object)expected, (Object)actual);
        Assert.assertEquals((Object)expected.key(), (Object)actual.key());
        Assert.assertEquals((Object)expected.extras(), (Object)actual.extras());
        Assert.assertEquals((Object)expectedContent, (Object)actual.content());
        Assert.assertEquals((long)expected.reserved(), (long)actual.reserved());
        Assert.assertEquals((long)expected.magic(), (long)actual.magic());
        Assert.assertEquals((long)expected.opcode(), (long)actual.opcode());
        Assert.assertEquals((long)expected.keyLength(), (long)actual.keyLength());
        Assert.assertEquals((long)expected.extrasLength(), (long)actual.extrasLength());
        Assert.assertEquals((long)expected.dataType(), (long)actual.dataType());
        Assert.assertEquals((long)expected.totalBodyLength(), (long)actual.totalBodyLength());
        Assert.assertEquals((long)expected.opaque(), (long)actual.opaque());
        Assert.assertEquals((long)expected.cas(), (long)actual.cas());
    }
}

