/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapter;
import io.netty.util.AsciiString;
import java.util.Iterator;
import java.util.Map;

public final class InboundHttp2ToHttpPriorityAdapter
extends InboundHttp2ToHttpAdapter {
    private static final AsciiString OUT_OF_MESSAGE_SEQUENCE_METHOD = new AsciiString((CharSequence)HttpConversionUtil.OUT_OF_MESSAGE_SEQUENCE_METHOD.toString());
    private static final AsciiString OUT_OF_MESSAGE_SEQUENCE_PATH = new AsciiString((CharSequence)"");
    private static final AsciiString OUT_OF_MESSAGE_SEQUENCE_RETURN_CODE = new AsciiString((CharSequence)HttpConversionUtil.OUT_OF_MESSAGE_SEQUENCE_RETURN_CODE.toString());
    private final Http2Connection.PropertyKey outOfMessageFlowHeadersKey;

    InboundHttp2ToHttpPriorityAdapter(Http2Connection connection, int maxContentLength, boolean validateHttpHeaders, boolean propagateSettings) {
        super(connection, maxContentLength, validateHttpHeaders, propagateSettings);
        this.outOfMessageFlowHeadersKey = connection.newKey();
    }

    private HttpHeaders getOutOfMessageFlowHeaders(Http2Stream stream) {
        return (HttpHeaders)stream.getProperty(this.outOfMessageFlowHeadersKey);
    }

    private void putOutOfMessageFlowHeaders(Http2Stream stream, HttpHeaders headers) {
        stream.setProperty(this.outOfMessageFlowHeadersKey, headers);
    }

    private HttpHeaders removeOutOfMessageFlowHeaders(Http2Stream stream) {
        return (HttpHeaders)stream.removeProperty(this.outOfMessageFlowHeadersKey);
    }

    private static HttpHeaders getActiveHeaders(FullHttpMessage msg) {
        return msg.content().isReadable() ? msg.trailingHeaders() : msg.headers();
    }

    private void importOutOfMessageFlowHeaders(Http2Stream stream, HttpHeaders headers) {
        HttpHeaders outOfMessageFlowHeader = this.getOutOfMessageFlowHeaders(stream);
        if (outOfMessageFlowHeader == null) {
            this.putOutOfMessageFlowHeaders(stream, headers);
        } else {
            outOfMessageFlowHeader.setAll(headers);
        }
    }

    private void exportOutOfMessageFlowHeaders(Http2Stream stream, HttpHeaders headers) {
        HttpHeaders outOfMessageFlowHeader = this.getOutOfMessageFlowHeaders(stream);
        if (outOfMessageFlowHeader != null) {
            headers.setAll(outOfMessageFlowHeader);
        }
    }

    private static void removePriorityRelatedHeaders(HttpHeaders headers) {
        headers.remove((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text());
        headers.remove((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text());
    }

    private void initializePseudoHeaders(Http2Headers headers) {
        if (this.connection.isServer()) {
            headers.method((CharSequence)OUT_OF_MESSAGE_SEQUENCE_METHOD).path((CharSequence)OUT_OF_MESSAGE_SEQUENCE_PATH);
        } else {
            headers.status((CharSequence)OUT_OF_MESSAGE_SEQUENCE_RETURN_CODE);
        }
    }

    private static void addHttpHeadersToHttp2Headers(HttpHeaders httpHeaders, Http2Headers http2Headers) {
        Iterator iter = httpHeaders.iteratorCharSequence();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            http2Headers.add(AsciiString.of((CharSequence)((CharSequence)entry.getKey())), AsciiString.of((CharSequence)((CharSequence)entry.getValue())));
        }
    }

    @Override
    protected void fireChannelRead(ChannelHandlerContext ctx, FullHttpMessage msg, boolean release, Http2Stream stream) {
        this.exportOutOfMessageFlowHeaders(stream, InboundHttp2ToHttpPriorityAdapter.getActiveHeaders(msg));
        super.fireChannelRead(ctx, msg, release, stream);
    }

    @Override
    protected FullHttpMessage processHeadersBegin(ChannelHandlerContext ctx, Http2Stream stream, Http2Headers headers, boolean endOfStream, boolean allowAppend, boolean appendToTrailer) throws Http2Exception {
        FullHttpMessage msg = super.processHeadersBegin(ctx, stream, headers, endOfStream, allowAppend, appendToTrailer);
        if (msg != null) {
            this.exportOutOfMessageFlowHeaders(stream, InboundHttp2ToHttpPriorityAdapter.getActiveHeaders(msg));
        }
        return msg;
    }

    @Override
    public void onPriorityTreeParentChanged(Http2Stream stream, Http2Stream oldParent) {
        Http2Stream parent = stream.parent();
        FullHttpMessage msg = this.getMessage(stream);
        if (msg == null) {
            if (parent != null && !parent.equals(this.connection.connectionStream())) {
                DefaultHttpHeaders headers = new DefaultHttpHeaders();
                headers.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text(), parent.id());
                this.importOutOfMessageFlowHeaders(stream, (HttpHeaders)headers);
            }
        } else if (parent == null) {
            InboundHttp2ToHttpPriorityAdapter.removePriorityRelatedHeaders(msg.headers());
            InboundHttp2ToHttpPriorityAdapter.removePriorityRelatedHeaders(msg.trailingHeaders());
        } else if (!parent.equals(this.connection.connectionStream())) {
            HttpHeaders headers = InboundHttp2ToHttpPriorityAdapter.getActiveHeaders(msg);
            headers.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text(), parent.id());
        }
    }

    @Override
    public void onWeightChanged(Http2Stream stream, short oldWeight) {
        HttpHeaders headers;
        FullHttpMessage msg = this.getMessage(stream);
        if (msg == null) {
            headers = new DefaultHttpHeaders();
            this.importOutOfMessageFlowHeaders(stream, headers);
        } else {
            headers = InboundHttp2ToHttpPriorityAdapter.getActiveHeaders(msg);
        }
        headers.setShort((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), stream.weight());
    }

    @Override
    public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) throws Http2Exception {
        Http2Stream stream = this.connection.stream(streamId);
        if (stream == null) {
            return;
        }
        FullHttpMessage msg = this.getMessage(stream);
        if (msg == null) {
            HttpHeaders httpHeaders = this.removeOutOfMessageFlowHeaders(stream);
            if (httpHeaders == null) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Priority Frame recieved for unknown stream id %d", streamId);
            }
            DefaultHttp2Headers http2Headers = new DefaultHttp2Headers(this.validateHttpHeaders, httpHeaders.size());
            this.initializePseudoHeaders(http2Headers);
            InboundHttp2ToHttpPriorityAdapter.addHttpHeadersToHttp2Headers(httpHeaders, http2Headers);
            msg = this.newMessage(stream, http2Headers, this.validateHttpHeaders, ctx.alloc());
            this.fireChannelRead(ctx, msg, false, stream);
        }
    }
}

