/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.DefaultHttp2HeadersTest;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.ReadOnlyHttp2Headers;
import io.netty.util.AsciiString;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;

public class ReadOnlyHttp2HeadersTest {
    @Test(expected=IllegalArgumentException.class)
    public void notKeyValuePairThrows() {
        ReadOnlyHttp2Headers.trailers((boolean)false, (AsciiString[])new AsciiString[]{null});
    }

    @Test(expected=NullPointerException.class)
    public void nullTrailersNotAllowed() {
        ReadOnlyHttp2Headers.trailers((boolean)false, (AsciiString[])null);
    }

    @Test
    public void nullHeaderNameNotChecked() {
        ReadOnlyHttp2Headers.trailers((boolean)false, (AsciiString[])new AsciiString[]{null, null});
    }

    @Test(expected=Http2Exception.class)
    public void nullHeaderNameValidated() {
        ReadOnlyHttp2Headers.trailers((boolean)true, (AsciiString[])new AsciiString[]{null, new AsciiString((CharSequence)"foo")});
    }

    @Test(expected=IllegalArgumentException.class)
    public void pseudoHeaderNotAllowedAfterNonPseudoHeaders() {
        ReadOnlyHttp2Headers.trailers((boolean)true, (AsciiString[])new AsciiString[]{new AsciiString((CharSequence)":name"), new AsciiString((CharSequence)"foo"), new AsciiString((CharSequence)"othername"), new AsciiString((CharSequence)"goo"), new AsciiString((CharSequence)":pseudo"), new AsciiString((CharSequence)"val")});
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullValuesAreNotAllowed() {
        ReadOnlyHttp2Headers.trailers((boolean)true, (AsciiString[])new AsciiString[]{new AsciiString((CharSequence)"foo"), null});
    }

    @Test
    public void emptyHeaderNameAllowed() {
        ReadOnlyHttp2Headers.trailers((boolean)false, (AsciiString[])new AsciiString[]{AsciiString.EMPTY_STRING, new AsciiString((CharSequence)"foo")});
    }

    @Test
    public void testPseudoHeadersMustComeFirstWhenIteratingServer() {
        ReadOnlyHttp2Headers headers = ReadOnlyHttp2HeadersTest.newServerHeaders();
        DefaultHttp2HeadersTest.verifyPseudoHeadersFirst((Http2Headers)headers);
    }

    @Test
    public void testPseudoHeadersMustComeFirstWhenIteratingClient() {
        ReadOnlyHttp2Headers headers = ReadOnlyHttp2HeadersTest.newClientHeaders();
        DefaultHttp2HeadersTest.verifyPseudoHeadersFirst((Http2Headers)headers);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testIteratorReadOnlyClient() {
        ReadOnlyHttp2HeadersTest.testIteratorReadOnly((Http2Headers)ReadOnlyHttp2HeadersTest.newClientHeaders());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testIteratorReadOnlyServer() {
        ReadOnlyHttp2HeadersTest.testIteratorReadOnly((Http2Headers)ReadOnlyHttp2HeadersTest.newServerHeaders());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testIteratorReadOnlyTrailers() {
        ReadOnlyHttp2HeadersTest.testIteratorReadOnly((Http2Headers)ReadOnlyHttp2HeadersTest.newTrailers());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testIteratorEntryReadOnlyClient() {
        ReadOnlyHttp2HeadersTest.testIteratorEntryReadOnly((Http2Headers)ReadOnlyHttp2HeadersTest.newClientHeaders());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testIteratorEntryReadOnlyServer() {
        ReadOnlyHttp2HeadersTest.testIteratorEntryReadOnly((Http2Headers)ReadOnlyHttp2HeadersTest.newServerHeaders());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testIteratorEntryReadOnlyTrailers() {
        ReadOnlyHttp2HeadersTest.testIteratorEntryReadOnly((Http2Headers)ReadOnlyHttp2HeadersTest.newTrailers());
    }

    @Test
    public void testSize() {
        ReadOnlyHttp2Headers headers = ReadOnlyHttp2HeadersTest.newTrailers();
        Assert.assertEquals((long)(ReadOnlyHttp2HeadersTest.otherHeaders().length / 2), (long)headers.size());
    }

    @Test
    public void testIsNotEmpty() {
        ReadOnlyHttp2Headers headers = ReadOnlyHttp2HeadersTest.newTrailers();
        Assert.assertFalse((boolean)headers.isEmpty());
    }

    @Test
    public void testIsEmpty() {
        ReadOnlyHttp2Headers headers = ReadOnlyHttp2Headers.trailers((boolean)false, (AsciiString[])new AsciiString[0]);
        Assert.assertTrue((boolean)headers.isEmpty());
    }

    @Test
    public void testContainsName() {
        ReadOnlyHttp2Headers headers = ReadOnlyHttp2HeadersTest.newClientHeaders();
        Assert.assertTrue((boolean)headers.contains((Object)"Name1"));
        Assert.assertTrue((boolean)headers.contains((Object)Http2Headers.PseudoHeaderName.PATH.value()));
        Assert.assertFalse((boolean)headers.contains((Object)Http2Headers.PseudoHeaderName.STATUS.value()));
        Assert.assertFalse((boolean)headers.contains((Object)"a missing header"));
    }

    @Test
    public void testContainsNameAndValue() {
        ReadOnlyHttp2Headers headers = ReadOnlyHttp2HeadersTest.newClientHeaders();
        Assert.assertTrue((boolean)headers.contains((Object)"Name1", (Object)"value1"));
        Assert.assertFalse((boolean)headers.contains((Object)"Name1", (Object)"Value1"));
        Assert.assertTrue((boolean)headers.contains((CharSequence)"name2", (CharSequence)"Value2", true));
        Assert.assertFalse((boolean)headers.contains((CharSequence)"name2", (CharSequence)"Value2", false));
        Assert.assertTrue((boolean)headers.contains((Object)Http2Headers.PseudoHeaderName.PATH.value(), (Object)"/foo"));
        Assert.assertFalse((boolean)headers.contains((Object)Http2Headers.PseudoHeaderName.STATUS.value(), (Object)"200"));
        Assert.assertFalse((boolean)headers.contains((Object)"a missing header", (Object)"a missing value"));
    }

    @Test
    public void testGet() {
        ReadOnlyHttp2Headers headers = ReadOnlyHttp2HeadersTest.newClientHeaders();
        Assert.assertTrue((boolean)AsciiString.contentEqualsIgnoreCase((CharSequence)"value1", (CharSequence)((CharSequence)headers.get((Object)"Name1"))));
        Assert.assertTrue((boolean)AsciiString.contentEqualsIgnoreCase((CharSequence)"/foo", (CharSequence)((CharSequence)headers.get((Object)Http2Headers.PseudoHeaderName.PATH.value()))));
        Assert.assertNull((Object)headers.get((Object)Http2Headers.PseudoHeaderName.STATUS.value()));
        Assert.assertNull((Object)headers.get((Object)"a missing header"));
    }

    @Test
    public void testClientOtherValueIterator() {
        ReadOnlyHttp2HeadersTest.testValueIteratorSingleValue((Http2Headers)ReadOnlyHttp2HeadersTest.newClientHeaders(), "name2", "value2");
    }

    @Test
    public void testClientPsuedoValueIterator() {
        ReadOnlyHttp2HeadersTest.testValueIteratorSingleValue((Http2Headers)ReadOnlyHttp2HeadersTest.newClientHeaders(), ":path", "/foo");
    }

    @Test
    public void testServerPsuedoValueIterator() {
        ReadOnlyHttp2HeadersTest.testValueIteratorSingleValue((Http2Headers)ReadOnlyHttp2HeadersTest.newServerHeaders(), ":status", "200");
    }

    @Test
    public void testEmptyValueIterator() {
        ReadOnlyHttp2Headers headers = ReadOnlyHttp2HeadersTest.newServerHeaders();
        Iterator itr = headers.valueIterator((CharSequence)"foo");
        Assert.assertFalse((boolean)itr.hasNext());
        try {
            itr.next();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testIteratorMultipleValues() {
        ReadOnlyHttp2Headers headers = ReadOnlyHttp2Headers.serverHeaders((boolean)false, (AsciiString)new AsciiString((CharSequence)"200"), (AsciiString[])new AsciiString[]{new AsciiString((CharSequence)"name2"), new AsciiString((CharSequence)"value1"), new AsciiString((CharSequence)"name1"), new AsciiString((CharSequence)"value2"), new AsciiString((CharSequence)"name2"), new AsciiString((CharSequence)"value3")});
        Iterator itr = headers.valueIterator((CharSequence)"name2");
        Assert.assertTrue((boolean)itr.hasNext());
        Assert.assertTrue((boolean)AsciiString.contentEqualsIgnoreCase((CharSequence)"value1", (CharSequence)((CharSequence)itr.next())));
        Assert.assertTrue((boolean)itr.hasNext());
        Assert.assertTrue((boolean)AsciiString.contentEqualsIgnoreCase((CharSequence)"value3", (CharSequence)((CharSequence)itr.next())));
        Assert.assertFalse((boolean)itr.hasNext());
    }

    private static void testValueIteratorSingleValue(Http2Headers headers, CharSequence name, CharSequence value) {
        Iterator itr = headers.valueIterator(name);
        Assert.assertTrue((boolean)itr.hasNext());
        Assert.assertTrue((boolean)AsciiString.contentEqualsIgnoreCase((CharSequence)value, (CharSequence)((CharSequence)itr.next())));
        Assert.assertFalse((boolean)itr.hasNext());
    }

    private static void testIteratorReadOnly(Http2Headers headers) {
        Iterator itr = headers.iterator();
        Assert.assertTrue((boolean)itr.hasNext());
        itr.remove();
    }

    private static void testIteratorEntryReadOnly(Http2Headers headers) {
        Iterator itr = headers.iterator();
        Assert.assertTrue((boolean)itr.hasNext());
        ((Map.Entry)itr.next()).setValue("foo");
    }

    private static ReadOnlyHttp2Headers newServerHeaders() {
        return ReadOnlyHttp2Headers.serverHeaders((boolean)false, (AsciiString)new AsciiString((CharSequence)"200"), (AsciiString[])ReadOnlyHttp2HeadersTest.otherHeaders());
    }

    private static ReadOnlyHttp2Headers newClientHeaders() {
        return ReadOnlyHttp2Headers.clientHeaders((boolean)false, (AsciiString)new AsciiString((CharSequence)"meth"), (AsciiString)new AsciiString((CharSequence)"/foo"), (AsciiString)new AsciiString((CharSequence)"schemer"), (AsciiString)new AsciiString((CharSequence)"respect_my_authority"), (AsciiString[])ReadOnlyHttp2HeadersTest.otherHeaders());
    }

    private static ReadOnlyHttp2Headers newTrailers() {
        return ReadOnlyHttp2Headers.trailers((boolean)false, (AsciiString[])ReadOnlyHttp2HeadersTest.otherHeaders());
    }

    private static AsciiString[] otherHeaders() {
        return new AsciiString[]{new AsciiString((CharSequence)"name1"), new AsciiString((CharSequence)"value1"), new AsciiString((CharSequence)"name2"), new AsciiString((CharSequence)"value2"), new AsciiString((CharSequence)"name3"), new AsciiString((CharSequence)"value3")};
    }
}

