/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.Http2FrameAdapter;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2MultiplexCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import org.junit.Assert;
import org.junit.Test;

public class Http2ClientUpgradeCodecTest {
    @Test
    public void testUpgradeToHttp2ConnectionHandler() throws Exception {
        Http2ClientUpgradeCodecTest.testUpgrade(new Http2ConnectionHandlerBuilder().server(false).frameListener((Http2FrameListener)new Http2FrameAdapter()).build(), null);
    }

    @Test
    public void testUpgradeToHttp2FrameCodec() throws Exception {
        Http2ClientUpgradeCodecTest.testUpgrade((Http2ConnectionHandler)Http2FrameCodecBuilder.forClient().build(), null);
    }

    @Test
    public void testUpgradeToHttp2MultiplexCodec() throws Exception {
        Http2ClientUpgradeCodecTest.testUpgrade((Http2ConnectionHandler)Http2MultiplexCodecBuilder.forClient((ChannelHandler)new HttpInboundHandler()).withUpgradeStreamHandler((ChannelHandler)new ChannelInboundHandlerAdapter()).build(), null);
    }

    @Test
    public void testUpgradeToHttp2FrameCodecWithMultiplexer() throws Exception {
        Http2ClientUpgradeCodecTest.testUpgrade((Http2ConnectionHandler)Http2FrameCodecBuilder.forClient().build(), new Http2MultiplexHandler((ChannelHandler)new HttpInboundHandler(), (ChannelHandler)new HttpInboundHandler()));
    }

    private static void testUpgrade(Http2ConnectionHandler handler, Http2MultiplexHandler multiplexer) throws Exception {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.OPTIONS, "*");
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
        ChannelHandlerContext ctx = channel.pipeline().firstContext();
        Http2ClientUpgradeCodec codec = multiplexer == null ? new Http2ClientUpgradeCodec("connectionHandler", handler) : new Http2ClientUpgradeCodec("connectionHandler", handler, multiplexer);
        codec.setUpgradeHeaders(ctx, (HttpRequest)request);
        channel.flush();
        codec.upgradeTo(ctx, null);
        Assert.assertNotNull((Object)channel.pipeline().get("connectionHandler"));
        if (multiplexer != null) {
            Assert.assertNotNull((Object)channel.pipeline().get(Http2MultiplexHandler.class));
        }
        Assert.assertTrue((boolean)channel.finishAndReleaseAll());
    }

    @ChannelHandler.Sharable
    private static final class HttpInboundHandler
    extends ChannelInboundHandlerAdapter {
        private HttpInboundHandler() {
        }
    }
}

