/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.HpackDecoder;
import io.netty.handler.codec.http2.HpackEncoder;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.handler.codec.http2.InOrderHttp2Headers;
import io.netty.util.AsciiString;
import io.netty.util.internal.StringUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class HpackDecoderTest {
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();
    private HpackDecoder hpackDecoder;
    private Http2Headers mockHeaders;

    private static String hex(String s) {
        return StringUtil.toHexString((byte[])s.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decode(String encoded) throws Http2Exception {
        byte[] b = StringUtil.decodeHexDump((CharSequence)encoded);
        ByteBuf in = Unpooled.wrappedBuffer((byte[])b);
        try {
            this.hpackDecoder.decode(0, in, this.mockHeaders, true);
        }
        finally {
            in.release();
        }
    }

    @Before
    public void setUp() {
        this.hpackDecoder = new HpackDecoder(8192L);
        this.mockHeaders = (Http2Headers)Mockito.mock(Http2Headers.class);
    }

    @Test
    public void testDecodeULE128IntMax() throws Http2Exception {
        byte[] input = new byte[]{-1, -1, -1, -1, 7};
        ByteBuf in = Unpooled.wrappedBuffer((byte[])input);
        try {
            Assert.assertEquals((long)Integer.MAX_VALUE, (long)HpackDecoder.decodeULE128((ByteBuf)in, (int)0));
        }
        finally {
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=Http2Exception.class)
    public void testDecodeULE128IntOverflow1() throws Http2Exception {
        byte[] input = new byte[]{-1, -1, -1, -1, 7};
        ByteBuf in = Unpooled.wrappedBuffer((byte[])input);
        int readerIndex = in.readerIndex();
        try {
            HpackDecoder.decodeULE128((ByteBuf)in, (int)1);
        }
        finally {
            Assert.assertEquals((long)readerIndex, (long)in.readerIndex());
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=Http2Exception.class)
    public void testDecodeULE128IntOverflow2() throws Http2Exception {
        byte[] input = new byte[]{-1, -1, -1, -1, 8};
        ByteBuf in = Unpooled.wrappedBuffer((byte[])input);
        int readerIndex = in.readerIndex();
        try {
            HpackDecoder.decodeULE128((ByteBuf)in, (int)0);
        }
        finally {
            Assert.assertEquals((long)readerIndex, (long)in.readerIndex());
            in.release();
        }
    }

    @Test
    public void testDecodeULE128LongMax() throws Http2Exception {
        byte[] input = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 127};
        ByteBuf in = Unpooled.wrappedBuffer((byte[])input);
        try {
            Assert.assertEquals((long)Long.MAX_VALUE, (long)HpackDecoder.decodeULE128((ByteBuf)in, (long)0L));
        }
        finally {
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=Http2Exception.class)
    public void testDecodeULE128LongOverflow1() throws Http2Exception {
        byte[] input = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1};
        ByteBuf in = Unpooled.wrappedBuffer((byte[])input);
        int readerIndex = in.readerIndex();
        try {
            HpackDecoder.decodeULE128((ByteBuf)in, (long)0L);
        }
        finally {
            Assert.assertEquals((long)readerIndex, (long)in.readerIndex());
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=Http2Exception.class)
    public void testDecodeULE128LongOverflow2() throws Http2Exception {
        byte[] input = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 127};
        ByteBuf in = Unpooled.wrappedBuffer((byte[])input);
        int readerIndex = in.readerIndex();
        try {
            HpackDecoder.decodeULE128((ByteBuf)in, (long)1L);
        }
        finally {
            Assert.assertEquals((long)readerIndex, (long)in.readerIndex());
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetTableSizeWithMaxUnsigned32BitValueSucceeds() throws Http2Exception {
        byte[] input = new byte[]{63, -1, -1, -1, -1, 14};
        ByteBuf in = Unpooled.wrappedBuffer((byte[])input);
        try {
            long expectedHeaderSize = 4026531870L;
            this.hpackDecoder.setMaxHeaderTableSize(4026531870L);
            this.hpackDecoder.decode(0, in, this.mockHeaders, true);
            Assert.assertEquals((long)4026531870L, (long)this.hpackDecoder.getMaxHeaderTableSize());
        }
        finally {
            in.release();
        }
    }

    @Test(expected=Http2Exception.class)
    public void testSetTableSizeOverLimitFails() throws Http2Exception {
        byte[] input = new byte[]{63, -1, -1, -1, -1, 14};
        ByteBuf in = Unpooled.wrappedBuffer((byte[])input);
        try {
            this.hpackDecoder.setMaxHeaderTableSize(4026531869L);
            this.hpackDecoder.decode(0, in, this.mockHeaders, true);
        }
        finally {
            in.release();
        }
    }

    @Test
    public void testLiteralHuffmanEncodedWithEmptyNameAndValue() throws Http2Exception {
        byte[] input = new byte[]{0, -128, 0};
        ByteBuf in = Unpooled.wrappedBuffer((byte[])input);
        try {
            this.hpackDecoder.decode(0, in, this.mockHeaders, true);
            ((Http2Headers)Mockito.verify((Object)this.mockHeaders, (VerificationMode)Mockito.times((int)1))).add((Object)AsciiString.EMPTY_STRING, (Object)AsciiString.EMPTY_STRING);
        }
        finally {
            in.release();
        }
    }

    @Test(expected=Http2Exception.class)
    public void testLiteralHuffmanEncodedWithPaddingGreaterThan7Throws() throws Http2Exception {
        byte[] input = new byte[]{0, -127, -1};
        ByteBuf in = Unpooled.wrappedBuffer((byte[])input);
        try {
            this.hpackDecoder.decode(0, in, this.mockHeaders, true);
        }
        finally {
            in.release();
        }
    }

    @Test(expected=Http2Exception.class)
    public void testLiteralHuffmanEncodedWithDecodingEOSThrows() throws Http2Exception {
        byte[] input = new byte[]{0, -124, -1, -1, -1, -1};
        ByteBuf in = Unpooled.wrappedBuffer((byte[])input);
        try {
            this.hpackDecoder.decode(0, in, this.mockHeaders, true);
        }
        finally {
            in.release();
        }
    }

    @Test(expected=Http2Exception.class)
    public void testLiteralHuffmanEncodedWithPaddingNotCorrespondingToMSBThrows() throws Http2Exception {
        byte[] input = new byte[]{0, -127, 0};
        ByteBuf in = Unpooled.wrappedBuffer((byte[])input);
        try {
            this.hpackDecoder.decode(0, in, this.mockHeaders, true);
        }
        finally {
            in.release();
        }
    }

    @Test(expected=Http2Exception.class)
    public void testIncompleteIndex() throws Http2Exception {
        byte[] compressed = StringUtil.decodeHexDump((CharSequence)"FFF0");
        ByteBuf in = Unpooled.wrappedBuffer((byte[])compressed);
        try {
            this.hpackDecoder.decode(0, in, this.mockHeaders, true);
            Assert.assertEquals((long)1L, (long)in.readableBytes());
            this.hpackDecoder.decode(0, in, this.mockHeaders, true);
        }
        finally {
            in.release();
        }
    }

    @Test(expected=Http2Exception.class)
    public void testUnusedIndex() throws Http2Exception {
        this.decode("80");
    }

    @Test(expected=Http2Exception.class)
    public void testIllegalIndex() throws Http2Exception {
        this.decode("FF00");
    }

    @Test(expected=Http2Exception.class)
    public void testInsidiousIndex() throws Http2Exception {
        this.decode("FF8080808007");
    }

    @Test
    public void testDynamicTableSizeUpdate() throws Http2Exception {
        this.decode("20");
        Assert.assertEquals((long)0L, (long)this.hpackDecoder.getMaxHeaderTableSize());
        this.decode("3FE11F");
        Assert.assertEquals((long)4096L, (long)this.hpackDecoder.getMaxHeaderTableSize());
    }

    @Test
    public void testDynamicTableSizeUpdateRequired() throws Http2Exception {
        this.hpackDecoder.setMaxHeaderTableSize(32L);
        this.decode("3F00");
        Assert.assertEquals((long)31L, (long)this.hpackDecoder.getMaxHeaderTableSize());
    }

    @Test(expected=Http2Exception.class)
    public void testIllegalDynamicTableSizeUpdate() throws Http2Exception {
        this.decode("3FE21F");
    }

    @Test(expected=Http2Exception.class)
    public void testInsidiousMaxDynamicTableSize() throws Http2Exception {
        this.hpackDecoder.setMaxHeaderTableSize(Integer.MAX_VALUE);
        this.decode("3FE1FFFFFF07");
    }

    @Test
    public void testMaxValidDynamicTableSize() throws Http2Exception {
        this.hpackDecoder.setMaxHeaderTableSize(Integer.MAX_VALUE);
        String baseValue = "3FE1FFFFFF0";
        for (int i = 0; i < 7; ++i) {
            this.decode(baseValue + i);
        }
    }

    @Test
    public void testReduceMaxDynamicTableSize() throws Http2Exception {
        this.hpackDecoder.setMaxHeaderTableSize(0L);
        Assert.assertEquals((long)0L, (long)this.hpackDecoder.getMaxHeaderTableSize());
        this.decode("2081");
    }

    @Test(expected=Http2Exception.class)
    public void testTooLargeDynamicTableSizeUpdate() throws Http2Exception {
        this.hpackDecoder.setMaxHeaderTableSize(0L);
        Assert.assertEquals((long)0L, (long)this.hpackDecoder.getMaxHeaderTableSize());
        this.decode("21");
    }

    @Test(expected=Http2Exception.class)
    public void testMissingDynamicTableSizeUpdate() throws Http2Exception {
        this.hpackDecoder.setMaxHeaderTableSize(0L);
        Assert.assertEquals((long)0L, (long)this.hpackDecoder.getMaxHeaderTableSize());
        this.decode("81");
    }

    @Test
    public void testLiteralWithIncrementalIndexingWithEmptyName() throws Http2Exception {
        this.decode("400005" + HpackDecoderTest.hex("value"));
        ((Http2Headers)Mockito.verify((Object)this.mockHeaders, (VerificationMode)Mockito.times((int)1))).add((Object)AsciiString.EMPTY_STRING, (Object)AsciiString.of((CharSequence)"value"));
    }

    @Test
    public void testLiteralWithIncrementalIndexingCompleteEviction() throws Http2Exception {
        this.decode("4004" + HpackDecoderTest.hex("name") + "05" + HpackDecoderTest.hex("value"));
        ((Http2Headers)Mockito.verify((Object)this.mockHeaders)).add((Object)AsciiString.of((CharSequence)"name"), (Object)AsciiString.of((CharSequence)"value"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockHeaders});
        Mockito.reset((Object[])new Http2Headers[]{this.mockHeaders});
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4096; ++i) {
            sb.append('a');
        }
        String value = sb.toString();
        sb = new StringBuilder();
        sb.append("417F811F");
        for (int i = 0; i < 4096; ++i) {
            sb.append("61");
        }
        this.decode(sb.toString());
        ((Http2Headers)Mockito.verify((Object)this.mockHeaders)).add((Object)AsciiString.of((CharSequence)":authority"), (Object)AsciiString.of((CharSequence)value));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockHeaders});
        Mockito.reset((Object[])new Http2Headers[]{this.mockHeaders});
        this.decode("4004" + HpackDecoderTest.hex("name") + "05" + HpackDecoderTest.hex("value") + "BE");
        ((Http2Headers)Mockito.verify((Object)this.mockHeaders, (VerificationMode)Mockito.times((int)2))).add((Object)AsciiString.of((CharSequence)"name"), (Object)AsciiString.of((CharSequence)"value"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockHeaders});
    }

    @Test(expected=Http2Exception.class)
    public void testLiteralWithIncrementalIndexingWithLargeValue() throws Http2Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("4004");
        sb.append(HpackDecoderTest.hex("name"));
        sb.append("7F813F");
        for (int i = 0; i < 8192; ++i) {
            sb.append("61");
        }
        this.decode(sb.toString());
    }

    @Test
    public void testLiteralWithoutIndexingWithEmptyName() throws Http2Exception {
        this.decode("000005" + HpackDecoderTest.hex("value"));
        ((Http2Headers)Mockito.verify((Object)this.mockHeaders, (VerificationMode)Mockito.times((int)1))).add((Object)AsciiString.EMPTY_STRING, (Object)AsciiString.of((CharSequence)"value"));
    }

    @Test(expected=Http2Exception.class)
    public void testLiteralWithoutIndexingWithLargeName() throws Http2Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("007F817F");
        for (int i = 0; i < 16384; ++i) {
            sb.append("61");
        }
        sb.append("00");
        this.decode(sb.toString());
    }

    @Test(expected=Http2Exception.class)
    public void testLiteralWithoutIndexingWithLargeValue() throws Http2Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("0004");
        sb.append(HpackDecoderTest.hex("name"));
        sb.append("7F813F");
        for (int i = 0; i < 8192; ++i) {
            sb.append("61");
        }
        this.decode(sb.toString());
    }

    @Test
    public void testLiteralNeverIndexedWithEmptyName() throws Http2Exception {
        this.decode("100005" + HpackDecoderTest.hex("value"));
        ((Http2Headers)Mockito.verify((Object)this.mockHeaders, (VerificationMode)Mockito.times((int)1))).add((Object)AsciiString.EMPTY_STRING, (Object)AsciiString.of((CharSequence)"value"));
    }

    @Test(expected=Http2Exception.class)
    public void testLiteralNeverIndexedWithLargeName() throws Http2Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("107F817F");
        for (int i = 0; i < 16384; ++i) {
            sb.append("61");
        }
        sb.append("00");
        this.decode(sb.toString());
    }

    @Test(expected=Http2Exception.class)
    public void testLiteralNeverIndexedWithLargeValue() throws Http2Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("1004");
        sb.append(HpackDecoderTest.hex("name"));
        sb.append("7F813F");
        for (int i = 0; i < 8192; ++i) {
            sb.append("61");
        }
        this.decode(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecodeLargerThanMaxHeaderListSizeUpdatesDynamicTable() throws Http2Exception {
        ByteBuf in = Unpooled.buffer((int)300);
        try {
            this.hpackDecoder.setMaxHeaderListSize(200L);
            HpackEncoder hpackEncoder = new HpackEncoder(true);
            DefaultHttp2Headers toEncode = new DefaultHttp2Headers();
            toEncode.add((Object)"test_1", (Object)"1");
            toEncode.add((Object)"test_2", (Object)"2");
            toEncode.add((Object)"long", (Object)String.format("%0100d", 0).replace('0', 'A'));
            toEncode.add((Object)"test_3", (Object)"3");
            hpackEncoder.encodeHeaders(1, in, (Http2Headers)toEncode, Http2HeadersEncoder.NEVER_SENSITIVE);
            DefaultHttp2Headers decoded = new DefaultHttp2Headers();
            try {
                this.hpackDecoder.decode(1, in, (Http2Headers)decoded, true);
                Assert.fail();
            }
            catch (Http2Exception e) {
                Assert.assertTrue((boolean)(e instanceof Http2Exception.HeaderListSizeException));
            }
            in.clear();
            in.writeByte(190);
            DefaultHttp2Headers decoded2 = new DefaultHttp2Headers();
            this.hpackDecoder.decode(1, in, (Http2Headers)decoded2, true);
            DefaultHttp2Headers golden = new DefaultHttp2Headers();
            golden.add((Object)"test_3", (Object)"3");
            Assert.assertEquals((Object)golden, (Object)decoded2);
        }
        finally {
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecodeCountsNamesOnlyOnce() throws Http2Exception {
        ByteBuf in = Unpooled.buffer((int)200);
        try {
            this.hpackDecoder.setMaxHeaderListSize(3500L);
            HpackEncoder hpackEncoder = new HpackEncoder(true);
            DefaultHttp2Headers toEncode = new DefaultHttp2Headers();
            toEncode.add((Object)String.format("%03000d", 0).replace('0', 'f'), (Object)"value");
            toEncode.add((Object)"accept", (Object)"value");
            hpackEncoder.encodeHeaders(1, in, (Http2Headers)toEncode, Http2HeadersEncoder.NEVER_SENSITIVE);
            DefaultHttp2Headers decoded = new DefaultHttp2Headers();
            this.hpackDecoder.decode(1, in, (Http2Headers)decoded, true);
            Assert.assertEquals((long)2L, (long)decoded.size());
        }
        finally {
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccountForHeaderOverhead() throws Exception {
        ByteBuf in = Unpooled.buffer((int)100);
        try {
            String headerName = "12345";
            String headerValue = "56789";
            long headerSize = headerName.length() + headerValue.length();
            this.hpackDecoder.setMaxHeaderListSize(headerSize);
            HpackEncoder hpackEncoder = new HpackEncoder(true);
            DefaultHttp2Headers toEncode = new DefaultHttp2Headers();
            toEncode.add((Object)headerName, (Object)headerValue);
            hpackEncoder.encodeHeaders(1, in, (Http2Headers)toEncode, Http2HeadersEncoder.NEVER_SENSITIVE);
            DefaultHttp2Headers decoded = new DefaultHttp2Headers();
            MatcherAssert.assertThat((Object)this.hpackDecoder.getMaxHeaderListSize(), (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(headerSize))));
            this.expectedException.expect(Http2Exception.HeaderListSizeException.class);
            this.hpackDecoder.decode(1, in, (Http2Headers)decoded, true);
        }
        finally {
            in.release();
        }
    }

    @Test
    public void testIncompleteHeaderFieldRepresentation() throws Http2Exception {
        byte[] input = new byte[]{64};
        ByteBuf in = Unpooled.wrappedBuffer((byte[])input);
        try {
            this.expectedException.expect(Http2Exception.class);
            this.hpackDecoder.decode(0, in, this.mockHeaders, true);
        }
        finally {
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void unknownPseudoHeader() throws Exception {
        ByteBuf in = Unpooled.buffer((int)200);
        try {
            HpackEncoder hpackEncoder = new HpackEncoder(true);
            DefaultHttp2Headers toEncode = new DefaultHttp2Headers();
            toEncode.add((Object)":test", (Object)"1");
            hpackEncoder.encodeHeaders(1, in, (Http2Headers)toEncode, Http2HeadersEncoder.NEVER_SENSITIVE);
            DefaultHttp2Headers decoded = new DefaultHttp2Headers();
            this.expectedException.expect(Http2Exception.StreamException.class);
            this.hpackDecoder.decode(1, in, (Http2Headers)decoded, true);
        }
        finally {
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void disableHeaderValidation() throws Exception {
        ByteBuf in = Unpooled.buffer((int)200);
        try {
            HpackEncoder hpackEncoder = new HpackEncoder(true);
            DefaultHttp2Headers toEncode = new DefaultHttp2Headers();
            toEncode.add((Object)":test", (Object)"1");
            toEncode.add((Object)":status", (Object)"200");
            toEncode.add((Object)":method", (Object)"GET");
            hpackEncoder.encodeHeaders(1, in, (Http2Headers)toEncode, Http2HeadersEncoder.NEVER_SENSITIVE);
            DefaultHttp2Headers decoded = new DefaultHttp2Headers();
            this.hpackDecoder.decode(1, in, (Http2Headers)decoded, false);
            MatcherAssert.assertThat((Object)((CharSequence)decoded.valueIterator((CharSequence)":test").next()).toString(), (Matcher)CoreMatchers.is((Object)"1"));
            MatcherAssert.assertThat((Object)decoded.status().toString(), (Matcher)CoreMatchers.is((Object)"200"));
            MatcherAssert.assertThat((Object)decoded.method().toString(), (Matcher)CoreMatchers.is((Object)"GET"));
        }
        finally {
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void requestPseudoHeaderInResponse() throws Exception {
        ByteBuf in = Unpooled.buffer((int)200);
        try {
            HpackEncoder hpackEncoder = new HpackEncoder(true);
            DefaultHttp2Headers toEncode = new DefaultHttp2Headers();
            toEncode.add((Object)":status", (Object)"200");
            toEncode.add((Object)":method", (Object)"GET");
            hpackEncoder.encodeHeaders(1, in, (Http2Headers)toEncode, Http2HeadersEncoder.NEVER_SENSITIVE);
            DefaultHttp2Headers decoded = new DefaultHttp2Headers();
            this.expectedException.expect(Http2Exception.StreamException.class);
            this.hpackDecoder.decode(1, in, (Http2Headers)decoded, true);
        }
        finally {
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void responsePseudoHeaderInRequest() throws Exception {
        ByteBuf in = Unpooled.buffer((int)200);
        try {
            HpackEncoder hpackEncoder = new HpackEncoder(true);
            DefaultHttp2Headers toEncode = new DefaultHttp2Headers();
            toEncode.add((Object)":method", (Object)"GET");
            toEncode.add((Object)":status", (Object)"200");
            hpackEncoder.encodeHeaders(1, in, (Http2Headers)toEncode, Http2HeadersEncoder.NEVER_SENSITIVE);
            DefaultHttp2Headers decoded = new DefaultHttp2Headers();
            this.expectedException.expect(Http2Exception.StreamException.class);
            this.hpackDecoder.decode(1, in, (Http2Headers)decoded, true);
        }
        finally {
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void pseudoHeaderAfterRegularHeader() throws Exception {
        ByteBuf in = Unpooled.buffer((int)200);
        try {
            HpackEncoder hpackEncoder = new HpackEncoder(true);
            InOrderHttp2Headers toEncode = new InOrderHttp2Headers();
            toEncode.add("test", "1");
            toEncode.add(":method", "GET");
            hpackEncoder.encodeHeaders(1, in, (Http2Headers)toEncode, Http2HeadersEncoder.NEVER_SENSITIVE);
            DefaultHttp2Headers decoded = new DefaultHttp2Headers();
            this.expectedException.expect(Http2Exception.StreamException.class);
            this.hpackDecoder.decode(1, in, (Http2Headers)decoded, true);
        }
        finally {
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void failedValidationDoesntCorruptHpack() throws Exception {
        ByteBuf in1 = Unpooled.buffer((int)200);
        ByteBuf in2 = Unpooled.buffer((int)200);
        try {
            HpackEncoder hpackEncoder = new HpackEncoder(true);
            DefaultHttp2Headers toEncode = new DefaultHttp2Headers();
            toEncode.add((Object)":method", (Object)"GET");
            toEncode.add((Object)":status", (Object)"200");
            toEncode.add((Object)"foo", (Object)"bar");
            hpackEncoder.encodeHeaders(1, in1, (Http2Headers)toEncode, Http2HeadersEncoder.NEVER_SENSITIVE);
            DefaultHttp2Headers decoded = new DefaultHttp2Headers();
            try {
                this.hpackDecoder.decode(1, in1, (Http2Headers)decoded, true);
                Assert.fail((String)"Should have thrown a StreamException");
            }
            catch (Http2Exception.StreamException expected) {
                Assert.assertEquals((long)1L, (long)expected.streamId());
            }
            decoded.clear();
            hpackEncoder.encodeHeaders(1, in2, (Http2Headers)toEncode, Http2HeadersEncoder.NEVER_SENSITIVE);
            this.hpackDecoder.decode(1, in2, (Http2Headers)decoded, false);
            Assert.assertEquals((long)3L, (long)decoded.size());
            Assert.assertEquals((Object)"GET", (Object)decoded.method().toString());
            Assert.assertEquals((Object)"200", (Object)decoded.status().toString());
            Assert.assertEquals((Object)"bar", (Object)((CharSequence)decoded.get((Object)"foo")).toString());
        }
        finally {
            in1.release();
            in2.release();
        }
    }
}

