/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.Headers;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class DefaultHttp2HeadersTest {
    @Test(expected=Http2Exception.class)
    public void nullHeaderNameNotAllowed() {
        new DefaultHttp2Headers().add(null, (Object)"foo");
    }

    @Test(expected=Http2Exception.class)
    public void emptyHeaderNameNotAllowed() {
        new DefaultHttp2Headers().add((Object)"", (Object)"foo");
    }

    @Test
    public void testPseudoHeadersMustComeFirstWhenIterating() {
        Http2Headers headers = DefaultHttp2HeadersTest.newHeaders();
        DefaultHttp2HeadersTest.verifyPseudoHeadersFirst(headers);
        DefaultHttp2HeadersTest.verifyAllPseudoHeadersPresent(headers);
    }

    @Test
    public void testPseudoHeadersWithRemovePreservesPseudoIterationOrder() {
        Http2Headers headers = DefaultHttp2HeadersTest.newHeaders();
        DefaultHttp2Headers nonPseudoHeaders = new DefaultHttp2Headers();
        for (Map.Entry entry : headers) {
            if (((CharSequence)entry.getKey()).length() != 0 && (((CharSequence)entry.getKey()).charAt(0) == ':' || nonPseudoHeaders.contains(entry.getKey()))) continue;
            nonPseudoHeaders.add(entry.getKey(), entry.getValue());
        }
        Assert.assertFalse((boolean)nonPseudoHeaders.isEmpty());
        for (Map.Entry nonPseudoHeaderEntry : nonPseudoHeaders) {
            Assert.assertTrue((boolean)headers.remove(nonPseudoHeaderEntry.getKey()));
            DefaultHttp2HeadersTest.verifyPseudoHeadersFirst(headers);
            DefaultHttp2HeadersTest.verifyAllPseudoHeadersPresent(headers);
        }
        for (Map.Entry nonPseudoHeaderEntry : nonPseudoHeaders) {
            headers.add(nonPseudoHeaderEntry.getKey(), (Object)AsciiString.of((CharSequence)"goo"));
            DefaultHttp2HeadersTest.verifyPseudoHeadersFirst(headers);
            DefaultHttp2HeadersTest.verifyAllPseudoHeadersPresent(headers);
        }
    }

    @Test
    public void testPseudoHeadersWithClearDoesNotLeak() {
        Http2Headers headers = DefaultHttp2HeadersTest.newHeaders();
        Assert.assertFalse((boolean)headers.isEmpty());
        headers.clear();
        Assert.assertTrue((boolean)headers.isEmpty());
        ((Http2Headers)headers.add((Object)"name1", (Object)"value1")).scheme((CharSequence)"nothing");
        DefaultHttp2HeadersTest.verifyPseudoHeadersFirst(headers);
        Http2Headers other = ((Http2Headers)new DefaultHttp2Headers().add((Object)"name2", (Object)"value2")).authority((CharSequence)"foo");
        DefaultHttp2HeadersTest.verifyPseudoHeadersFirst(other);
        headers.add((Headers)other);
        DefaultHttp2HeadersTest.verifyPseudoHeadersFirst(headers);
        Assert.assertEquals((long)4L, (long)headers.size());
        Assert.assertEquals((Object)"value1", (Object)headers.get((Object)"name1"));
        Assert.assertEquals((Object)"value2", (Object)headers.get((Object)"name2"));
        Assert.assertEquals((Object)"nothing", (Object)headers.scheme());
        Assert.assertEquals((Object)"foo", (Object)headers.authority());
    }

    @Test
    public void testSetHeadersOrdersPseudoHeadersCorrectly() {
        Http2Headers headers = DefaultHttp2HeadersTest.newHeaders();
        Http2Headers other = ((Http2Headers)new DefaultHttp2Headers().add((Object)"name2", (Object)"value2")).authority((CharSequence)"foo");
        headers.set((Headers)other);
        DefaultHttp2HeadersTest.verifyPseudoHeadersFirst(headers);
        Assert.assertEquals((long)other.size(), (long)headers.size());
        Assert.assertEquals((Object)"foo", (Object)headers.authority());
        Assert.assertEquals((Object)"value2", (Object)headers.get((Object)"name2"));
    }

    @Test
    public void testSetAllOrdersPseudoHeadersCorrectly() {
        Http2Headers headers = DefaultHttp2HeadersTest.newHeaders();
        Http2Headers other = ((Http2Headers)new DefaultHttp2Headers().add((Object)"name2", (Object)"value2")).authority((CharSequence)"foo");
        int headersSizeBefore = headers.size();
        headers.setAll((Headers)other);
        DefaultHttp2HeadersTest.verifyPseudoHeadersFirst(headers);
        DefaultHttp2HeadersTest.verifyAllPseudoHeadersPresent(headers);
        Assert.assertEquals((long)(headersSizeBefore + 1), (long)headers.size());
        Assert.assertEquals((Object)"foo", (Object)headers.authority());
        Assert.assertEquals((Object)"value2", (Object)headers.get((Object)"name2"));
    }

    @Test(expected=Http2Exception.class)
    public void testHeaderNameValidation() {
        Http2Headers headers = DefaultHttp2HeadersTest.newHeaders();
        headers.add((Object)AsciiString.of((CharSequence)"Foo"), (Object)AsciiString.of((CharSequence)"foo"));
    }

    @Test
    public void testClearResetsPseudoHeaderDivision() {
        DefaultHttp2Headers http2Headers = new DefaultHttp2Headers();
        http2Headers.method((CharSequence)"POST");
        http2Headers.set((Object)"some", (Object)"value");
        http2Headers.clear();
        http2Headers.method((CharSequence)"GET");
        Assert.assertEquals((long)1L, (long)http2Headers.names().size());
    }

    @Test
    public void testContainsNameAndValue() {
        Http2Headers headers = DefaultHttp2HeadersTest.newHeaders();
        Assert.assertTrue((boolean)headers.contains((Object)"name1", (Object)"value2"));
        Assert.assertFalse((boolean)headers.contains((Object)"name1", (Object)"Value2"));
        Assert.assertTrue((boolean)headers.contains((CharSequence)"2name", (CharSequence)"Value3", true));
        Assert.assertFalse((boolean)headers.contains((CharSequence)"2name", (CharSequence)"Value3", false));
    }

    private static void verifyAllPseudoHeadersPresent(Http2Headers headers) {
        for (Http2Headers.PseudoHeaderName pseudoName : Http2Headers.PseudoHeaderName.values()) {
            Assert.assertNotNull((Object)headers.get((Object)pseudoName.value()));
        }
    }

    static void verifyPseudoHeadersFirst(Http2Headers headers) {
        CharSequence lastNonPseudoName = null;
        for (Map.Entry entry : headers) {
            if (((CharSequence)entry.getKey()).length() == 0 || ((CharSequence)entry.getKey()).charAt(0) != ':') {
                lastNonPseudoName = (CharSequence)entry.getKey();
                continue;
            }
            if (lastNonPseudoName == null) continue;
            Assert.fail((String)("All pseudo headers must be fist in iteration. Pseudo header " + entry.getKey() + " is after a non pseudo header " + lastNonPseudoName));
        }
    }

    private static Http2Headers newHeaders() {
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        headers.add((Object)AsciiString.of((CharSequence)"name1"), (Object[])new CharSequence[]{AsciiString.of((CharSequence)"value1"), AsciiString.of((CharSequence)"value2")});
        headers.method((CharSequence)AsciiString.of((CharSequence)"POST"));
        headers.add((Object)AsciiString.of((CharSequence)"2name"), (Object)AsciiString.of((CharSequence)"value3"));
        headers.path((CharSequence)AsciiString.of((CharSequence)"/index.html"));
        headers.status((CharSequence)AsciiString.of((CharSequence)"200"));
        headers.authority((CharSequence)AsciiString.of((CharSequence)"netty.io"));
        headers.add((Object)AsciiString.of((CharSequence)"name3"), (Object)AsciiString.of((CharSequence)"value4"));
        headers.scheme((CharSequence)AsciiString.of((CharSequence)"https"));
        return headers;
    }
}

