/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class Http2SecurityUtilTest {
    @Test
    public void testTLSv13CiphersIncluded() throws SSLException {
        Assume.assumeTrue((boolean)SslProvider.isTlsv13Supported((SslProvider)SslProvider.JDK));
        Http2SecurityUtilTest.testCiphersIncluded("TLSv1.3");
    }

    @Test
    public void testTLSv12CiphersIncluded() throws SSLException {
        Http2SecurityUtilTest.testCiphersIncluded("TLSv1.2");
    }

    private static void testCiphersIncluded(String protocol) throws SSLException {
        SslContext context = SslContextBuilder.forClient().sslProvider(SslProvider.JDK).protocols(new String[]{protocol}).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).build();
        SSLEngine engine = context.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assert.assertTrue((String)("No " + protocol + " ciphers found"), (engine.getEnabledCipherSuites().length > 0 ? 1 : 0) != 0);
    }
}

