/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.DefaultHttp2PingFrame;
import io.netty.handler.codec.http2.DefaultHttp2UnknownFrame;
import io.netty.handler.codec.http2.DefaultHttp2WindowUpdateFrame;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FlowController;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameInboundWriter;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2NoMoreStreamIdsException;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2SettingsAckFrame;
import io.netty.handler.codec.http2.Http2SettingsFrame;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.handler.codec.http2.Http2StreamFrame;
import io.netty.handler.codec.http2.Http2TestUtil;
import io.netty.handler.codec.http2.Http2WindowUpdateFrame;
import io.netty.handler.codec.http2.LastInboundHandler;
import io.netty.handler.codec.http2.TestChannelInitializer;
import io.netty.util.AsciiString;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public abstract class Http2MultiplexTest<C extends Http2FrameCodec> {
    private final Http2Headers request = new DefaultHttp2Headers().method((CharSequence)HttpMethod.GET.asciiName()).scheme((CharSequence)HttpScheme.HTTPS.name()).authority((CharSequence)new AsciiString((CharSequence)"example.org")).path((CharSequence)new AsciiString((CharSequence)"/foo"));
    private EmbeddedChannel parentChannel;
    private Http2FrameWriter frameWriter;
    private Http2FrameInboundWriter frameInboundWriter;
    private TestChannelInitializer childChannelInitializer;
    private C codec;
    private static final int initialRemoteStreamWindow = 1024;

    protected abstract C newCodec(TestChannelInitializer var1, Http2FrameWriter var2);

    protected abstract ChannelHandler newMultiplexer(TestChannelInitializer var1);

    @Before
    public void setUp() {
        this.childChannelInitializer = new TestChannelInitializer();
        this.parentChannel = new EmbeddedChannel();
        this.frameInboundWriter = new Http2FrameInboundWriter(this.parentChannel);
        this.parentChannel.connect((SocketAddress)new InetSocketAddress(0));
        this.frameWriter = Http2TestUtil.mockedFrameWriter();
        this.codec = this.newCodec(this.childChannelInitializer, this.frameWriter);
        this.parentChannel.pipeline().addLast(new ChannelHandler[]{this.codec});
        ChannelHandler multiplexer = this.newMultiplexer(this.childChannelInitializer);
        if (multiplexer != null) {
            this.parentChannel.pipeline().addLast(new ChannelHandler[]{multiplexer});
        }
        this.parentChannel.runPendingTasks();
        this.parentChannel.pipeline().fireChannelActive();
        this.parentChannel.writeInbound(new Object[]{Http2CodecUtil.connectionPrefaceBuf()});
        Http2Settings settings = new Http2Settings().initialWindowSize(1024);
        this.frameInboundWriter.writeInboundSettings(settings);
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeSettingsAck(this.eqCodecCtx(), Http2TestUtil.anyChannelPromise());
        this.frameInboundWriter.writeInboundSettingsAck();
        Http2SettingsFrame settingsFrame = (Http2SettingsFrame)this.parentChannel.readInbound();
        Assert.assertNotNull((Object)settingsFrame);
        Http2SettingsAckFrame settingsAckFrame = (Http2SettingsAckFrame)this.parentChannel.readInbound();
        Assert.assertNotNull((Object)settingsAckFrame);
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeSettings(this.eqCodecCtx(), Http2TestUtil.anyHttp2Settings(), Http2TestUtil.anyChannelPromise());
    }

    private ChannelHandlerContext eqCodecCtx() {
        return (ChannelHandlerContext)ArgumentMatchers.eq((Object)((Http2FrameCodec)this.codec).ctx);
    }

    @After
    public void tearDown() throws Exception {
        if (this.childChannelInitializer.handler instanceof LastInboundHandler) {
            ((LastInboundHandler)this.childChannelInitializer.handler).finishAndReleaseAll();
        }
        this.parentChannel.finishAndReleaseAll();
        this.codec = null;
    }

    @Test
    public void writeUnknownFrame() {
        Http2StreamChannel childChannel = this.newOutboundStream((ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext ctx) {
                ctx.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()));
                ctx.writeAndFlush((Object)new DefaultHttp2UnknownFrame(99, new Http2Flags()));
                ctx.fireChannelActive();
            }
        });
        Assert.assertTrue((boolean)childChannel.isActive());
        this.parentChannel.runPendingTasks();
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeFrame((ChannelHandlerContext)ArgumentMatchers.eq((Object)((Http2FrameCodec)this.codec).ctx), ArgumentMatchers.eq((byte)99), Http2MultiplexTest.eqStreamId(childChannel), (Http2Flags)ArgumentMatchers.any(Http2Flags.class), (ByteBuf)ArgumentMatchers.any(ByteBuf.class), (ChannelPromise)ArgumentMatchers.any(ChannelPromise.class));
    }

    private Http2StreamChannel newInboundStream(int streamId, boolean endStream, ChannelHandler childHandler) {
        return this.newInboundStream(streamId, endStream, null, childHandler);
    }

    private Http2StreamChannel newInboundStream(int streamId, boolean endStream, AtomicInteger maxReads, final ChannelHandler childHandler) {
        final AtomicReference streamChannelRef = new AtomicReference();
        this.childChannelInitializer.maxReads = maxReads;
        this.childChannelInitializer.handler = new ChannelInboundHandlerAdapter(){

            public void channelRegistered(ChannelHandlerContext ctx) {
                Assert.assertNull(streamChannelRef.get());
                streamChannelRef.set((Http2StreamChannel)ctx.channel());
                ctx.pipeline().addLast(new ChannelHandler[]{childHandler});
                ctx.fireChannelRegistered();
            }
        };
        this.frameInboundWriter.writeInboundHeaders(streamId, this.request, 0, endStream);
        this.parentChannel.runPendingTasks();
        Http2StreamChannel channel = (Http2StreamChannel)streamChannelRef.get();
        Assert.assertEquals((long)streamId, (long)channel.stream().id());
        return channel;
    }

    @Test
    public void readUnkownFrame() {
        LastInboundHandler handler = new LastInboundHandler();
        Http2StreamChannel channel = this.newInboundStream(3, true, (ChannelHandler)handler);
        this.frameInboundWriter.writeInboundFrame((byte)99, channel.stream().id(), new Http2Flags(), Unpooled.EMPTY_BUFFER);
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(channel, handler, 2);
        Http2StreamChannel childChannel = this.newOutboundStream((ChannelHandler)new ChannelInboundHandlerAdapter());
        Assert.assertTrue((boolean)childChannel.isActive());
    }

    @Test
    public void headerAndDataFramesShouldBeDelivered() {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel channel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        DefaultHttp2HeadersFrame headersFrame = new DefaultHttp2HeadersFrame(this.request).stream(channel.stream());
        DefaultHttp2DataFrame dataFrame1 = new DefaultHttp2DataFrame(Http2TestUtil.bb("hello")).stream(channel.stream());
        DefaultHttp2DataFrame dataFrame2 = new DefaultHttp2DataFrame(Http2TestUtil.bb("world")).stream(channel.stream());
        Assert.assertTrue((boolean)inboundHandler.isChannelActive());
        this.frameInboundWriter.writeInboundData(channel.stream().id(), Http2TestUtil.bb("hello"), 0, false);
        this.frameInboundWriter.writeInboundData(channel.stream().id(), Http2TestUtil.bb("world"), 0, false);
        Assert.assertEquals((Object)headersFrame, inboundHandler.readInbound());
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame1, (Http2Frame)inboundHandler.readInbound());
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame2, (Http2Frame)inboundHandler.readInbound());
        Assert.assertNull(inboundHandler.readInbound());
    }

    @Test
    public void framesShouldBeMultiplexed() {
        LastInboundHandler handler1 = new LastInboundHandler();
        Http2StreamChannel channel1 = this.newInboundStream(3, false, (ChannelHandler)handler1);
        LastInboundHandler handler2 = new LastInboundHandler();
        Http2StreamChannel channel2 = this.newInboundStream(5, false, (ChannelHandler)handler2);
        LastInboundHandler handler3 = new LastInboundHandler();
        Http2StreamChannel channel3 = this.newInboundStream(11, false, (ChannelHandler)handler3);
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(channel1, handler1, 1);
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(channel2, handler2, 1);
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(channel3, handler3, 1);
        this.frameInboundWriter.writeInboundData(channel2.stream().id(), Http2TestUtil.bb("hello"), 0, false);
        this.frameInboundWriter.writeInboundData(channel1.stream().id(), Http2TestUtil.bb("foo"), 0, true);
        this.frameInboundWriter.writeInboundData(channel2.stream().id(), Http2TestUtil.bb("world"), 0, true);
        this.frameInboundWriter.writeInboundData(channel3.stream().id(), Http2TestUtil.bb("bar"), 0, true);
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(channel1, handler1, 1);
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(channel2, handler2, 2);
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(channel3, handler3, 1);
    }

    @Test
    public void inboundDataFrameShouldUpdateLocalFlowController() throws Http2Exception {
        Http2LocalFlowController flowController = (Http2LocalFlowController)Mockito.mock(Http2LocalFlowController.class);
        this.codec.connection().local().flowController((Http2FlowController)flowController);
        LastInboundHandler handler = new LastInboundHandler();
        final Http2StreamChannel channel = this.newInboundStream(3, false, (ChannelHandler)handler);
        ByteBuf tenBytes = Http2TestUtil.bb("0123456789");
        this.frameInboundWriter.writeInboundData(channel.stream().id(), tenBytes, 0, true);
        ((Http2LocalFlowController)Mockito.verify((Object)flowController)).consumeBytes((Http2Stream)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<Http2Stream>(){

            public boolean matches(Http2Stream http2Stream) {
                return http2Stream.id() == channel.stream().id();
            }
        }), ArgumentMatchers.eq((int)10));
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(channel, handler, 2);
    }

    @Test
    public void unhandledHttp2FramesShouldBePropagated() {
        DefaultHttp2PingFrame pingFrame = new DefaultHttp2PingFrame(0L);
        this.frameInboundWriter.writeInboundPing(false, 0L);
        Assert.assertEquals((Object)this.parentChannel.readInbound(), (Object)pingFrame);
        DefaultHttp2GoAwayFrame goAwayFrame = new DefaultHttp2GoAwayFrame(1L, this.parentChannel.alloc().buffer().writeLong(8L));
        this.frameInboundWriter.writeInboundGoAway(0, goAwayFrame.errorCode(), goAwayFrame.content().retainedDuplicate());
        Http2GoAwayFrame frame = (Http2GoAwayFrame)this.parentChannel.readInbound();
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)frame, (Http2Frame)goAwayFrame);
    }

    @Test
    public void channelReadShouldRespectAutoRead() {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        Assert.assertTrue((boolean)childChannel.config().isAutoRead());
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)inboundHandler.readInbound();
        Assert.assertNotNull((Object)headersFrame);
        childChannel.config().setAutoRead(false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("hello world"), 0, false);
        Http2DataFrame dataFrame0 = (Http2DataFrame)inboundHandler.readInbound();
        Assert.assertNotNull((Object)dataFrame0);
        ReferenceCountUtil.release((Object)dataFrame0);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("foo"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("bar"), 0, false);
        Assert.assertNull(inboundHandler.readInbound());
        childChannel.config().setAutoRead(true);
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(childChannel, inboundHandler, 2);
    }

    @Test
    public void channelReadShouldRespectAutoReadAndNotProduceNPE() throws Exception {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        Assert.assertTrue((boolean)childChannel.config().isAutoRead());
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)inboundHandler.readInbound();
        Assert.assertNotNull((Object)headersFrame);
        childChannel.config().setAutoRead(false);
        childChannel.pipeline().addFirst(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){
            private int count;

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                ctx.fireChannelRead(msg);
                if (++this.count == 2) {
                    ctx.close();
                }
            }
        }});
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("hello world"), 0, false);
        Http2DataFrame dataFrame0 = (Http2DataFrame)inboundHandler.readInbound();
        Assert.assertNotNull((Object)dataFrame0);
        ReferenceCountUtil.release((Object)dataFrame0);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("foo"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("bar"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("bar"), 0, false);
        Assert.assertNull(inboundHandler.readInbound());
        childChannel.config().setAutoRead(true);
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(childChannel, inboundHandler, 3);
        inboundHandler.checkException();
    }

    @Test
    public void readInChannelReadWithoutAutoRead() {
        this.useReadWithoutAutoRead(false);
    }

    @Test
    public void readInChannelReadCompleteWithoutAutoRead() {
        this.useReadWithoutAutoRead(true);
    }

    private void useReadWithoutAutoRead(final boolean readComplete) {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        Assert.assertTrue((boolean)childChannel.config().isAutoRead());
        childChannel.config().setAutoRead(false);
        Assert.assertFalse((boolean)childChannel.config().isAutoRead());
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)inboundHandler.readInbound();
        Assert.assertNotNull((Object)headersFrame);
        childChannel.pipeline().addFirst(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                ctx.fireChannelRead(msg);
                if (!readComplete) {
                    ctx.read();
                }
            }

            public void channelReadComplete(ChannelHandlerContext ctx) {
                ctx.fireChannelReadComplete();
                if (readComplete) {
                    ctx.read();
                }
            }
        }});
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("hello world"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("foo"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("bar"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("hello world"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("foo"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("bar"), 0, true);
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(childChannel, inboundHandler, 6);
    }

    private Http2StreamChannel newOutboundStream(ChannelHandler handler) {
        return (Http2StreamChannel)new Http2StreamChannelBootstrap((Channel)this.parentChannel).handler(handler).open().syncUninterruptibly().getNow();
    }

    @Test
    public void idleOutboundStreamShouldNotWriteResetFrameOnClose() {
        LastInboundHandler handler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newOutboundStream((ChannelHandler)handler);
        Assert.assertTrue((boolean)childChannel.isActive());
        childChannel.close();
        this.parentChannel.runPendingTasks();
        Assert.assertFalse((boolean)childChannel.isOpen());
        Assert.assertFalse((boolean)childChannel.isActive());
        Assert.assertNull((Object)this.parentChannel.readOutbound());
    }

    @Test
    public void outboundStreamShouldWriteResetFrameOnClose_headersSent() {
        ChannelInboundHandlerAdapter handler = new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext ctx) {
                ctx.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()));
                ctx.fireChannelActive();
            }
        };
        Http2StreamChannel childChannel = this.newOutboundStream((ChannelHandler)handler);
        Assert.assertTrue((boolean)childChannel.isActive());
        childChannel.close();
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeRstStream(this.eqCodecCtx(), Http2MultiplexTest.eqStreamId(childChannel), ArgumentMatchers.eq((long)Http2Error.CANCEL.code()), Http2TestUtil.anyChannelPromise());
    }

    @Test
    public void outboundStreamShouldNotWriteResetFrameOnClose_IfStreamDidntExist() {
        Mockito.when((Object)this.frameWriter.writeHeaders(this.eqCodecCtx(), ArgumentMatchers.anyInt(), (Http2Headers)ArgumentMatchers.any(Http2Headers.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean(), (ChannelPromise)ArgumentMatchers.any(ChannelPromise.class))).thenAnswer((Answer)new Answer<ChannelFuture>(){
            private boolean headersWritten;

            public ChannelFuture answer(InvocationOnMock invocationOnMock) {
                if (!this.headersWritten) {
                    this.headersWritten = true;
                    return ((ChannelPromise)invocationOnMock.getArgument(5)).setFailure((Throwable)new Exception("boom"));
                }
                return ((ChannelPromise)invocationOnMock.getArgument(5)).setSuccess();
            }
        });
        Http2StreamChannel childChannel = this.newOutboundStream((ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext ctx) {
                ctx.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()));
                ctx.fireChannelActive();
            }
        });
        Assert.assertFalse((boolean)childChannel.isActive());
        childChannel.close();
        this.parentChannel.runPendingTasks();
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter, (VerificationMode)Mockito.never())).writeRstStream(this.eqCodecCtx(), Http2MultiplexTest.eqStreamId(childChannel), ArgumentMatchers.anyLong(), Http2TestUtil.anyChannelPromise());
        Assert.assertTrue((boolean)this.parentChannel.outboundMessages().isEmpty());
    }

    @Test
    public void inboundRstStreamFireChannelInactive() {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel channel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        Assert.assertTrue((boolean)inboundHandler.isChannelActive());
        this.frameInboundWriter.writeInboundRstStream(channel.stream().id(), Http2Error.INTERNAL_ERROR.code());
        Assert.assertFalse((boolean)inboundHandler.isChannelActive());
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter, (VerificationMode)Mockito.never())).writeRstStream(this.eqCodecCtx(), Http2MultiplexTest.eqStreamId(channel), ArgumentMatchers.anyLong(), Http2TestUtil.anyChannelPromise());
    }

    @Test(expected=Http2Exception.StreamException.class)
    public void streamExceptionTriggersChildChannelExceptionAndClose() throws Exception {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel channel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        Assert.assertTrue((boolean)channel.isActive());
        Http2Exception.StreamException cause = new Http2Exception.StreamException(channel.stream().id(), Http2Error.PROTOCOL_ERROR, "baaam!");
        this.parentChannel.pipeline().fireExceptionCaught((Throwable)cause);
        Assert.assertFalse((boolean)channel.isActive());
        inboundHandler.checkException();
    }

    @Test(expected=ClosedChannelException.class)
    public void streamClosedErrorTranslatedToClosedChannelExceptionOnWrites() throws Exception {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        final Http2StreamChannel childChannel = this.newOutboundStream((ChannelHandler)inboundHandler);
        Assert.assertTrue((boolean)childChannel.isActive());
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        Mockito.when((Object)this.frameWriter.writeHeaders(this.eqCodecCtx(), ArgumentMatchers.anyInt(), (Http2Headers)ArgumentMatchers.eq((Object)headers), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean(), (ChannelPromise)ArgumentMatchers.any(ChannelPromise.class))).thenAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocationOnMock) {
                return ((ChannelPromise)invocationOnMock.getArgument(5)).setFailure((Throwable)new Http2Exception.StreamException(childChannel.stream().id(), Http2Error.STREAM_CLOSED, "Stream Closed"));
            }
        });
        ChannelFuture future = childChannel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()));
        this.parentChannel.flush();
        Assert.assertFalse((boolean)childChannel.isActive());
        Assert.assertFalse((boolean)childChannel.isOpen());
        inboundHandler.checkException();
        future.syncUninterruptibly();
    }

    @Test
    public void creatingWritingReadingAndClosingOutboundStreamShouldWork() {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newOutboundStream((ChannelHandler)inboundHandler);
        Assert.assertTrue((boolean)childChannel.isActive());
        Assert.assertTrue((boolean)inboundHandler.isChannelActive());
        Http2Headers headers = new DefaultHttp2Headers().scheme((CharSequence)"https").method((CharSequence)"GET").path((CharSequence)"/foo.txt");
        childChannel.writeAndFlush((Object)new DefaultHttp2HeadersFrame(headers));
        this.frameInboundWriter.writeInboundHeaders(childChannel.stream().id(), headers, 0, false);
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)inboundHandler.readInbound();
        Assert.assertNotNull((Object)headersFrame);
        Assert.assertEquals((Object)headers, (Object)headersFrame.headers());
        childChannel.close();
        this.parentChannel.runPendingTasks();
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeRstStream(this.eqCodecCtx(), Http2MultiplexTest.eqStreamId(childChannel), ArgumentMatchers.anyLong(), Http2TestUtil.anyChannelPromise());
        Assert.assertFalse((boolean)childChannel.isOpen());
        Assert.assertFalse((boolean)childChannel.isActive());
        Assert.assertFalse((boolean)inboundHandler.isChannelActive());
    }

    @Test(expected=Http2NoMoreStreamIdsException.class)
    public void failedOutboundStreamCreationThrowsAndClosesChannel() throws Exception {
        LastInboundHandler handler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newOutboundStream((ChannelHandler)handler);
        Assert.assertTrue((boolean)childChannel.isActive());
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        Mockito.when((Object)this.frameWriter.writeHeaders(this.eqCodecCtx(), ArgumentMatchers.anyInt(), (Http2Headers)ArgumentMatchers.eq((Object)headers), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean(), (ChannelPromise)ArgumentMatchers.any(ChannelPromise.class))).thenAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocationOnMock) {
                return ((ChannelPromise)invocationOnMock.getArgument(5)).setFailure((Throwable)new Http2NoMoreStreamIdsException());
            }
        });
        ChannelFuture future = childChannel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)headers));
        this.parentChannel.flush();
        Assert.assertFalse((boolean)childChannel.isActive());
        Assert.assertFalse((boolean)childChannel.isOpen());
        handler.checkException();
        future.syncUninterruptibly();
    }

    @Test
    public void channelClosedWhenCloseListenerCompletes() {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        Assert.assertTrue((boolean)childChannel.isOpen());
        Assert.assertTrue((boolean)childChannel.isActive());
        final AtomicBoolean channelOpen = new AtomicBoolean(true);
        final AtomicBoolean channelActive = new AtomicBoolean(true);
        ChannelPromise p = childChannel.newPromise();
        p.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                channelOpen.set(future.channel().isOpen());
                channelActive.set(future.channel().isActive());
            }
        });
        childChannel.close(p).syncUninterruptibly();
        Assert.assertFalse((boolean)channelOpen.get());
        Assert.assertFalse((boolean)channelActive.get());
        Assert.assertFalse((boolean)childChannel.isActive());
    }

    @Test
    public void channelClosedWhenChannelClosePromiseCompletes() {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        Assert.assertTrue((boolean)childChannel.isOpen());
        Assert.assertTrue((boolean)childChannel.isActive());
        final AtomicBoolean channelOpen = new AtomicBoolean(true);
        final AtomicBoolean channelActive = new AtomicBoolean(true);
        childChannel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                channelOpen.set(future.channel().isOpen());
                channelActive.set(future.channel().isActive());
            }
        });
        childChannel.close().syncUninterruptibly();
        Assert.assertFalse((boolean)channelOpen.get());
        Assert.assertFalse((boolean)channelActive.get());
        Assert.assertFalse((boolean)childChannel.isActive());
    }

    @Test
    public void channelClosedWhenWriteFutureFails() {
        final ArrayDeque writePromises = new ArrayDeque();
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        Assert.assertTrue((boolean)childChannel.isOpen());
        Assert.assertTrue((boolean)childChannel.isActive());
        final AtomicBoolean channelOpen = new AtomicBoolean(true);
        final AtomicBoolean channelActive = new AtomicBoolean(true);
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        Mockito.when((Object)this.frameWriter.writeHeaders(this.eqCodecCtx(), ArgumentMatchers.anyInt(), (Http2Headers)ArgumentMatchers.eq((Object)headers), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean(), (ChannelPromise)ArgumentMatchers.any(ChannelPromise.class))).thenAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocationOnMock) {
                ChannelPromise promise = (ChannelPromise)invocationOnMock.getArgument(5);
                writePromises.offer(promise);
                return promise;
            }
        });
        ChannelFuture f = childChannel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)headers));
        Assert.assertFalse((boolean)f.isDone());
        f.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                channelOpen.set(future.channel().isOpen());
                channelActive.set(future.channel().isActive());
            }
        });
        ChannelPromise first = (ChannelPromise)writePromises.poll();
        first.setFailure((Throwable)new ClosedChannelException());
        f.awaitUninterruptibly();
        Assert.assertFalse((boolean)channelOpen.get());
        Assert.assertFalse((boolean)channelActive.get());
        Assert.assertFalse((boolean)childChannel.isActive());
    }

    @Test
    public void channelClosedTwiceMarksPromiseAsSuccessful() {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        Assert.assertTrue((boolean)childChannel.isOpen());
        Assert.assertTrue((boolean)childChannel.isActive());
        childChannel.close().syncUninterruptibly();
        childChannel.close().syncUninterruptibly();
        Assert.assertFalse((boolean)childChannel.isOpen());
        Assert.assertFalse((boolean)childChannel.isActive());
    }

    @Test
    public void settingChannelOptsAndAttrs() {
        AttributeKey key = AttributeKey.newInstance((String)UUID.randomUUID().toString());
        Http2StreamChannel childChannel = this.newOutboundStream((ChannelHandler)new ChannelInboundHandlerAdapter());
        childChannel.config().setAutoRead(false).setWriteSpinCount(1000);
        childChannel.attr(key).set((Object)"bar");
        Assert.assertFalse((boolean)childChannel.config().isAutoRead());
        Assert.assertEquals((long)1000L, (long)childChannel.config().getWriteSpinCount());
        Assert.assertEquals((Object)"bar", (Object)childChannel.attr(key).get());
    }

    @Test
    public void outboundFlowControlWritability() {
        Http2StreamChannel childChannel = this.newOutboundStream((ChannelHandler)new ChannelInboundHandlerAdapter());
        Assert.assertTrue((boolean)childChannel.isActive());
        Assert.assertTrue((boolean)childChannel.isWritable());
        childChannel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()));
        this.parentChannel.flush();
        Assert.assertTrue((1024 < childChannel.config().getWriteBufferHighWaterMark() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)childChannel.isWritable());
        childChannel.write((Object)new DefaultHttp2DataFrame(Unpooled.buffer().writeZero(0x1000000)));
        Assert.assertEquals((long)0L, (long)childChannel.bytesBeforeUnwritable());
        Assert.assertFalse((boolean)childChannel.isWritable());
    }

    @Test
    public void writabilityOfParentIsRespected() {
        Http2StreamChannel childChannel = this.newOutboundStream((ChannelHandler)new ChannelInboundHandlerAdapter());
        childChannel.config().setWriteBufferWaterMark(new WriteBufferWaterMark(2048, 4096));
        this.parentChannel.config().setWriteBufferWaterMark(new WriteBufferWaterMark(256, 512));
        Assert.assertTrue((boolean)childChannel.isWritable());
        Assert.assertTrue((boolean)this.parentChannel.isActive());
        childChannel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()));
        this.parentChannel.flush();
        Assert.assertTrue((boolean)childChannel.isWritable());
        childChannel.write((Object)new DefaultHttp2DataFrame(Unpooled.buffer().writeZero(256)));
        Assert.assertTrue((boolean)childChannel.isWritable());
        childChannel.writeAndFlush((Object)new DefaultHttp2DataFrame(Unpooled.buffer().writeZero(512)));
        long bytesBeforeUnwritable = childChannel.bytesBeforeUnwritable();
        Assert.assertNotEquals((long)0L, (long)bytesBeforeUnwritable);
        this.parentChannel.unsafe().outboundBuffer().addMessage((Object)Unpooled.buffer().writeZero(800), 800, this.parentChannel.voidPromise());
        Assert.assertFalse((boolean)this.parentChannel.isWritable());
        Assert.assertTrue((boolean)childChannel.isWritable());
        Assert.assertEquals((long)4096L, (long)childChannel.bytesBeforeUnwritable());
        this.parentChannel.flush();
        Assert.assertTrue((boolean)this.parentChannel.isWritable());
        Assert.assertTrue((boolean)childChannel.isWritable());
        Assert.assertEquals((long)bytesBeforeUnwritable, (long)childChannel.bytesBeforeUnwritable());
        ChannelFuture future = childChannel.writeAndFlush((Object)new DefaultHttp2DataFrame(Unpooled.buffer().writeZero((int)bytesBeforeUnwritable)));
        Assert.assertFalse((boolean)childChannel.isWritable());
        Assert.assertTrue((boolean)this.parentChannel.isWritable());
        this.parentChannel.flush();
        Assert.assertFalse((boolean)future.isDone());
        Assert.assertTrue((boolean)this.parentChannel.isWritable());
        Assert.assertFalse((boolean)childChannel.isWritable());
        this.frameInboundWriter.writeInboundWindowUpdate(childChannel.stream().id(), (int)bytesBeforeUnwritable);
        Assert.assertTrue((boolean)childChannel.isWritable());
        Assert.assertTrue((boolean)future.isDone());
    }

    @Test
    public void channelClosedWhenInactiveFired() {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        final AtomicBoolean channelOpen = new AtomicBoolean(false);
        final AtomicBoolean channelActive = new AtomicBoolean(false);
        Assert.assertTrue((boolean)childChannel.isOpen());
        Assert.assertTrue((boolean)childChannel.isActive());
        childChannel.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                channelOpen.set(ctx.channel().isOpen());
                channelActive.set(ctx.channel().isActive());
                super.channelInactive(ctx);
            }
        }});
        childChannel.close().syncUninterruptibly();
        Assert.assertFalse((boolean)channelOpen.get());
        Assert.assertFalse((boolean)channelActive.get());
    }

    @Test
    public void channelInactiveHappensAfterExceptionCaughtEvents() throws Exception {
        final AtomicInteger count = new AtomicInteger(0);
        final AtomicInteger exceptionCaught = new AtomicInteger(-1);
        final AtomicInteger channelInactive = new AtomicInteger(-1);
        final AtomicInteger channelUnregistered = new AtomicInteger(-1);
        Http2StreamChannel childChannel = this.newOutboundStream((ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                ctx.close();
                throw new Exception("exception");
            }
        });
        childChannel.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                channelInactive.set(count.getAndIncrement());
                super.channelInactive(ctx);
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                exceptionCaught.set(count.getAndIncrement());
                super.exceptionCaught(ctx, cause);
            }

            public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
                channelUnregistered.set(count.getAndIncrement());
                super.channelUnregistered(ctx);
            }
        }});
        childChannel.pipeline().fireUserEventTriggered(new Object());
        this.parentChannel.runPendingTasks();
        Assert.assertEquals((long)0L, (long)exceptionCaught.get());
        Assert.assertEquals((long)1L, (long)channelInactive.get());
        Assert.assertEquals((long)2L, (long)channelUnregistered.get());
    }

    @Test
    public void callUnsafeCloseMultipleTimes() {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        childChannel.unsafe().close(childChannel.voidPromise());
        ChannelPromise promise = childChannel.newPromise();
        childChannel.unsafe().close(promise);
        promise.syncUninterruptibly();
        childChannel.closeFuture().syncUninterruptibly();
    }

    @Test
    public void endOfStreamDoesNotDiscardData() {
        AtomicInteger numReads = new AtomicInteger(1);
        final AtomicBoolean shouldDisableAutoRead = new AtomicBoolean();
        LastInboundHandler.Consumer<ChannelHandlerContext> ctxConsumer = new LastInboundHandler.Consumer<ChannelHandlerContext>(){

            @Override
            public void accept(ChannelHandlerContext obj) {
                if (shouldDisableAutoRead.get()) {
                    obj.channel().config().setAutoRead(false);
                }
            }
        };
        LastInboundHandler inboundHandler = new LastInboundHandler(ctxConsumer);
        Http2StreamChannel childChannel = this.newInboundStream(3, false, numReads, (ChannelHandler)inboundHandler);
        childChannel.config().setAutoRead(false);
        DefaultHttp2DataFrame dataFrame1 = new DefaultHttp2DataFrame(Http2TestUtil.bb("1")).stream(childChannel.stream());
        DefaultHttp2DataFrame dataFrame2 = new DefaultHttp2DataFrame(Http2TestUtil.bb("2")).stream(childChannel.stream());
        DefaultHttp2DataFrame dataFrame3 = new DefaultHttp2DataFrame(Http2TestUtil.bb("3")).stream(childChannel.stream());
        DefaultHttp2DataFrame dataFrame4 = new DefaultHttp2DataFrame(Http2TestUtil.bb("4")).stream(childChannel.stream());
        Assert.assertEquals((Object)new DefaultHttp2HeadersFrame(this.request).stream(childChannel.stream()), inboundHandler.readInbound());
        ChannelInboundHandlerAdapter readCompleteSupressHandler = new ChannelInboundHandlerAdapter(){

            public void channelReadComplete(ChannelHandlerContext ctx) {
            }
        };
        this.parentChannel.pipeline().addFirst(new ChannelHandler[]{readCompleteSupressHandler});
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("1"), 0, false);
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame1, (Http2Frame)inboundHandler.readInbound());
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("2"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("3"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("4"), 0, false);
        shouldDisableAutoRead.set(true);
        childChannel.config().setAutoRead(true);
        numReads.set(1);
        this.frameInboundWriter.writeInboundRstStream(childChannel.stream().id(), Http2Error.NO_ERROR.code());
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame2, (Http2Frame)inboundHandler.readInbound());
        Assert.assertNull(inboundHandler.readInbound());
        childChannel.read();
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame3, (Http2Frame)inboundHandler.readInbound());
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame4, (Http2Frame)inboundHandler.readInbound());
        Http2ResetFrame resetFrame = this.useUserEventForResetFrame() ? (Http2ResetFrame)inboundHandler.readUserEvent() : (Http2ResetFrame)inboundHandler.readInbound();
        Assert.assertEquals((Object)childChannel.stream(), (Object)resetFrame.stream());
        Assert.assertEquals((long)Http2Error.NO_ERROR.code(), (long)resetFrame.errorCode());
        Assert.assertNull(inboundHandler.readInbound());
        this.parentChannel.pipeline().remove((ChannelHandler)readCompleteSupressHandler);
        this.parentChannel.flushInbound();
        childChannel.closeFuture().syncUninterruptibly();
    }

    protected abstract boolean useUserEventForResetFrame();

    protected abstract boolean ignoreWindowUpdateFrames();

    @Test
    public void windowUpdateFrames() {
        AtomicInteger numReads = new AtomicInteger(1);
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newInboundStream(3, false, numReads, (ChannelHandler)inboundHandler);
        Assert.assertEquals((Object)new DefaultHttp2HeadersFrame(this.request).stream(childChannel.stream()), inboundHandler.readInbound());
        this.frameInboundWriter.writeInboundWindowUpdate(childChannel.stream().id(), 4);
        Http2WindowUpdateFrame updateFrame = (Http2WindowUpdateFrame)inboundHandler.readInbound();
        if (this.ignoreWindowUpdateFrames()) {
            Assert.assertNull((Object)updateFrame);
        } else {
            Assert.assertEquals((Object)new DefaultHttp2WindowUpdateFrame(4).stream(childChannel.stream()), (Object)updateFrame);
        }
        this.frameInboundWriter.writeInboundWindowUpdate(0, 6);
        Assert.assertNull((Object)this.parentChannel.readInbound());
        childChannel.close().syncUninterruptibly();
    }

    @Test
    public void childQueueIsDrainedAndNewDataIsDispatchedInParentReadLoopAutoRead() {
        AtomicInteger numReads = new AtomicInteger(1);
        final AtomicInteger channelReadCompleteCount = new AtomicInteger(0);
        final AtomicBoolean shouldDisableAutoRead = new AtomicBoolean();
        LastInboundHandler.Consumer<ChannelHandlerContext> ctxConsumer = new LastInboundHandler.Consumer<ChannelHandlerContext>(){

            @Override
            public void accept(ChannelHandlerContext obj) {
                channelReadCompleteCount.incrementAndGet();
                if (shouldDisableAutoRead.get()) {
                    obj.channel().config().setAutoRead(false);
                }
            }
        };
        LastInboundHandler inboundHandler = new LastInboundHandler(ctxConsumer);
        Http2StreamChannel childChannel = this.newInboundStream(3, false, numReads, (ChannelHandler)inboundHandler);
        childChannel.config().setAutoRead(false);
        DefaultHttp2DataFrame dataFrame1 = new DefaultHttp2DataFrame(Http2TestUtil.bb("1")).stream(childChannel.stream());
        DefaultHttp2DataFrame dataFrame2 = new DefaultHttp2DataFrame(Http2TestUtil.bb("2")).stream(childChannel.stream());
        DefaultHttp2DataFrame dataFrame3 = new DefaultHttp2DataFrame(Http2TestUtil.bb("3")).stream(childChannel.stream());
        DefaultHttp2DataFrame dataFrame4 = new DefaultHttp2DataFrame(Http2TestUtil.bb("4")).stream(childChannel.stream());
        Assert.assertEquals((Object)new DefaultHttp2HeadersFrame(this.request).stream(childChannel.stream()), inboundHandler.readInbound());
        ChannelInboundHandlerAdapter readCompleteSupressHandler = new ChannelInboundHandlerAdapter(){

            public void channelReadComplete(ChannelHandlerContext ctx) {
            }
        };
        this.parentChannel.pipeline().addFirst(new ChannelHandler[]{readCompleteSupressHandler});
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("1"), 0, false);
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame1, (Http2Frame)inboundHandler.readInbound());
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("2"), 0, false);
        numReads.set(10);
        shouldDisableAutoRead.set(true);
        childChannel.config().setAutoRead(true);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("3"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("4"), 0, false);
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame2, (Http2Frame)inboundHandler.readInbound());
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame3, (Http2Frame)inboundHandler.readInbound());
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame4, (Http2Frame)inboundHandler.readInbound());
        Assert.assertNull(inboundHandler.readInbound());
        this.parentChannel.pipeline().remove((ChannelHandler)readCompleteSupressHandler);
        this.parentChannel.flushInbound();
        Assert.assertEquals((long)3L, (long)channelReadCompleteCount.get());
    }

    @Test
    public void childQueueIsDrainedAndNewDataIsDispatchedInParentReadLoopNoAutoRead() {
        AtomicInteger numReads = new AtomicInteger(1);
        final AtomicInteger channelReadCompleteCount = new AtomicInteger(0);
        final AtomicBoolean shouldDisableAutoRead = new AtomicBoolean();
        LastInboundHandler.Consumer<ChannelHandlerContext> ctxConsumer = new LastInboundHandler.Consumer<ChannelHandlerContext>(){

            @Override
            public void accept(ChannelHandlerContext obj) {
                channelReadCompleteCount.incrementAndGet();
                if (shouldDisableAutoRead.get()) {
                    obj.channel().config().setAutoRead(false);
                }
            }
        };
        LastInboundHandler inboundHandler = new LastInboundHandler(ctxConsumer);
        Http2StreamChannel childChannel = this.newInboundStream(3, false, numReads, (ChannelHandler)inboundHandler);
        childChannel.config().setAutoRead(false);
        DefaultHttp2DataFrame dataFrame1 = new DefaultHttp2DataFrame(Http2TestUtil.bb("1")).stream(childChannel.stream());
        DefaultHttp2DataFrame dataFrame2 = new DefaultHttp2DataFrame(Http2TestUtil.bb("2")).stream(childChannel.stream());
        DefaultHttp2DataFrame dataFrame3 = new DefaultHttp2DataFrame(Http2TestUtil.bb("3")).stream(childChannel.stream());
        DefaultHttp2DataFrame dataFrame4 = new DefaultHttp2DataFrame(Http2TestUtil.bb("4")).stream(childChannel.stream());
        Assert.assertEquals((Object)new DefaultHttp2HeadersFrame(this.request).stream(childChannel.stream()), inboundHandler.readInbound());
        ChannelInboundHandlerAdapter readCompleteSupressHandler = new ChannelInboundHandlerAdapter(){

            public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            }
        };
        this.parentChannel.pipeline().addFirst(new ChannelHandler[]{readCompleteSupressHandler});
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("1"), 0, false);
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame1, (Http2Frame)inboundHandler.readInbound());
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("2"), 0, false);
        numReads.set(2);
        childChannel.read();
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame2, (Http2Frame)inboundHandler.readInbound());
        Assert.assertNull(inboundHandler.readInbound());
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("3"), 0, false);
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame3, (Http2Frame)inboundHandler.readInbound());
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("4"), 0, false);
        Assert.assertNull(inboundHandler.readInbound());
        childChannel.read();
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame4, (Http2Frame)inboundHandler.readInbound());
        Assert.assertNull(inboundHandler.readInbound());
        this.parentChannel.pipeline().remove((ChannelHandler)readCompleteSupressHandler);
        this.parentChannel.flushInbound();
        Assert.assertEquals((long)4L, (long)channelReadCompleteCount.get());
    }

    @Test
    public void useReadWithoutAutoReadInRead() {
        this.useReadWithoutAutoReadBuffered(false);
    }

    @Test
    public void useReadWithoutAutoReadInReadComplete() {
        this.useReadWithoutAutoReadBuffered(true);
    }

    private void useReadWithoutAutoReadBuffered(final boolean triggerOnReadComplete) {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        Assert.assertTrue((boolean)childChannel.config().isAutoRead());
        childChannel.config().setAutoRead(false);
        Assert.assertFalse((boolean)childChannel.config().isAutoRead());
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)inboundHandler.readInbound();
        Assert.assertNotNull((Object)headersFrame);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("hello world"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("foo"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("bar"), 0, false);
        childChannel.pipeline().addFirst(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                super.channelReadComplete(ctx);
                if (triggerOnReadComplete) {
                    ctx.read();
                    ctx.read();
                }
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                ctx.fireChannelRead(msg);
                if (!triggerOnReadComplete) {
                    ctx.read();
                    ctx.read();
                }
            }
        }});
        inboundHandler.channel().read();
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(childChannel, inboundHandler, 3);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("hello world2"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("foo2"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("bar2"), 0, true);
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(childChannel, inboundHandler, 3);
    }

    @Test
    public void windowUpdatesAreFlushed() {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        FlushSniffer flushSniffer = new FlushSniffer();
        this.parentChannel.pipeline().addFirst(new ChannelHandler[]{flushSniffer});
        Http2StreamChannel childChannel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        Assert.assertTrue((boolean)childChannel.config().isAutoRead());
        childChannel.config().setAutoRead(false);
        Assert.assertFalse((boolean)childChannel.config().isAutoRead());
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)inboundHandler.readInbound();
        Assert.assertNotNull((Object)headersFrame);
        Assert.assertTrue((boolean)flushSniffer.checkFlush());
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb(16384), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb(16384), 0, false);
        Assert.assertTrue((boolean)flushSniffer.checkFlush());
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter, (VerificationMode)Mockito.never())).writeWindowUpdate(this.eqCodecCtx(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), Http2TestUtil.anyChannelPromise());
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(childChannel, inboundHandler, 1);
        Assert.assertFalse((boolean)flushSniffer.checkFlush());
        childChannel.read();
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(childChannel, inboundHandler, 1);
        Assert.assertTrue((boolean)flushSniffer.checkFlush());
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter, (VerificationMode)Mockito.never())).writeWindowUpdate(this.eqCodecCtx(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), Http2TestUtil.anyChannelPromise());
        childChannel.read();
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeWindowUpdate(this.eqCodecCtx(), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)32768), Http2TestUtil.anyChannelPromise());
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeWindowUpdate(this.eqCodecCtx(), ArgumentMatchers.eq((int)childChannel.stream().id()), ArgumentMatchers.eq((int)32768), Http2TestUtil.anyChannelPromise());
        Assert.assertTrue((boolean)flushSniffer.checkFlush());
    }

    private static void verifyFramesMultiplexedToCorrectChannel(Http2StreamChannel streamChannel, LastInboundHandler inboundHandler, int numFrames) {
        for (int i = 0; i < numFrames; ++i) {
            Http2StreamFrame frame = (Http2StreamFrame)inboundHandler.readInbound();
            Assert.assertNotNull((String)(i + " out of " + numFrames + " received"), (Object)frame);
            Assert.assertEquals((Object)streamChannel.stream(), (Object)frame.stream());
            ReferenceCountUtil.release((Object)frame);
        }
        Assert.assertNull(inboundHandler.readInbound());
    }

    private static int eqStreamId(Http2StreamChannel channel) {
        return ArgumentMatchers.eq((int)channel.stream().id());
    }

    private static final class FlushSniffer
    extends ChannelOutboundHandlerAdapter {
        private boolean didFlush;

        private FlushSniffer() {
        }

        public boolean checkFlush() {
            boolean r = this.didFlush;
            this.didFlush = false;
            return r;
        }

        public void flush(ChannelHandlerContext ctx) throws Exception {
            this.didFlush = true;
            super.flush(ctx);
        }
    }
}

