/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.HpackDynamicTable;
import io.netty.handler.codec.http2.HpackHeaderField;
import org.junit.Assert;
import org.junit.Test;

public class HpackDynamicTableTest {
    @Test
    public void testLength() {
        HpackDynamicTable table = new HpackDynamicTable(100L);
        Assert.assertEquals((long)0L, (long)table.length());
        HpackHeaderField entry = new HpackHeaderField((CharSequence)"foo", (CharSequence)"bar");
        table.add(entry);
        Assert.assertEquals((long)1L, (long)table.length());
        table.clear();
        Assert.assertEquals((long)0L, (long)table.length());
    }

    @Test
    public void testSize() {
        HpackDynamicTable table = new HpackDynamicTable(100L);
        Assert.assertEquals((long)0L, (long)table.size());
        HpackHeaderField entry = new HpackHeaderField((CharSequence)"foo", (CharSequence)"bar");
        table.add(entry);
        Assert.assertEquals((long)entry.size(), (long)table.size());
        table.clear();
        Assert.assertEquals((long)0L, (long)table.size());
    }

    @Test
    public void testGetEntry() {
        HpackDynamicTable table = new HpackDynamicTable(100L);
        HpackHeaderField entry = new HpackHeaderField((CharSequence)"foo", (CharSequence)"bar");
        table.add(entry);
        Assert.assertEquals((Object)entry, (Object)table.getEntry(1));
        table.clear();
        try {
            table.getEntry(1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testGetEntryExceptionally() {
        HpackDynamicTable table = new HpackDynamicTable(1L);
        table.getEntry(1);
    }

    @Test
    public void testRemove() {
        HpackDynamicTable table = new HpackDynamicTable(100L);
        Assert.assertNull((Object)table.remove());
        HpackHeaderField entry1 = new HpackHeaderField((CharSequence)"foo", (CharSequence)"bar");
        HpackHeaderField entry2 = new HpackHeaderField((CharSequence)"hello", (CharSequence)"world");
        table.add(entry1);
        table.add(entry2);
        Assert.assertEquals((Object)entry1, (Object)table.remove());
        Assert.assertEquals((Object)entry2, (Object)table.getEntry(1));
        Assert.assertEquals((long)1L, (long)table.length());
        Assert.assertEquals((long)entry2.size(), (long)table.size());
    }

    @Test
    public void testSetCapacity() {
        HpackHeaderField entry1 = new HpackHeaderField((CharSequence)"foo", (CharSequence)"bar");
        HpackHeaderField entry2 = new HpackHeaderField((CharSequence)"hello", (CharSequence)"world");
        int size1 = entry1.size();
        int size2 = entry2.size();
        HpackDynamicTable table = new HpackDynamicTable((long)(size1 + size2));
        table.add(entry1);
        table.add(entry2);
        Assert.assertEquals((long)2L, (long)table.length());
        Assert.assertEquals((long)(size1 + size2), (long)table.size());
        table.setCapacity((long)((size1 + size2) * 2));
        Assert.assertEquals((long)2L, (long)table.length());
        Assert.assertEquals((long)(size1 + size2), (long)table.size());
        table.setCapacity((long)size2);
        Assert.assertEquals((long)1L, (long)table.length());
        Assert.assertEquals((long)size2, (long)table.size());
        Assert.assertEquals((Object)entry2, (Object)table.getEntry(1));
        table.setCapacity(0L);
        Assert.assertEquals((long)0L, (long)table.length());
        Assert.assertEquals((long)0L, (long)table.size());
    }
}

