/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2.internal.hpack;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.internal.hpack.DynamicTable;
import io.netty.handler.codec.http2.internal.hpack.HeaderField;
import io.netty.handler.codec.http2.internal.hpack.HpackUtil;
import io.netty.handler.codec.http2.internal.hpack.HuffmanDecoder;
import io.netty.handler.codec.http2.internal.hpack.StaticTable;
import io.netty.util.AsciiString;
import io.netty.util.internal.ThrowableUtil;

public final class Decoder {
    private static final Http2Exception DECODE_DECOMPRESSION_EXCEPTION = (Http2Exception)ThrowableUtil.unknownStackTrace((Throwable)Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "HPACK - decompression failure", new Object[0]), Decoder.class, (String)"decode(...)");
    private static final Http2Exception DECODE_ULE_128_DECOMPRESSION_EXCEPTION = (Http2Exception)ThrowableUtil.unknownStackTrace((Throwable)Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "HPACK - decompression failure", new Object[0]), Decoder.class, (String)"decodeULE128(...)");
    private static final Http2Exception DECODE_ILLEGAL_INDEX_VALUE = (Http2Exception)ThrowableUtil.unknownStackTrace((Throwable)Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "HPACK - illegal index value", new Object[0]), Decoder.class, (String)"decode(...)");
    private static final Http2Exception INDEX_HEADER_ILLEGAL_INDEX_VALUE = (Http2Exception)ThrowableUtil.unknownStackTrace((Throwable)Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "HPACK - illegal index value", new Object[0]), Decoder.class, (String)"indexHeader(...)");
    private static final Http2Exception READ_NAME_ILLEGAL_INDEX_VALUE = (Http2Exception)ThrowableUtil.unknownStackTrace((Throwable)Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "HPACK - illegal index value", new Object[0]), Decoder.class, (String)"readName(...)");
    private static final Http2Exception INVALID_MAX_DYNAMIC_TABLE_SIZE = (Http2Exception)ThrowableUtil.unknownStackTrace((Throwable)Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "HPACK - invalid max dynamic table size", new Object[0]), Decoder.class, (String)"setDynamicTableSize(...)");
    private static final Http2Exception MAX_DYNAMIC_TABLE_SIZE_CHANGE_REQUIRED = (Http2Exception)ThrowableUtil.unknownStackTrace((Throwable)Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "HPACK - max dynamic table size change required", new Object[0]), Decoder.class, (String)"decode(...)");
    private static final byte READ_HEADER_REPRESENTATION = 0;
    private static final byte READ_MAX_DYNAMIC_TABLE_SIZE = 1;
    private static final byte READ_INDEXED_HEADER = 2;
    private static final byte READ_INDEXED_HEADER_NAME = 3;
    private static final byte READ_LITERAL_HEADER_NAME_LENGTH_PREFIX = 4;
    private static final byte READ_LITERAL_HEADER_NAME_LENGTH = 5;
    private static final byte READ_LITERAL_HEADER_NAME = 6;
    private static final byte READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX = 7;
    private static final byte READ_LITERAL_HEADER_VALUE_LENGTH = 8;
    private static final byte READ_LITERAL_HEADER_VALUE = 9;
    private final DynamicTable dynamicTable;
    private final HuffmanDecoder huffmanDecoder;
    private final int maxHeadersLength;
    private int maxDynamicTableSize;
    private int encoderMaxDynamicTableSize;
    private boolean maxDynamicTableSizeChangeRequired;

    public Decoder(int maxHeadersLength, int maxHeaderTableSize, int initialHuffmanDecodeCapacity) {
        this.dynamicTable = new DynamicTable(maxHeaderTableSize);
        this.maxHeadersLength = maxHeadersLength;
        this.maxDynamicTableSize = maxHeaderTableSize;
        this.encoderMaxDynamicTableSize = maxHeaderTableSize;
        this.maxDynamicTableSizeChangeRequired = false;
        this.huffmanDecoder = new HuffmanDecoder(initialHuffmanDecodeCapacity);
    }

    public void decode(ByteBuf in, Http2Headers headers) throws Http2Exception {
        int index = 0;
        int headersLength = 0;
        int nameLength = 0;
        int valueLength = 0;
        int state = 0;
        boolean huffmanEncoded = false;
        CharSequence name = null;
        HpackUtil.IndexType indexType = HpackUtil.IndexType.NONE;
        block28: while (in.isReadable()) {
            switch (state) {
                case 0: {
                    byte b = in.readByte();
                    if (this.maxDynamicTableSizeChangeRequired && (b & 0xE0) != 32) {
                        throw MAX_DYNAMIC_TABLE_SIZE_CHANGE_REQUIRED;
                    }
                    if (b < 0) {
                        index = b & 0x7F;
                        switch (index) {
                            case 0: {
                                throw DECODE_ILLEGAL_INDEX_VALUE;
                            }
                            case 127: {
                                state = 2;
                                continue block28;
                            }
                        }
                        headersLength = this.indexHeader(index, headers, headersLength);
                        continue block28;
                    }
                    if ((b & 0x40) == 64) {
                        indexType = HpackUtil.IndexType.INCREMENTAL;
                        index = b & 0x3F;
                        switch (index) {
                            case 0: {
                                state = 4;
                                continue block28;
                            }
                            case 63: {
                                state = 3;
                                continue block28;
                            }
                        }
                        name = this.readName(index);
                        state = 7;
                        continue block28;
                    }
                    if ((b & 0x20) == 32) {
                        index = b & 0x1F;
                        if (index == 31) {
                            state = 1;
                            continue block28;
                        }
                        this.setDynamicTableSize(index);
                        state = 0;
                        continue block28;
                    }
                    indexType = (b & 0x10) == 16 ? HpackUtil.IndexType.NEVER : HpackUtil.IndexType.NONE;
                    index = b & 0xF;
                    switch (index) {
                        case 0: {
                            state = 4;
                            continue block28;
                        }
                        case 15: {
                            state = 3;
                            continue block28;
                        }
                    }
                    name = this.readName(index);
                    state = 7;
                    continue block28;
                }
                case 1: {
                    int maxSize = Decoder.decodeULE128(in) + index;
                    if (maxSize < 0) {
                        throw DECODE_DECOMPRESSION_EXCEPTION;
                    }
                    this.setDynamicTableSize(maxSize);
                    state = 0;
                    continue block28;
                }
                case 2: {
                    int headerIndex = Decoder.decodeULE128(in) + index;
                    if (headerIndex < 0) {
                        throw DECODE_DECOMPRESSION_EXCEPTION;
                    }
                    headersLength = this.indexHeader(headerIndex, headers, headersLength);
                    state = 0;
                    continue block28;
                }
                case 3: {
                    int nameIndex = Decoder.decodeULE128(in) + index;
                    if (nameIndex < 0) {
                        throw DECODE_DECOMPRESSION_EXCEPTION;
                    }
                    name = this.readName(nameIndex);
                    state = 7;
                    continue block28;
                }
                case 4: {
                    byte b = in.readByte();
                    huffmanEncoded = (b & 0x80) == 128;
                    index = b & 0x7F;
                    if (index == 127) {
                        state = 5;
                        continue block28;
                    }
                    if (index > this.maxHeadersLength - headersLength) {
                        this.maxHeaderSizeExceeded();
                    }
                    nameLength = index;
                    state = 6;
                    continue block28;
                }
                case 5: {
                    nameLength = Decoder.decodeULE128(in) + index;
                    if (nameLength < 0) {
                        throw DECODE_DECOMPRESSION_EXCEPTION;
                    }
                    if (nameLength > this.maxHeadersLength - headersLength) {
                        this.maxHeaderSizeExceeded();
                    }
                    state = 6;
                    continue block28;
                }
                case 6: {
                    if (in.readableBytes() < nameLength) {
                        throw Decoder.notEnoughDataException(in);
                    }
                    name = this.readStringLiteral(in, nameLength, huffmanEncoded);
                    state = 7;
                    continue block28;
                }
                case 7: {
                    byte b = in.readByte();
                    huffmanEncoded = (b & 0x80) == 128;
                    index = b & 0x7F;
                    switch (index) {
                        case 127: {
                            state = 8;
                            continue block28;
                        }
                        case 0: {
                            headersLength = this.insertHeader(headers, name, (CharSequence)AsciiString.EMPTY_STRING, indexType, headersLength);
                            state = 0;
                            continue block28;
                        }
                    }
                    if ((long)index + (long)nameLength > (long)(this.maxHeadersLength - headersLength)) {
                        this.maxHeaderSizeExceeded();
                    }
                    valueLength = index;
                    state = 9;
                    continue block28;
                }
                case 8: {
                    valueLength = Decoder.decodeULE128(in) + index;
                    if (valueLength < 0) {
                        throw DECODE_DECOMPRESSION_EXCEPTION;
                    }
                    if ((long)valueLength + (long)nameLength > (long)(this.maxHeadersLength - headersLength)) {
                        this.maxHeaderSizeExceeded();
                    }
                    state = 9;
                    continue block28;
                }
                case 9: {
                    if (in.readableBytes() < valueLength) {
                        throw Decoder.notEnoughDataException(in);
                    }
                    CharSequence value = this.readStringLiteral(in, valueLength, huffmanEncoded);
                    headersLength = this.insertHeader(headers, name, value, indexType, headersLength);
                    state = 0;
                    continue block28;
                }
            }
            throw new Error("should not reach here state: " + state);
        }
    }

    public void setMaxHeaderTableSize(int maxHeaderTableSize) {
        this.maxDynamicTableSize = maxHeaderTableSize;
        if (this.maxDynamicTableSize < this.encoderMaxDynamicTableSize) {
            this.maxDynamicTableSizeChangeRequired = true;
            this.dynamicTable.setCapacity(this.maxDynamicTableSize);
        }
    }

    public int getMaxHeaderTableSize() {
        return this.dynamicTable.capacity();
    }

    int length() {
        return this.dynamicTable.length();
    }

    int size() {
        return this.dynamicTable.size();
    }

    HeaderField getHeaderField(int index) {
        return this.dynamicTable.getEntry(index + 1);
    }

    private void setDynamicTableSize(int dynamicTableSize) throws Http2Exception {
        if (dynamicTableSize > this.maxDynamicTableSize) {
            throw INVALID_MAX_DYNAMIC_TABLE_SIZE;
        }
        this.encoderMaxDynamicTableSize = dynamicTableSize;
        this.maxDynamicTableSizeChangeRequired = false;
        this.dynamicTable.setCapacity(dynamicTableSize);
    }

    private CharSequence readName(int index) throws Http2Exception {
        if (index <= StaticTable.length) {
            HeaderField headerField = StaticTable.getEntry(index);
            return headerField.name;
        }
        if (index - StaticTable.length <= this.dynamicTable.length()) {
            HeaderField headerField = this.dynamicTable.getEntry(index - StaticTable.length);
            return headerField.name;
        }
        throw READ_NAME_ILLEGAL_INDEX_VALUE;
    }

    private int indexHeader(int index, Http2Headers headers, int headersLength) throws Http2Exception {
        if (index <= StaticTable.length) {
            HeaderField headerField = StaticTable.getEntry(index);
            return this.addHeader(headers, headerField.name, headerField.value, headersLength);
        }
        if (index - StaticTable.length <= this.dynamicTable.length()) {
            HeaderField headerField = this.dynamicTable.getEntry(index - StaticTable.length);
            return this.addHeader(headers, headerField.name, headerField.value, headersLength);
        }
        throw INDEX_HEADER_ILLEGAL_INDEX_VALUE;
    }

    private int insertHeader(Http2Headers headers, CharSequence name, CharSequence value, HpackUtil.IndexType indexType, int headerSize) throws Http2Exception {
        headerSize = this.addHeader(headers, name, value, headerSize);
        switch (indexType) {
            case NONE: 
            case NEVER: {
                break;
            }
            case INCREMENTAL: {
                this.dynamicTable.add(new HeaderField(name, value));
                break;
            }
            default: {
                throw new Error("should not reach here");
            }
        }
        return headerSize;
    }

    private int addHeader(Http2Headers headers, CharSequence name, CharSequence value, int headersLength) throws Http2Exception {
        long newHeadersLength = (long)headersLength + (long)name.length() + (long)value.length();
        if (newHeadersLength > (long)this.maxHeadersLength) {
            this.maxHeaderSizeExceeded();
        }
        headers.add(name, value);
        return (int)newHeadersLength;
    }

    private void maxHeaderSizeExceeded() throws Http2Exception {
        throw Http2Exception.connectionError(Http2Error.ENHANCE_YOUR_CALM, "Header size exceeded max allowed bytes (%d)", this.maxHeadersLength);
    }

    private CharSequence readStringLiteral(ByteBuf in, int length, boolean huffmanEncoded) throws Http2Exception {
        if (huffmanEncoded) {
            return this.huffmanDecoder.decode(in, length);
        }
        byte[] buf = new byte[length];
        in.readBytes(buf);
        return new AsciiString(buf, false);
    }

    private static IllegalArgumentException notEnoughDataException(ByteBuf in) {
        return new IllegalArgumentException("decode only works with an entire header block! " + in);
    }

    private static int decodeULE128(ByteBuf in) throws Http2Exception {
        int writerIndex = in.writerIndex();
        int readerIndex = in.readerIndex();
        int shift = 0;
        int result = 0;
        while (readerIndex < writerIndex) {
            byte b = in.getByte(readerIndex);
            if (shift == 28 && (b & 0xF8) != 0) {
                in.readerIndex(readerIndex + 1);
                break;
            }
            if ((b & 0x80) == 0) {
                in.readerIndex(readerIndex + 1);
                return result | (b & 0x7F) << shift;
            }
            result |= (b & 0x7F) << shift;
            ++readerIndex;
            shift += 7;
        }
        throw DECODE_ULE_128_DECOMPRESSION_EXCEPTION;
    }
}

