/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.Http2ConnectionPrefaceAndSettingsFrameWrittenEvent;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2TestUtil;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapterBuilder;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.Future;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class InboundHttp2ToHttpAdapterTest {
    private List<FullHttpMessage> capturedRequests;
    private List<FullHttpMessage> capturedResponses;
    @Mock
    private HttpResponseListener serverListener;
    @Mock
    private HttpResponseListener clientListener;
    @Mock
    private HttpSettingsListener settingsListener;
    private Http2ConnectionHandler serverHandler;
    private Http2ConnectionHandler clientHandler;
    private ServerBootstrap sb;
    private Bootstrap cb;
    private Channel serverChannel;
    private volatile Channel serverConnectedChannel;
    private Channel clientChannel;
    private CountDownLatch serverLatch;
    private CountDownLatch clientLatch;
    private CountDownLatch serverLatch2;
    private CountDownLatch clientLatch2;
    private CountDownLatch settingsLatch;
    private int maxContentLength;
    private HttpResponseDelegator serverDelegator;
    private HttpResponseDelegator clientDelegator;
    private HttpSettingsDelegator settingsDelegator;
    private Http2Exception clientException;

    @Before
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
    }

    @After
    public void teardown() throws Exception {
        Channel serverConnectedChannel;
        this.cleanupCapturedRequests();
        this.cleanupCapturedResponses();
        if (this.clientChannel != null) {
            this.clientChannel.close().syncUninterruptibly();
            this.clientChannel = null;
        }
        if (this.serverChannel != null) {
            this.serverChannel.close().syncUninterruptibly();
            this.serverChannel = null;
        }
        if ((serverConnectedChannel = this.serverConnectedChannel) != null) {
            serverConnectedChannel.close().syncUninterruptibly();
            this.serverConnectedChannel = null;
        }
        Future serverGroup = this.sb.config().group().shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
        Future serverChildGroup = this.sb.config().childGroup().shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
        Future clientGroup = this.cb.config().group().shutdownGracefully(0L, 5L, TimeUnit.SECONDS);
        serverGroup.syncUninterruptibly();
        serverChildGroup.syncUninterruptibly();
        clientGroup.syncUninterruptibly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void clientRequestSingleHeaderNoDataFrames() throws Exception {
        this.boostrapEnv(1, 1, 1);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/some/path/resource2", true);
        try {
            HttpHeaders httpHeaders = request.headers();
            httpHeaders.set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)"https");
            httpHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)"example.org");
            httpHeaders.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 3);
            httpHeaders.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, 0);
            httpHeaders.setShort((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
            final Http2Headers http2Headers = new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"GET")).scheme((CharSequence)new AsciiString((CharSequence)"https")).authority((CharSequence)new AsciiString((CharSequence)"example.org")).path((CharSequence)new AsciiString((CharSequence)"/some/path/resource2"));
            Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

                @Override
                public void run() throws Http2Exception {
                    InboundHttp2ToHttpAdapterTest.this.clientHandler.encoder().writeHeaders(InboundHttp2ToHttpAdapterTest.this.ctxClient(), 3, http2Headers, 0, true, InboundHttp2ToHttpAdapterTest.this.newPromiseClient());
                    InboundHttp2ToHttpAdapterTest.this.clientChannel.flush();
                }
            });
            this.awaitRequests();
            ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(FullHttpMessage.class);
            ((HttpResponseListener)Mockito.verify((Object)this.serverListener)).messageReceived((HttpObject)requestCaptor.capture());
            this.capturedRequests = requestCaptor.getAllValues();
            Assert.assertEquals((Object)request, (Object)this.capturedRequests.get(0));
        }
        finally {
            request.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void clientRequestSingleHeaderCookieSplitIntoMultipleEntries() throws Exception {
        this.boostrapEnv(1, 1, 1);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/some/path/resource2", true);
        try {
            HttpHeaders httpHeaders = request.headers();
            httpHeaders.set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)"https");
            httpHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)"example.org");
            httpHeaders.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 3);
            httpHeaders.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, 0);
            httpHeaders.set((CharSequence)HttpHeaderNames.COOKIE, (Object)"a=b; c=d; e=f");
            httpHeaders.setShort((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
            final Http2Headers http2Headers = (Http2Headers)((Http2Headers)((Http2Headers)new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"GET")).scheme((CharSequence)new AsciiString((CharSequence)"https")).authority((CharSequence)new AsciiString((CharSequence)"example.org")).path((CharSequence)new AsciiString((CharSequence)"/some/path/resource2")).add((Object)HttpHeaderNames.COOKIE, (Object)"a=b")).add((Object)HttpHeaderNames.COOKIE, (Object)"c=d")).add((Object)HttpHeaderNames.COOKIE, (Object)"e=f");
            Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

                @Override
                public void run() throws Http2Exception {
                    InboundHttp2ToHttpAdapterTest.this.clientHandler.encoder().writeHeaders(InboundHttp2ToHttpAdapterTest.this.ctxClient(), 3, http2Headers, 0, true, InboundHttp2ToHttpAdapterTest.this.newPromiseClient());
                    InboundHttp2ToHttpAdapterTest.this.clientChannel.flush();
                }
            });
            this.awaitRequests();
            ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(FullHttpMessage.class);
            ((HttpResponseListener)Mockito.verify((Object)this.serverListener)).messageReceived((HttpObject)requestCaptor.capture());
            this.capturedRequests = requestCaptor.getAllValues();
            Assert.assertEquals((Object)request, (Object)this.capturedRequests.get(0));
        }
        finally {
            request.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void clientRequestSingleHeaderCookieSplitIntoMultipleEntries2() throws Exception {
        this.boostrapEnv(1, 1, 1);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/some/path/resource2", true);
        try {
            HttpHeaders httpHeaders = request.headers();
            httpHeaders.set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)"https");
            httpHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)"example.org");
            httpHeaders.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 3);
            httpHeaders.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, 0);
            httpHeaders.set((CharSequence)HttpHeaderNames.COOKIE, (Object)"a=b; c=d; e=f");
            httpHeaders.setShort((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
            final Http2Headers http2Headers = (Http2Headers)((Http2Headers)new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"GET")).scheme((CharSequence)new AsciiString((CharSequence)"https")).authority((CharSequence)new AsciiString((CharSequence)"example.org")).path((CharSequence)new AsciiString((CharSequence)"/some/path/resource2")).add((Object)HttpHeaderNames.COOKIE, (Object)"a=b; c=d")).add((Object)HttpHeaderNames.COOKIE, (Object)"e=f");
            Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

                @Override
                public void run() throws Http2Exception {
                    InboundHttp2ToHttpAdapterTest.this.clientHandler.encoder().writeHeaders(InboundHttp2ToHttpAdapterTest.this.ctxClient(), 3, http2Headers, 0, true, InboundHttp2ToHttpAdapterTest.this.newPromiseClient());
                    InboundHttp2ToHttpAdapterTest.this.clientChannel.flush();
                }
            });
            this.awaitRequests();
            ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(FullHttpMessage.class);
            ((HttpResponseListener)Mockito.verify((Object)this.serverListener)).messageReceived((HttpObject)requestCaptor.capture());
            this.capturedRequests = requestCaptor.getAllValues();
            Assert.assertEquals((Object)request, (Object)this.capturedRequests.get(0));
        }
        finally {
            request.release();
        }
    }

    @Test
    public void clientRequestSingleHeaderNonAsciiShouldThrow() throws Exception {
        this.boostrapEnv(1, 1, 1);
        final Http2Headers http2Headers = (Http2Headers)new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"GET")).scheme((CharSequence)new AsciiString((CharSequence)"https")).authority((CharSequence)new AsciiString((CharSequence)"example.org")).path((CharSequence)new AsciiString((CharSequence)"/some/path/resource2")).add((Object)new AsciiString("\u00e7\u00e3".getBytes(CharsetUtil.UTF_8)), (Object)new AsciiString("\u00c3\u00e3".getBytes(CharsetUtil.UTF_8)));
        Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() throws Http2Exception {
                InboundHttp2ToHttpAdapterTest.this.clientHandler.encoder().writeHeaders(InboundHttp2ToHttpAdapterTest.this.ctxClient(), 3, http2Headers, 0, true, InboundHttp2ToHttpAdapterTest.this.newPromiseClient());
                InboundHttp2ToHttpAdapterTest.this.clientChannel.flush();
            }
        });
        this.awaitResponses();
        Assert.assertTrue((boolean)Http2Exception.isStreamError((Http2Exception)this.clientException));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void clientRequestOneDataFrame() throws Exception {
        this.boostrapEnv(1, 1, 1);
        String text = "hello world";
        final ByteBuf content = Unpooled.copiedBuffer((byte[])"hello world".getBytes());
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/some/path/resource2", content, true);
        try {
            HttpHeaders httpHeaders = request.headers();
            httpHeaders.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 3);
            httpHeaders.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, "hello world".length());
            httpHeaders.setShort((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
            final Http2Headers http2Headers = new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"GET")).path((CharSequence)new AsciiString((CharSequence)"/some/path/resource2"));
            Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

                @Override
                public void run() throws Http2Exception {
                    InboundHttp2ToHttpAdapterTest.this.clientHandler.encoder().writeHeaders(InboundHttp2ToHttpAdapterTest.this.ctxClient(), 3, http2Headers, 0, false, InboundHttp2ToHttpAdapterTest.this.newPromiseClient());
                    InboundHttp2ToHttpAdapterTest.this.clientHandler.encoder().writeData(InboundHttp2ToHttpAdapterTest.this.ctxClient(), 3, content.retainedDuplicate(), 0, true, InboundHttp2ToHttpAdapterTest.this.newPromiseClient());
                    InboundHttp2ToHttpAdapterTest.this.clientChannel.flush();
                }
            });
            this.awaitRequests();
            ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(FullHttpMessage.class);
            ((HttpResponseListener)Mockito.verify((Object)this.serverListener)).messageReceived((HttpObject)requestCaptor.capture());
            this.capturedRequests = requestCaptor.getAllValues();
            Assert.assertEquals((Object)request, (Object)this.capturedRequests.get(0));
        }
        finally {
            request.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void clientRequestMultipleDataFrames() throws Exception {
        this.boostrapEnv(1, 1, 1);
        String text = "hello world big time data!";
        final ByteBuf content = Unpooled.copiedBuffer((byte[])"hello world big time data!".getBytes());
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/some/path/resource2", content, true);
        try {
            HttpHeaders httpHeaders = request.headers();
            httpHeaders.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 3);
            httpHeaders.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, "hello world big time data!".length());
            httpHeaders.setShort((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
            final Http2Headers http2Headers = new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"GET")).path((CharSequence)new AsciiString((CharSequence)"/some/path/resource2"));
            final int midPoint = "hello world big time data!".length() / 2;
            Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

                @Override
                public void run() throws Http2Exception {
                    InboundHttp2ToHttpAdapterTest.this.clientHandler.encoder().writeHeaders(InboundHttp2ToHttpAdapterTest.this.ctxClient(), 3, http2Headers, 0, false, InboundHttp2ToHttpAdapterTest.this.newPromiseClient());
                    InboundHttp2ToHttpAdapterTest.this.clientHandler.encoder().writeData(InboundHttp2ToHttpAdapterTest.this.ctxClient(), 3, content.retainedSlice(0, midPoint), 0, false, InboundHttp2ToHttpAdapterTest.this.newPromiseClient());
                    InboundHttp2ToHttpAdapterTest.this.clientHandler.encoder().writeData(InboundHttp2ToHttpAdapterTest.this.ctxClient(), 3, content.retainedSlice(midPoint, "hello world big time data!".length() - midPoint), 0, true, InboundHttp2ToHttpAdapterTest.this.newPromiseClient());
                    InboundHttp2ToHttpAdapterTest.this.clientChannel.flush();
                }
            });
            this.awaitRequests();
            ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(FullHttpMessage.class);
            ((HttpResponseListener)Mockito.verify((Object)this.serverListener)).messageReceived((HttpObject)requestCaptor.capture());
            this.capturedRequests = requestCaptor.getAllValues();
            Assert.assertEquals((Object)request, (Object)this.capturedRequests.get(0));
        }
        finally {
            request.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void clientRequestMultipleEmptyDataFrames() throws Exception {
        this.boostrapEnv(1, 1, 1);
        String text = "";
        final ByteBuf content = Unpooled.copiedBuffer((byte[])"".getBytes());
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/some/path/resource2", content, true);
        try {
            HttpHeaders httpHeaders = request.headers();
            httpHeaders.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 3);
            httpHeaders.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, "".length());
            httpHeaders.setShort((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
            final Http2Headers http2Headers = new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"GET")).path((CharSequence)new AsciiString((CharSequence)"/some/path/resource2"));
            Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

                @Override
                public void run() throws Http2Exception {
                    InboundHttp2ToHttpAdapterTest.this.clientHandler.encoder().writeHeaders(InboundHttp2ToHttpAdapterTest.this.ctxClient(), 3, http2Headers, 0, false, InboundHttp2ToHttpAdapterTest.this.newPromiseClient());
                    InboundHttp2ToHttpAdapterTest.this.clientHandler.encoder().writeData(InboundHttp2ToHttpAdapterTest.this.ctxClient(), 3, content.retain(), 0, false, InboundHttp2ToHttpAdapterTest.this.newPromiseClient());
                    InboundHttp2ToHttpAdapterTest.this.clientHandler.encoder().writeData(InboundHttp2ToHttpAdapterTest.this.ctxClient(), 3, content.retain(), 0, false, InboundHttp2ToHttpAdapterTest.this.newPromiseClient());
                    InboundHttp2ToHttpAdapterTest.this.clientHandler.encoder().writeData(InboundHttp2ToHttpAdapterTest.this.ctxClient(), 3, content.retain(), 0, true, InboundHttp2ToHttpAdapterTest.this.newPromiseClient());
                    InboundHttp2ToHttpAdapterTest.this.clientChannel.flush();
                }
            });
            this.awaitRequests();
            ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(FullHttpMessage.class);
            ((HttpResponseListener)Mockito.verify((Object)this.serverListener)).messageReceived((HttpObject)requestCaptor.capture());
            this.capturedRequests = requestCaptor.getAllValues();
            Assert.assertEquals((Object)request, (Object)this.capturedRequests.get(0));
        }
        finally {
            request.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void clientRequestTrailingHeaders() throws Exception {
        this.boostrapEnv(1, 1, 1);
        String text = "some data";
        final ByteBuf content = Unpooled.copiedBuffer((byte[])"some data".getBytes());
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/some/path/resource2", content, true);
        try {
            HttpHeaders httpHeaders = request.headers();
            httpHeaders.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 3);
            httpHeaders.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, "some data".length());
            httpHeaders.setShort((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
            HttpHeaders trailingHeaders = request.trailingHeaders();
            trailingHeaders.set(Http2TestUtil.of("Foo"), (Object)Http2TestUtil.of("goo"));
            trailingHeaders.set(Http2TestUtil.of("fOo2"), (Object)Http2TestUtil.of("goo2"));
            trailingHeaders.add(Http2TestUtil.of("foO2"), (Object)Http2TestUtil.of("goo3"));
            final Http2Headers http2Headers = new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"GET")).path((CharSequence)new AsciiString((CharSequence)"/some/path/resource2"));
            final Http2Headers http2Headers2 = (Http2Headers)((Http2Headers)((Http2Headers)new DefaultHttp2Headers().set((Object)new AsciiString((CharSequence)"foo"), (Object)new AsciiString((CharSequence)"goo"))).set((Object)new AsciiString((CharSequence)"foo2"), (Object)new AsciiString((CharSequence)"goo2"))).add((Object)new AsciiString((CharSequence)"foo2"), (Object)new AsciiString((CharSequence)"goo3"));
            Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

                @Override
                public void run() throws Http2Exception {
                    InboundHttp2ToHttpAdapterTest.this.clientHandler.encoder().writeHeaders(InboundHttp2ToHttpAdapterTest.this.ctxClient(), 3, http2Headers, 0, false, InboundHttp2ToHttpAdapterTest.this.newPromiseClient());
                    InboundHttp2ToHttpAdapterTest.this.clientHandler.encoder().writeData(InboundHttp2ToHttpAdapterTest.this.ctxClient(), 3, content.retainedDuplicate(), 0, false, InboundHttp2ToHttpAdapterTest.this.newPromiseClient());
                    InboundHttp2ToHttpAdapterTest.this.clientHandler.encoder().writeHeaders(InboundHttp2ToHttpAdapterTest.this.ctxClient(), 3, http2Headers2, 0, true, InboundHttp2ToHttpAdapterTest.this.newPromiseClient());
                    InboundHttp2ToHttpAdapterTest.this.clientChannel.flush();
                }
            });
            this.awaitRequests();
            ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(FullHttpMessage.class);
            ((HttpResponseListener)Mockito.verify((Object)this.serverListener)).messageReceived((HttpObject)requestCaptor.capture());
            this.capturedRequests = requestCaptor.getAllValues();
            Assert.assertEquals((Object)request, (Object)this.capturedRequests.get(0));
        }
        finally {
            request.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void clientRequestStreamDependencyInHttpMessageFlow() throws Exception {
        this.boostrapEnv(1, 2, 1);
        String text = "hello world big time data!";
        final ByteBuf content = Unpooled.copiedBuffer((byte[])"hello world big time data!".getBytes());
        String text2 = "hello world big time data...number 2!!";
        final ByteBuf content2 = Unpooled.copiedBuffer((byte[])"hello world big time data...number 2!!".getBytes());
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, "/some/path/resource", content, true);
        DefaultFullHttpRequest request2 = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, "/some/path/resource2", content2, true);
        try {
            HttpHeaders httpHeaders = request.headers();
            httpHeaders.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 3);
            httpHeaders.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, "hello world big time data!".length());
            httpHeaders.setShort((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
            HttpHeaders httpHeaders2 = request2.headers();
            httpHeaders2.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 5);
            httpHeaders2.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text(), 3);
            httpHeaders2.setShort((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)123);
            httpHeaders2.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, "hello world big time data...number 2!!".length());
            final Http2Headers http2Headers = new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"PUT")).path((CharSequence)new AsciiString((CharSequence)"/some/path/resource"));
            final Http2Headers http2Headers2 = new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"PUT")).path((CharSequence)new AsciiString((CharSequence)"/some/path/resource2"));
            Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

                @Override
                public void run() throws Http2Exception {
                    InboundHttp2ToHttpAdapterTest.this.clientHandler.encoder().writeHeaders(InboundHttp2ToHttpAdapterTest.this.ctxClient(), 3, http2Headers, 0, false, InboundHttp2ToHttpAdapterTest.this.newPromiseClient());
                    InboundHttp2ToHttpAdapterTest.this.clientHandler.encoder().writeHeaders(InboundHttp2ToHttpAdapterTest.this.ctxClient(), 5, http2Headers2, 3, (short)123, true, 0, false, InboundHttp2ToHttpAdapterTest.this.newPromiseClient());
                    InboundHttp2ToHttpAdapterTest.this.clientChannel.flush();
                    InboundHttp2ToHttpAdapterTest.this.clientHandler.encoder().writeData(InboundHttp2ToHttpAdapterTest.this.ctxClient(), 3, content.retainedDuplicate(), 0, true, InboundHttp2ToHttpAdapterTest.this.newPromiseClient());
                    InboundHttp2ToHttpAdapterTest.this.clientHandler.encoder().writeData(InboundHttp2ToHttpAdapterTest.this.ctxClient(), 5, content2.retainedDuplicate(), 0, true, InboundHttp2ToHttpAdapterTest.this.newPromiseClient());
                    InboundHttp2ToHttpAdapterTest.this.clientChannel.flush();
                }
            });
            this.awaitRequests();
            ArgumentCaptor httpObjectCaptor = ArgumentCaptor.forClass(FullHttpMessage.class);
            ((HttpResponseListener)Mockito.verify((Object)this.serverListener, (VerificationMode)Mockito.times((int)2))).messageReceived((HttpObject)httpObjectCaptor.capture());
            this.capturedRequests = httpObjectCaptor.getAllValues();
            Assert.assertEquals((Object)request, (Object)this.capturedRequests.get(0));
            Assert.assertEquals((Object)request2, (Object)this.capturedRequests.get(1));
        }
        finally {
            request.release();
            request2.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void serverRequestPushPromise() throws Exception {
        this.boostrapEnv(1, 1, 1);
        String text = "hello world big time data!";
        final ByteBuf content = Unpooled.copiedBuffer((byte[])"hello world big time data!".getBytes());
        String text2 = "hello world smaller data?";
        final ByteBuf content2 = Unpooled.copiedBuffer((byte[])"hello world smaller data?".getBytes());
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content, true);
        DefaultFullHttpResponse response2 = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CREATED, content2, true);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/push/test", true);
        try {
            HttpHeaders httpHeaders = response.headers();
            httpHeaders.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 3);
            httpHeaders.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, "hello world big time data!".length());
            httpHeaders.setShort((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
            HttpHeaders httpHeaders2 = response2.headers();
            httpHeaders2.set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)"https");
            httpHeaders2.set((CharSequence)HttpHeaderNames.HOST, (Object)"example.org");
            httpHeaders2.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 5);
            httpHeaders2.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_PROMISE_ID.text(), 3);
            httpHeaders2.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, "hello world smaller data?".length());
            httpHeaders = request.headers();
            httpHeaders.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 3);
            httpHeaders.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, 0);
            httpHeaders.setShort((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
            final Http2Headers http2Headers3 = new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"GET")).path((CharSequence)new AsciiString((CharSequence)"/push/test"));
            Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

                @Override
                public void run() throws Http2Exception {
                    InboundHttp2ToHttpAdapterTest.this.clientHandler.encoder().writeHeaders(InboundHttp2ToHttpAdapterTest.this.ctxClient(), 3, http2Headers3, 0, true, InboundHttp2ToHttpAdapterTest.this.newPromiseClient());
                    InboundHttp2ToHttpAdapterTest.this.clientChannel.flush();
                }
            });
            this.awaitRequests();
            ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(FullHttpMessage.class);
            ((HttpResponseListener)Mockito.verify((Object)this.serverListener)).messageReceived((HttpObject)requestCaptor.capture());
            this.capturedRequests = requestCaptor.getAllValues();
            Assert.assertEquals((Object)request, (Object)this.capturedRequests.get(0));
            final Http2Headers http2Headers = new DefaultHttp2Headers().status((CharSequence)new AsciiString((CharSequence)"200"));
            final Http2Headers http2Headers2 = new DefaultHttp2Headers().scheme((CharSequence)new AsciiString((CharSequence)"https")).authority((CharSequence)new AsciiString((CharSequence)"example.org"));
            Http2TestUtil.runInChannel(this.serverConnectedChannel, new Http2TestUtil.Http2Runnable(){

                @Override
                public void run() throws Http2Exception {
                    InboundHttp2ToHttpAdapterTest.this.serverHandler.encoder().writeHeaders(InboundHttp2ToHttpAdapterTest.this.ctxServer(), 3, http2Headers, 0, false, InboundHttp2ToHttpAdapterTest.this.newPromiseServer());
                    InboundHttp2ToHttpAdapterTest.this.serverHandler.encoder().writePushPromise(InboundHttp2ToHttpAdapterTest.this.ctxServer(), 3, 2, http2Headers2, 0, InboundHttp2ToHttpAdapterTest.this.newPromiseServer());
                    InboundHttp2ToHttpAdapterTest.this.serverHandler.encoder().writeData(InboundHttp2ToHttpAdapterTest.this.ctxServer(), 3, content.retainedDuplicate(), 0, true, InboundHttp2ToHttpAdapterTest.this.newPromiseServer());
                    InboundHttp2ToHttpAdapterTest.this.serverHandler.encoder().writeData(InboundHttp2ToHttpAdapterTest.this.ctxServer(), 5, content2.retainedDuplicate(), 0, true, InboundHttp2ToHttpAdapterTest.this.newPromiseServer());
                    InboundHttp2ToHttpAdapterTest.this.serverConnectedChannel.flush();
                }
            });
            this.awaitResponses();
            ArgumentCaptor responseCaptor = ArgumentCaptor.forClass(FullHttpMessage.class);
            ((HttpResponseListener)Mockito.verify((Object)this.clientListener)).messageReceived((HttpObject)responseCaptor.capture());
            this.capturedResponses = responseCaptor.getAllValues();
            Assert.assertEquals((Object)response, (Object)this.capturedResponses.get(0));
        }
        finally {
            request.release();
            response.release();
            response2.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void serverResponseHeaderInformational() throws Exception {
        this.boostrapEnv(1, 2, 1, 2, 1);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, "/info/test", true);
        HttpHeaders httpHeaders = request.headers();
        httpHeaders.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 3);
        httpHeaders.set((CharSequence)HttpHeaderNames.EXPECT, (Object)HttpHeaderValues.CONTINUE);
        httpHeaders.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, 0);
        httpHeaders.setShort((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
        final Http2Headers http2Headers = (Http2Headers)new DefaultHttp2Headers().method((CharSequence)new AsciiString((CharSequence)"PUT")).path((CharSequence)new AsciiString((CharSequence)"/info/test")).set((Object)new AsciiString((CharSequence)HttpHeaderNames.EXPECT.toString()), (Object)new AsciiString((CharSequence)HttpHeaderValues.CONTINUE.toString()));
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
        String text = "a big payload";
        final ByteBuf payload = Unpooled.copiedBuffer((byte[])"a big payload".getBytes());
        FullHttpMessage request2 = request.replace(payload);
        DefaultFullHttpResponse response2 = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        try {
            Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

                @Override
                public void run() throws Http2Exception {
                    InboundHttp2ToHttpAdapterTest.this.clientHandler.encoder().writeHeaders(InboundHttp2ToHttpAdapterTest.this.ctxClient(), 3, http2Headers, 0, false, InboundHttp2ToHttpAdapterTest.this.newPromiseClient());
                    InboundHttp2ToHttpAdapterTest.this.clientChannel.flush();
                }
            });
            this.awaitRequests();
            httpHeaders = response.headers();
            httpHeaders.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 3);
            httpHeaders.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, 0);
            final Http2Headers http2HeadersResponse = new DefaultHttp2Headers().status((CharSequence)new AsciiString((CharSequence)"100"));
            Http2TestUtil.runInChannel(this.serverConnectedChannel, new Http2TestUtil.Http2Runnable(){

                @Override
                public void run() throws Http2Exception {
                    InboundHttp2ToHttpAdapterTest.this.serverHandler.encoder().writeHeaders(InboundHttp2ToHttpAdapterTest.this.ctxServer(), 3, http2HeadersResponse, 0, false, InboundHttp2ToHttpAdapterTest.this.newPromiseServer());
                    InboundHttp2ToHttpAdapterTest.this.serverConnectedChannel.flush();
                }
            });
            this.awaitResponses();
            httpHeaders = request2.headers();
            httpHeaders.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, "a big payload".length());
            httpHeaders.remove((CharSequence)HttpHeaderNames.EXPECT);
            Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

                @Override
                public void run() {
                    InboundHttp2ToHttpAdapterTest.this.clientHandler.encoder().writeData(InboundHttp2ToHttpAdapterTest.this.ctxClient(), 3, payload.retainedDuplicate(), 0, true, InboundHttp2ToHttpAdapterTest.this.newPromiseClient());
                    InboundHttp2ToHttpAdapterTest.this.clientChannel.flush();
                }
            });
            this.awaitRequests2();
            httpHeaders = response2.headers();
            httpHeaders.setInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 3);
            httpHeaders.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, 0);
            httpHeaders.setShort((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
            final Http2Headers http2HeadersResponse2 = new DefaultHttp2Headers().status((CharSequence)new AsciiString((CharSequence)"200"));
            Http2TestUtil.runInChannel(this.serverConnectedChannel, new Http2TestUtil.Http2Runnable(){

                @Override
                public void run() throws Http2Exception {
                    InboundHttp2ToHttpAdapterTest.this.serverHandler.encoder().writeHeaders(InboundHttp2ToHttpAdapterTest.this.ctxServer(), 3, http2HeadersResponse2, 0, true, InboundHttp2ToHttpAdapterTest.this.newPromiseServer());
                    InboundHttp2ToHttpAdapterTest.this.serverConnectedChannel.flush();
                }
            });
            this.awaitResponses2();
            ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(FullHttpMessage.class);
            ((HttpResponseListener)Mockito.verify((Object)this.serverListener, (VerificationMode)Mockito.times((int)2))).messageReceived((HttpObject)requestCaptor.capture());
            this.capturedRequests = requestCaptor.getAllValues();
            Assert.assertEquals((long)2L, (long)this.capturedRequests.size());
            Assert.assertNotNull((Object)request.headers().remove("x-http2-stream-weight"));
            Assert.assertEquals((Object)request, (Object)this.capturedRequests.get(0));
            Assert.assertEquals((Object)request2, (Object)this.capturedRequests.get(1));
            ArgumentCaptor responseCaptor = ArgumentCaptor.forClass(FullHttpMessage.class);
            ((HttpResponseListener)Mockito.verify((Object)this.clientListener, (VerificationMode)Mockito.times((int)2))).messageReceived((HttpObject)responseCaptor.capture());
            this.capturedResponses = responseCaptor.getAllValues();
            Assert.assertEquals((long)2L, (long)this.capturedResponses.size());
            Assert.assertEquals((Object)response, (Object)this.capturedResponses.get(0));
            Assert.assertEquals((Object)response2, (Object)this.capturedResponses.get(1));
        }
        finally {
            request.release();
            request2.release();
            response.release();
            response2.release();
        }
    }

    @Test
    public void propagateSettings() throws Exception {
        this.boostrapEnv(1, 1, 2);
        final Http2Settings settings = new Http2Settings().pushEnabled(true);
        Http2TestUtil.runInChannel(this.clientChannel, new Http2TestUtil.Http2Runnable(){

            @Override
            public void run() {
                InboundHttp2ToHttpAdapterTest.this.clientHandler.encoder().writeSettings(InboundHttp2ToHttpAdapterTest.this.ctxClient(), settings, InboundHttp2ToHttpAdapterTest.this.newPromiseClient());
                InboundHttp2ToHttpAdapterTest.this.clientChannel.flush();
            }
        });
        Assert.assertTrue((boolean)this.settingsLatch.await(5L, TimeUnit.SECONDS));
        ArgumentCaptor settingsCaptor = ArgumentCaptor.forClass(Http2Settings.class);
        ((HttpSettingsListener)Mockito.verify((Object)this.settingsListener, (VerificationMode)Mockito.times((int)2))).messageReceived((Http2Settings)settingsCaptor.capture());
        Assert.assertEquals((Object)settings, (Object)settingsCaptor.getValue());
    }

    private void boostrapEnv(int clientLatchCount, int serverLatchCount, int settingsLatchCount) throws InterruptedException {
        this.boostrapEnv(clientLatchCount, clientLatchCount, serverLatchCount, serverLatchCount, settingsLatchCount);
    }

    private void boostrapEnv(int clientLatchCount, int clientLatchCount2, int serverLatchCount, int serverLatchCount2, int settingsLatchCount) throws InterruptedException {
        final CountDownLatch prefaceWrittenLatch = new CountDownLatch(1);
        this.clientDelegator = null;
        this.serverDelegator = null;
        this.serverConnectedChannel = null;
        this.maxContentLength = 1024;
        final CountDownLatch serverChannelLatch = new CountDownLatch(1);
        this.serverLatch = new CountDownLatch(serverLatchCount);
        this.clientLatch = new CountDownLatch(clientLatchCount);
        this.serverLatch2 = new CountDownLatch(serverLatchCount2);
        this.clientLatch2 = new CountDownLatch(clientLatchCount2);
        this.settingsLatch = new CountDownLatch(settingsLatchCount);
        this.sb = new ServerBootstrap();
        this.cb = new Bootstrap();
        this.sb.group((EventLoopGroup)new DefaultEventLoopGroup());
        this.sb.channel(LocalServerChannel.class);
        this.sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                InboundHttp2ToHttpAdapterTest.this.serverConnectedChannel = ch;
                ChannelPipeline p = ch.pipeline();
                DefaultHttp2Connection connection = new DefaultHttp2Connection(true);
                InboundHttp2ToHttpAdapterTest.this.serverHandler = new Http2ConnectionHandlerBuilder().frameListener((Http2FrameListener)new InboundHttp2ToHttpAdapterBuilder((Http2Connection)connection).maxContentLength(InboundHttp2ToHttpAdapterTest.this.maxContentLength).validateHttpHeaders(true).propagateSettings(true).build()).connection((Http2Connection)connection).gracefulShutdownTimeoutMillis(0L).build();
                p.addLast(new ChannelHandler[]{InboundHttp2ToHttpAdapterTest.this.serverHandler});
                InboundHttp2ToHttpAdapterTest.this.serverDelegator = new HttpResponseDelegator(InboundHttp2ToHttpAdapterTest.this.serverListener, InboundHttp2ToHttpAdapterTest.this.serverLatch, InboundHttp2ToHttpAdapterTest.this.serverLatch2);
                p.addLast(new ChannelHandler[]{InboundHttp2ToHttpAdapterTest.this.serverDelegator});
                InboundHttp2ToHttpAdapterTest.this.settingsDelegator = new HttpSettingsDelegator(InboundHttp2ToHttpAdapterTest.this.settingsListener, InboundHttp2ToHttpAdapterTest.this.settingsLatch);
                p.addLast(new ChannelHandler[]{InboundHttp2ToHttpAdapterTest.this.settingsDelegator});
                serverChannelLatch.countDown();
            }
        });
        this.cb.group((EventLoopGroup)new DefaultEventLoopGroup());
        this.cb.channel(LocalChannel.class);
        this.cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
                InboundHttp2ToHttpAdapterTest.this.clientHandler = new Http2ConnectionHandlerBuilder().frameListener((Http2FrameListener)new InboundHttp2ToHttpAdapterBuilder((Http2Connection)connection).maxContentLength(InboundHttp2ToHttpAdapterTest.this.maxContentLength).build()).connection((Http2Connection)connection).gracefulShutdownTimeoutMillis(0L).build();
                p.addLast(new ChannelHandler[]{InboundHttp2ToHttpAdapterTest.this.clientHandler});
                InboundHttp2ToHttpAdapterTest.this.clientDelegator = new HttpResponseDelegator(InboundHttp2ToHttpAdapterTest.this.clientListener, InboundHttp2ToHttpAdapterTest.this.clientLatch, InboundHttp2ToHttpAdapterTest.this.clientLatch2);
                p.addLast(new ChannelHandler[]{InboundHttp2ToHttpAdapterTest.this.clientDelegator});
                p.addLast(new ChannelHandler[]{new ChannelHandlerAdapter(){

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        Http2Exception e = Http2CodecUtil.getEmbeddedHttp2Exception((Throwable)cause);
                        if (e != null) {
                            InboundHttp2ToHttpAdapterTest.this.clientException = e;
                            InboundHttp2ToHttpAdapterTest.this.clientLatch.countDown();
                        } else {
                            super.exceptionCaught(ctx, cause);
                        }
                    }
                }});
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt == Http2ConnectionPrefaceAndSettingsFrameWrittenEvent.INSTANCE) {
                            prefaceWrittenLatch.countDown();
                            ctx.pipeline().remove((ChannelHandler)this);
                        }
                    }
                }});
            }
        });
        this.serverChannel = this.sb.bind((SocketAddress)new LocalAddress("InboundHttp2ToHttpAdapterTest")).sync().channel();
        ChannelFuture ccf = this.cb.connect(this.serverChannel.localAddress());
        Assert.assertTrue((boolean)ccf.awaitUninterruptibly().isSuccess());
        this.clientChannel = ccf.channel();
        Assert.assertTrue((boolean)prefaceWrittenLatch.await(5L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)serverChannelLatch.await(5L, TimeUnit.SECONDS));
    }

    private void cleanupCapturedRequests() {
        if (this.capturedRequests != null) {
            for (FullHttpMessage capturedRequest : this.capturedRequests) {
                capturedRequest.release();
            }
            this.capturedRequests = null;
        }
    }

    private void cleanupCapturedResponses() {
        if (this.capturedResponses != null) {
            for (FullHttpMessage capturedResponse : this.capturedResponses) {
                capturedResponse.release();
            }
            this.capturedResponses = null;
        }
    }

    private void awaitRequests() throws Exception {
        Assert.assertTrue((boolean)this.serverLatch.await(5L, TimeUnit.SECONDS));
    }

    private void awaitResponses() throws Exception {
        Assert.assertTrue((boolean)this.clientLatch.await(5L, TimeUnit.SECONDS));
    }

    private void awaitRequests2() throws Exception {
        Assert.assertTrue((boolean)this.serverLatch2.await(5L, TimeUnit.SECONDS));
    }

    private void awaitResponses2() throws Exception {
        Assert.assertTrue((boolean)this.clientLatch2.await(5L, TimeUnit.SECONDS));
    }

    private ChannelHandlerContext ctxClient() {
        return this.clientChannel.pipeline().firstContext();
    }

    private ChannelPromise newPromiseClient() {
        return this.ctxClient().newPromise();
    }

    private ChannelHandlerContext ctxServer() {
        return this.serverConnectedChannel.pipeline().firstContext();
    }

    private ChannelPromise newPromiseServer() {
        return this.ctxServer().newPromise();
    }

    private static final class HttpSettingsDelegator
    extends SimpleChannelInboundHandler<Http2Settings> {
        private final HttpSettingsListener listener;
        private final CountDownLatch latch;

        HttpSettingsDelegator(HttpSettingsListener listener, CountDownLatch latch) {
            super(false);
            this.listener = listener;
            this.latch = latch;
        }

        protected void channelRead0(ChannelHandlerContext ctx, Http2Settings settings) throws Exception {
            this.listener.messageReceived(settings);
            this.latch.countDown();
        }
    }

    private static final class HttpResponseDelegator
    extends SimpleChannelInboundHandler<HttpObject> {
        private final HttpResponseListener listener;
        private final CountDownLatch latch;
        private final CountDownLatch latch2;

        HttpResponseDelegator(HttpResponseListener listener, CountDownLatch latch, CountDownLatch latch2) {
            super(false);
            this.listener = listener;
            this.latch = latch;
            this.latch2 = latch2;
        }

        protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
            this.listener.messageReceived(msg);
            this.latch.countDown();
            this.latch2.countDown();
        }
    }

    private static interface HttpSettingsListener {
        public void messageReceived(Http2Settings var1);
    }

    private static interface HttpResponseListener {
        public void messageReceived(HttpObject var1);
    }
}

