/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.HpackDecoder;
import io.netty.handler.codec.http2.HpackEncoder;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameSizePolicy;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.StreamByteDistributor;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import junit.framework.AssertionFailedError;
import org.junit.Assert;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public final class Http2TestUtil {
    static void runInChannel(Channel channel, final Http2Runnable runnable) {
        channel.eventLoop().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Http2Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static byte[] randomBytes() {
        return Http2TestUtil.randomBytes(100);
    }

    public static byte[] randomBytes(int size) {
        byte[] data = new byte[size];
        new Random().nextBytes(data);
        return data;
    }

    public static AsciiString randomString() {
        return new AsciiString(Http2TestUtil.randomBytes());
    }

    public static CharSequence of(String s) {
        return s;
    }

    public static HpackEncoder newTestEncoder() {
        try {
            return Http2TestUtil.newTestEncoder(true, 0xFFFFFFFFL, 0xFFFFFFFFL);
        }
        catch (Http2Exception e) {
            throw new Error("max size not allowed?", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HpackEncoder newTestEncoder(boolean ignoreMaxHeaderListSize, long maxHeaderListSize, long maxHeaderTableSize) throws Http2Exception {
        HpackEncoder hpackEncoder = new HpackEncoder(false, 16, 0);
        ByteBuf buf = Unpooled.buffer();
        try {
            hpackEncoder.setMaxHeaderTableSize(buf, maxHeaderTableSize);
            hpackEncoder.setMaxHeaderListSize(maxHeaderListSize);
        }
        finally {
            buf.release();
        }
        return hpackEncoder;
    }

    public static HpackDecoder newTestDecoder() {
        try {
            return Http2TestUtil.newTestDecoder(0xFFFFFFFFL, 0xFFFFFFFFL);
        }
        catch (Http2Exception e) {
            throw new Error("max size not allowed?", e);
        }
    }

    public static HpackDecoder newTestDecoder(long maxHeaderListSize, long maxHeaderTableSize) throws Http2Exception {
        HpackDecoder hpackDecoder = new HpackDecoder(maxHeaderListSize);
        hpackDecoder.setMaxHeaderTableSize(maxHeaderTableSize);
        return hpackDecoder;
    }

    private Http2TestUtil() {
    }

    static ChannelPromise newVoidPromise(final Channel channel) {
        return new DefaultChannelPromise(channel, (EventExecutor)ImmediateEventExecutor.INSTANCE){

            public ChannelPromise addListener(GenericFutureListener<? extends Future<? super Void>> listener) {
                throw new AssertionFailedError();
            }

            public ChannelPromise addListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
                throw new AssertionFailedError();
            }

            public boolean isVoid() {
                return true;
            }

            public boolean tryFailure(Throwable cause) {
                this.channel().pipeline().fireExceptionCaught(cause);
                return true;
            }

            public ChannelPromise setFailure(Throwable cause) {
                this.tryFailure(cause);
                return this;
            }

            public ChannelPromise unvoid() {
                DefaultChannelPromise promise = new DefaultChannelPromise(channel, (EventExecutor)ImmediateEventExecutor.INSTANCE);
                promise.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            this.channel().pipeline().fireExceptionCaught(future.cause());
                        }
                    }
                });
                return promise;
            }
        };
    }

    static Http2FrameWriter mockedFrameWriter() {
        Http2FrameWriter.Configuration configuration = new Http2FrameWriter.Configuration(){
            private final Http2HeadersEncoder.Configuration headerConfiguration = new Http2HeadersEncoder.Configuration(){

                public void maxHeaderTableSize(long max) {
                }

                public long maxHeaderTableSize() {
                    return 0L;
                }

                public void maxHeaderListSize(long max) {
                }

                public long maxHeaderListSize() {
                    return 0L;
                }
            };
            private final Http2FrameSizePolicy policy = new Http2FrameSizePolicy(){

                public void maxFrameSize(int max) {
                }

                public int maxFrameSize() {
                    return 0;
                }
            };

            public Http2HeadersEncoder.Configuration headersConfiguration() {
                return this.headerConfiguration;
            }

            public Http2FrameSizePolicy frameSizePolicy() {
                return this.policy;
            }
        };
        final ConcurrentLinkedQueue buffers = new ConcurrentLinkedQueue();
        Http2FrameWriter frameWriter = (Http2FrameWriter)Mockito.mock(Http2FrameWriter.class);
        ((Http2FrameWriter)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) {
                ByteBuf buf;
                while ((buf = (ByteBuf)buffers.poll()) != null) {
                    buf.release();
                }
                return null;
            }
        }).when((Object)frameWriter)).close();
        Mockito.when((Object)frameWriter.configuration()).thenReturn((Object)configuration);
        Mockito.when((Object)frameWriter.writeSettings((ChannelHandlerContext)ArgumentMatchers.any(ChannelHandlerContext.class), (Http2Settings)ArgumentMatchers.any(Http2Settings.class), (ChannelPromise)ArgumentMatchers.any(ChannelPromise.class))).thenAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocationOnMock) {
                return ((ChannelPromise)invocationOnMock.getArgument(2)).setSuccess();
            }
        });
        Mockito.when((Object)frameWriter.writeSettingsAck((ChannelHandlerContext)ArgumentMatchers.any(ChannelHandlerContext.class), (ChannelPromise)ArgumentMatchers.any(ChannelPromise.class))).thenAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocationOnMock) {
                return ((ChannelPromise)invocationOnMock.getArgument(1)).setSuccess();
            }
        });
        Mockito.when((Object)frameWriter.writeGoAway((ChannelHandlerContext)ArgumentMatchers.any(ChannelHandlerContext.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), (ByteBuf)ArgumentMatchers.any(ByteBuf.class), (ChannelPromise)ArgumentMatchers.any(ChannelPromise.class))).thenAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocationOnMock) {
                buffers.offer((ByteBuf)invocationOnMock.getArgument(3));
                return ((ChannelPromise)invocationOnMock.getArgument(4)).setSuccess();
            }
        });
        Mockito.when((Object)frameWriter.writeHeaders((ChannelHandlerContext)ArgumentMatchers.any(ChannelHandlerContext.class), ArgumentMatchers.anyInt(), (Http2Headers)ArgumentMatchers.any(Http2Headers.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean(), (ChannelPromise)ArgumentMatchers.any(ChannelPromise.class))).thenAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocationOnMock) {
                return ((ChannelPromise)invocationOnMock.getArgument(5)).setSuccess();
            }
        });
        Mockito.when((Object)frameWriter.writeHeaders((ChannelHandlerContext)ArgumentMatchers.any(ChannelHandlerContext.class), ArgumentMatchers.anyInt(), (Http2Headers)ArgumentMatchers.any(Http2Headers.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyShort(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean(), (ChannelPromise)ArgumentMatchers.any(ChannelPromise.class))).thenAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocationOnMock) {
                return ((ChannelPromise)invocationOnMock.getArgument(8)).setSuccess();
            }
        });
        Mockito.when((Object)frameWriter.writeData((ChannelHandlerContext)ArgumentMatchers.any(ChannelHandlerContext.class), ArgumentMatchers.anyInt(), (ByteBuf)ArgumentMatchers.any(ByteBuf.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean(), (ChannelPromise)ArgumentMatchers.any(ChannelPromise.class))).thenAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocationOnMock) {
                buffers.offer((ByteBuf)invocationOnMock.getArgument(2));
                return ((ChannelPromise)invocationOnMock.getArgument(5)).setSuccess();
            }
        });
        Mockito.when((Object)frameWriter.writeRstStream((ChannelHandlerContext)ArgumentMatchers.any(ChannelHandlerContext.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), (ChannelPromise)ArgumentMatchers.any(ChannelPromise.class))).thenAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocationOnMock) {
                return ((ChannelPromise)invocationOnMock.getArgument(3)).setSuccess();
            }
        });
        Mockito.when((Object)frameWriter.writeWindowUpdate((ChannelHandlerContext)ArgumentMatchers.any(ChannelHandlerContext.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), (ChannelPromise)ArgumentMatchers.any(ChannelPromise.class))).then((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocationOnMock) {
                return ((ChannelPromise)invocationOnMock.getArgument(3)).setSuccess();
            }
        });
        Mockito.when((Object)frameWriter.writePushPromise((ChannelHandlerContext)ArgumentMatchers.any(ChannelHandlerContext.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), (Http2Headers)ArgumentMatchers.any(Http2Headers.class), ArgumentMatchers.anyInt(), Http2TestUtil.anyChannelPromise())).thenAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocationOnMock) {
                return ((ChannelPromise)invocationOnMock.getArgument(5)).setSuccess();
            }
        });
        Mockito.when((Object)frameWriter.writeFrame((ChannelHandlerContext)ArgumentMatchers.any(ChannelHandlerContext.class), ArgumentMatchers.anyByte(), ArgumentMatchers.anyInt(), (Http2Flags)ArgumentMatchers.any(Http2Flags.class), (ByteBuf)ArgumentMatchers.any(ByteBuf.class), Http2TestUtil.anyChannelPromise())).thenAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocationOnMock) {
                buffers.offer((ByteBuf)invocationOnMock.getArgument(4));
                return ((ChannelPromise)invocationOnMock.getArgument(5)).setSuccess();
            }
        });
        return frameWriter;
    }

    static ChannelPromise anyChannelPromise() {
        return (ChannelPromise)ArgumentMatchers.any(ChannelPromise.class);
    }

    static Http2Settings anyHttp2Settings() {
        return (Http2Settings)ArgumentMatchers.any(Http2Settings.class);
    }

    static ByteBuf bb(String s) {
        return ByteBufUtil.writeUtf8((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (CharSequence)s);
    }

    static ByteBuf bb(int size) {
        return UnpooledByteBufAllocator.DEFAULT.buffer().writeZero(size);
    }

    static void assertEqualsAndRelease(Http2Frame expected, Http2Frame actual) {
        try {
            Assert.assertEquals((Object)expected, (Object)actual);
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release((Object)expected);
            ReferenceCountUtil.release((Object)actual);
            Assert.assertTrue((ReferenceCountUtil.refCnt((Object)expected) <= 0 ? 1 : 0) != 0);
            Assert.assertTrue((ReferenceCountUtil.refCnt((Object)actual) <= 0 ? 1 : 0) != 0);
            throw throwable;
        }
        ReferenceCountUtil.release((Object)expected);
        ReferenceCountUtil.release((Object)actual);
        Assert.assertTrue((ReferenceCountUtil.refCnt((Object)expected) <= 0 ? 1 : 0) != 0);
        Assert.assertTrue((ReferenceCountUtil.refCnt((Object)actual) <= 0 ? 1 : 0) != 0);
    }

    static final class TestStreamByteDistributorStreamState
    implements StreamByteDistributor.StreamState {
        private final Http2Stream stream;
        boolean isWriteAllowed;
        long pendingBytes;
        boolean hasFrame;

        TestStreamByteDistributorStreamState(Http2Stream stream, long pendingBytes, boolean hasFrame, boolean isWriteAllowed) {
            this.stream = stream;
            this.isWriteAllowed = isWriteAllowed;
            this.pendingBytes = pendingBytes;
            this.hasFrame = hasFrame;
        }

        public Http2Stream stream() {
            return this.stream;
        }

        public long pendingBytes() {
            return this.pendingBytes;
        }

        public boolean hasFrame() {
            return this.hasFrame;
        }

        public int windowSize() {
            return this.isWriteAllowed ? (int)Math.min(this.pendingBytes, Integer.MAX_VALUE) : -1;
        }
    }

    static class FrameCountDown
    implements Http2FrameListener {
        private final Http2FrameListener listener;
        private final CountDownLatch messageLatch;
        private final CountDownLatch settingsAckLatch;
        private final CountDownLatch dataLatch;
        private final CountDownLatch trailersLatch;
        private final CountDownLatch goAwayLatch;

        FrameCountDown(Http2FrameListener listener, CountDownLatch settingsAckLatch, CountDownLatch messageLatch) {
            this(listener, settingsAckLatch, messageLatch, null, null);
        }

        FrameCountDown(Http2FrameListener listener, CountDownLatch settingsAckLatch, CountDownLatch messageLatch, CountDownLatch dataLatch, CountDownLatch trailersLatch) {
            this(listener, settingsAckLatch, messageLatch, dataLatch, trailersLatch, messageLatch);
        }

        FrameCountDown(Http2FrameListener listener, CountDownLatch settingsAckLatch, CountDownLatch messageLatch, CountDownLatch dataLatch, CountDownLatch trailersLatch, CountDownLatch goAwayLatch) {
            this.listener = listener;
            this.messageLatch = messageLatch;
            this.settingsAckLatch = settingsAckLatch;
            this.dataLatch = dataLatch;
            this.trailersLatch = trailersLatch;
            this.goAwayLatch = goAwayLatch;
        }

        public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
            int numBytes = data.readableBytes();
            int processed = this.listener.onDataRead(ctx, streamId, data, padding, endOfStream);
            this.messageLatch.countDown();
            if (this.dataLatch != null) {
                for (int i = 0; i < numBytes; ++i) {
                    this.dataLatch.countDown();
                }
            }
            return processed;
        }

        public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream) throws Http2Exception {
            this.listener.onHeadersRead(ctx, streamId, headers, padding, endStream);
            this.messageLatch.countDown();
            if (this.trailersLatch != null && endStream) {
                this.trailersLatch.countDown();
            }
        }

        public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
            this.listener.onHeadersRead(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endStream);
            this.messageLatch.countDown();
            if (this.trailersLatch != null && endStream) {
                this.trailersLatch.countDown();
            }
        }

        public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) throws Http2Exception {
            this.listener.onPriorityRead(ctx, streamId, streamDependency, weight, exclusive);
            this.messageLatch.countDown();
        }

        public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
            this.listener.onRstStreamRead(ctx, streamId, errorCode);
            this.messageLatch.countDown();
        }

        public void onSettingsAckRead(ChannelHandlerContext ctx) throws Http2Exception {
            this.listener.onSettingsAckRead(ctx);
            this.settingsAckLatch.countDown();
        }

        public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) throws Http2Exception {
            this.listener.onSettingsRead(ctx, settings);
            this.messageLatch.countDown();
        }

        public void onPingRead(ChannelHandlerContext ctx, long data) throws Http2Exception {
            this.listener.onPingRead(ctx, data);
            this.messageLatch.countDown();
        }

        public void onPingAckRead(ChannelHandlerContext ctx, long data) throws Http2Exception {
            this.listener.onPingAckRead(ctx, data);
            this.messageLatch.countDown();
        }

        public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
            this.listener.onPushPromiseRead(ctx, streamId, promisedStreamId, headers, padding);
            this.messageLatch.countDown();
        }

        public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
            this.listener.onGoAwayRead(ctx, lastStreamId, errorCode, debugData);
            this.goAwayLatch.countDown();
        }

        public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) throws Http2Exception {
            this.listener.onWindowUpdateRead(ctx, streamId, windowSizeIncrement);
            this.messageLatch.countDown();
        }

        public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) throws Http2Exception {
            this.listener.onUnknownFrame(ctx, frameType, streamId, flags, payload);
            this.messageLatch.countDown();
        }
    }

    static class FrameAdapter
    extends ByteToMessageDecoder {
        private final Http2Connection connection;
        private final Http2FrameListener listener;
        private final DefaultHttp2FrameReader reader;
        private final CountDownLatch latch;

        FrameAdapter(Http2FrameListener listener, CountDownLatch latch) {
            this(null, listener, latch);
        }

        FrameAdapter(Http2Connection connection, Http2FrameListener listener, CountDownLatch latch) {
            this(connection, new DefaultHttp2FrameReader(false), listener, latch);
        }

        FrameAdapter(Http2Connection connection, DefaultHttp2FrameReader reader, Http2FrameListener listener, CountDownLatch latch) {
            this.connection = connection;
            this.listener = listener;
            this.reader = reader;
            this.latch = latch;
        }

        private Http2Stream getOrCreateStream(int streamId, boolean halfClosed) throws Http2Exception {
            return FrameAdapter.getOrCreateStream(this.connection, streamId, halfClosed);
        }

        public static Http2Stream getOrCreateStream(Http2Connection connection, int streamId, boolean halfClosed) throws Http2Exception {
            if (connection != null) {
                Http2Stream stream = connection.stream(streamId);
                if (stream == null) {
                    stream = connection.isServer() && streamId % 2 == 0 || !connection.isServer() && streamId % 2 != 0 ? connection.local().createStream(streamId, halfClosed) : connection.remote().createStream(streamId, halfClosed);
                }
                return stream;
            }
            return null;
        }

        private void closeStream(Http2Stream stream) {
            this.closeStream(stream, false);
        }

        protected void closeStream(Http2Stream stream, boolean dataRead) {
            if (stream != null) {
                stream.close();
            }
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            this.reader.readFrame(ctx, in, new Http2FrameListener(){

                public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
                    Http2Stream stream = FrameAdapter.this.getOrCreateStream(streamId, endOfStream);
                    int processed = FrameAdapter.this.listener.onDataRead(ctx, streamId, data, padding, endOfStream);
                    if (endOfStream) {
                        FrameAdapter.this.closeStream(stream, true);
                    }
                    FrameAdapter.this.latch.countDown();
                    return processed;
                }

                public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream) throws Http2Exception {
                    Http2Stream stream = FrameAdapter.this.getOrCreateStream(streamId, endStream);
                    FrameAdapter.this.listener.onHeadersRead(ctx, streamId, headers, padding, endStream);
                    if (endStream) {
                        FrameAdapter.this.closeStream(stream);
                    }
                    FrameAdapter.this.latch.countDown();
                }

                public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
                    Http2Stream stream = FrameAdapter.this.getOrCreateStream(streamId, endStream);
                    FrameAdapter.this.listener.onHeadersRead(ctx, streamId, headers, streamDependency, weight, exclusive, padding, endStream);
                    if (endStream) {
                        FrameAdapter.this.closeStream(stream);
                    }
                    FrameAdapter.this.latch.countDown();
                }

                public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) throws Http2Exception {
                    FrameAdapter.this.listener.onPriorityRead(ctx, streamId, streamDependency, weight, exclusive);
                    FrameAdapter.this.latch.countDown();
                }

                public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
                    Http2Stream stream = FrameAdapter.this.getOrCreateStream(streamId, false);
                    FrameAdapter.this.listener.onRstStreamRead(ctx, streamId, errorCode);
                    FrameAdapter.this.closeStream(stream);
                    FrameAdapter.this.latch.countDown();
                }

                public void onSettingsAckRead(ChannelHandlerContext ctx) throws Http2Exception {
                    FrameAdapter.this.listener.onSettingsAckRead(ctx);
                    FrameAdapter.this.latch.countDown();
                }

                public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) throws Http2Exception {
                    FrameAdapter.this.listener.onSettingsRead(ctx, settings);
                    FrameAdapter.this.latch.countDown();
                }

                public void onPingRead(ChannelHandlerContext ctx, long data) throws Http2Exception {
                    FrameAdapter.this.listener.onPingRead(ctx, data);
                    FrameAdapter.this.latch.countDown();
                }

                public void onPingAckRead(ChannelHandlerContext ctx, long data) throws Http2Exception {
                    FrameAdapter.this.listener.onPingAckRead(ctx, data);
                    FrameAdapter.this.latch.countDown();
                }

                public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
                    FrameAdapter.this.getOrCreateStream(promisedStreamId, false);
                    FrameAdapter.this.listener.onPushPromiseRead(ctx, streamId, promisedStreamId, headers, padding);
                    FrameAdapter.this.latch.countDown();
                }

                public void onGoAwayRead(ChannelHandlerContext ctx, int lastStreamId, long errorCode, ByteBuf debugData) throws Http2Exception {
                    FrameAdapter.this.listener.onGoAwayRead(ctx, lastStreamId, errorCode, debugData);
                    FrameAdapter.this.latch.countDown();
                }

                public void onWindowUpdateRead(ChannelHandlerContext ctx, int streamId, int windowSizeIncrement) throws Http2Exception {
                    FrameAdapter.this.getOrCreateStream(streamId, false);
                    FrameAdapter.this.listener.onWindowUpdateRead(ctx, streamId, windowSizeIncrement);
                    FrameAdapter.this.latch.countDown();
                }

                public void onUnknownFrame(ChannelHandlerContext ctx, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) throws Http2Exception {
                    FrameAdapter.this.listener.onUnknownFrame(ctx, frameType, streamId, flags, payload);
                    FrameAdapter.this.latch.countDown();
                }
            });
        }
    }

    static interface Http2Runnable {
        public void run() throws Http2Exception;
    }
}

