/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamChannel;
import org.junit.Assert;
import org.junit.Test;

public abstract class Http2MultiplexClientUpgradeTest<C extends Http2FrameCodec> {
    protected abstract C newCodec(ChannelHandler var1);

    protected abstract ChannelHandler newMultiplexer(ChannelHandler var1);

    @Test
    public void upgradeHandlerGetsActivated() throws Exception {
        UpgradeHandler upgradeHandler = new UpgradeHandler();
        C codec = this.newCodec((ChannelHandler)upgradeHandler);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{codec, this.newMultiplexer((ChannelHandler)upgradeHandler)});
        codec.onHttpClientUpgrade();
        Assert.assertFalse((boolean)upgradeHandler.stateOnActive.localSideOpen());
        Assert.assertTrue((boolean)upgradeHandler.stateOnActive.remoteSideOpen());
        Assert.assertNotNull((Object)codec.connection().stream(1).getProperty(((Http2FrameCodec)codec).streamKey));
        Assert.assertEquals((long)1L, (long)upgradeHandler.streamId);
        Assert.assertTrue((boolean)ch.finishAndReleaseAll());
        Assert.assertTrue((boolean)upgradeHandler.channelInactiveCalled);
    }

    @Test(expected=Http2Exception.class)
    public void clientUpgradeWithoutUpgradeHandlerThrowsHttp2Exception() throws Http2Exception {
        C codec = this.newCodec(null);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{codec, this.newMultiplexer(null)});
        try {
            codec.onHttpClientUpgrade();
        }
        finally {
            Assert.assertTrue((boolean)ch.finishAndReleaseAll());
        }
    }

    private static final class UpgradeHandler
    extends ChannelInboundHandlerAdapter {
        Http2Stream.State stateOnActive;
        int streamId;
        boolean channelInactiveCalled;

        private UpgradeHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            Http2StreamChannel ch = (Http2StreamChannel)ctx.channel();
            this.stateOnActive = ch.stream().state();
            this.streamId = ch.stream().id();
            super.channelActive(ctx);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.channelInactiveCalled = true;
            super.channelInactive(ctx);
        }
    }

    @ChannelHandler.Sharable
    static final class NoopHandler
    extends ChannelInboundHandlerAdapter {
        NoopHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) {
            ctx.channel().close();
        }
    }
}

