/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.HpackTestCase;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.ResourcesUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HpackTest {
    private static final String TEST_DIR = '/' + HpackTest.class.getPackage().getName().replaceAll("\\.", "/") + "/testdata/";
    private final String fileName;

    public HpackTest(String fileName) {
        this.fileName = fileName;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        File[] files = ResourcesUtil.getFile(HpackTest.class, (String)TEST_DIR).listFiles();
        ObjectUtil.checkNotNull((Object)files, (String)"files");
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (File file : files) {
            data.add(new Object[]{file.getName()});
        }
        return data;
    }

    @Test
    public void test() throws Exception {
        InputStream is = HpackTest.class.getResourceAsStream(TEST_DIR + this.fileName);
        HpackTestCase hpackTestCase = HpackTestCase.load(is);
        hpackTestCase.testCompress();
        hpackTestCase.testDecompress();
    }
}

